/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batchai.implementation;

import org.joda.time.DateTime;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;

/**
 * Properties of the file or directory.
 */
@JsonFlatten
public class FileInner {
    /**
     * Name of the file.
     */
    @JsonProperty(value = "name", required = true)
    private String name;

    /**
     * Indicates if the file is a directory.
     */
    @JsonProperty(value = "isDirectory", required = true)
    private boolean isDirectory;

    /**
     * Will contain an URL to download the corresponding file. The downloadUrl
     * is not returned for directories.
     */
    @JsonProperty(value = "downloadUrl")
    private String downloadUrl;

    /**
     * The time at which the file was last modified.
     * The time at which the file was last modified.
     */
    @JsonProperty(value = "properties.lastModified")
    private DateTime lastModified;

    /**
     * The file size.
     * The file size.
     */
    @JsonProperty(value = "properties.contentLength")
    private Long contentLength;

    /**
     * Get the name value.
     *
     * @return the name value
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name value.
     *
     * @param name the name value to set
     * @return the FileInner object itself.
     */
    public FileInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the isDirectory value.
     *
     * @return the isDirectory value
     */
    public boolean isDirectory() {
        return this.isDirectory;
    }

    /**
     * Set the isDirectory value.
     *
     * @param isDirectory the isDirectory value to set
     * @return the FileInner object itself.
     */
    public FileInner withIsDirectory(boolean isDirectory) {
        this.isDirectory = isDirectory;
        return this;
    }

    /**
     * Get the downloadUrl value.
     *
     * @return the downloadUrl value
     */
    public String downloadUrl() {
        return this.downloadUrl;
    }

    /**
     * Set the downloadUrl value.
     *
     * @param downloadUrl the downloadUrl value to set
     * @return the FileInner object itself.
     */
    public FileInner withDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
        return this;
    }

    /**
     * Get the lastModified value.
     *
     * @return the lastModified value
     */
    public DateTime lastModified() {
        return this.lastModified;
    }

    /**
     * Set the lastModified value.
     *
     * @param lastModified the lastModified value to set
     * @return the FileInner object itself.
     */
    public FileInner withLastModified(DateTime lastModified) {
        this.lastModified = lastModified;
        return this;
    }

    /**
     * Get the contentLength value.
     *
     * @return the contentLength value
     */
    public Long contentLength() {
        return this.contentLength;
    }

    /**
     * Set the contentLength value.
     *
     * @param contentLength the contentLength value to set
     * @return the FileInner object itself.
     */
    public FileInner withContentLength(Long contentLength) {
        this.contentLength = contentLength;
        return this;
    }

}
