/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.batchai;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.apigeneration.Method;
import com.microsoft.azure.management.batchai.BatchAICluster;
import com.microsoft.azure.management.batchai.CNTKsettings;
import com.microsoft.azure.management.batchai.CaffeSettings;
import com.microsoft.azure.management.batchai.ChainerSettings;
import com.microsoft.azure.management.batchai.ContainerImageSettings;
import com.microsoft.azure.management.batchai.ContainerSettings;
import com.microsoft.azure.management.batchai.CustomToolkitSettings;
import com.microsoft.azure.management.batchai.EnvironmentVariable;
import com.microsoft.azure.management.batchai.EnvironmentVariableWithSecretValue;
import com.microsoft.azure.management.batchai.ExecutionState;
import com.microsoft.azure.management.batchai.InputDirectory;
import com.microsoft.azure.management.batchai.JobPreparation;
import com.microsoft.azure.management.batchai.JobPropertiesConstraints;
import com.microsoft.azure.management.batchai.JobPropertiesExecutionInfo;
import com.microsoft.azure.management.batchai.MountVolumes;
import com.microsoft.azure.management.batchai.OutputDirectory;
import com.microsoft.azure.management.batchai.OutputDirectorySettings;
import com.microsoft.azure.management.batchai.OutputFile;
import com.microsoft.azure.management.batchai.ProvisioningState;
import com.microsoft.azure.management.batchai.PyTorchSettings;
import com.microsoft.azure.management.batchai.ResourceId;
import com.microsoft.azure.management.batchai.TensorFlowSettings;
import com.microsoft.azure.management.batchai.ToolType;
import com.microsoft.azure.management.batchai.ToolTypeSettings;
import com.microsoft.azure.management.batchai.implementation.BatchAIManager;
import com.microsoft.azure.management.batchai.implementation.JobInner;
import com.microsoft.azure.management.batchai.model.HasMountVolumes;
import com.microsoft.azure.management.resources.fluentcore.arm.models.HasParent;
import com.microsoft.azure.management.resources.fluentcore.arm.models.IndependentChildResource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import java.util.List;
import org.joda.time.DateTime;
import rx.Completable;
import rx.Observable;

@Fluent
@Beta(value=Beta.SinceVersion.V1_6_0)
public interface BatchAIJob
extends IndependentChildResource<BatchAIManager, JobInner>,
Refreshable<BatchAIJob>,
HasParent<BatchAICluster> {
    @Method
    public void terminate();

    @Method
    public Completable terminateAsync();

    @Method
    public PagedList<OutputFile> listFiles(String var1);

    @Method
    public Observable<OutputFile> listFilesAsync(String var1);

    @Method
    public PagedList<OutputFile> listFiles(String var1, String var2, Integer var3, Integer var4);

    @Method
    public Observable<OutputFile> listFilesAsync(String var1, String var2, Integer var3, Integer var4);

    public String experimentName();

    public Integer priority();

    public ResourceId cluster();

    public MountVolumes mountVolumes();

    public String jobOutputDirectoryPathSegment();

    public int nodeCount();

    public ContainerSettings containerSettings();

    public ToolType toolType();

    public CNTKsettings cntkSettings();

    public PyTorchSettings pyTorchSettings();

    public TensorFlowSettings tensorFlowSettings();

    public CaffeSettings caffeSettings();

    public ChainerSettings chainerSettings();

    public CustomToolkitSettings customToolkitSettings();

    public JobPreparation jobPreparation();

    public String stdOutErrPathPrefix();

    public List<InputDirectory> inputDirectories();

    public List<OutputDirectory> outputDirectories();

    public List<EnvironmentVariable> environmentVariables();

    public List<EnvironmentVariableWithSecretValue> secrets();

    public JobPropertiesConstraints constraints();

    public DateTime creationTime();

    public ProvisioningState provisioningState();

    public DateTime provisioningStateTransitionTime();

    public ExecutionState executionState();

    public DateTime executionStateTransitionTime();

    public JobPropertiesExecutionInfo executionInfo();

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<BatchAIJob>,
        Resource.DefinitionWithTags<WithCreate>,
        WithJobPreparation,
        WithInputDirectory,
        WithOutputDirectory,
        WithContainerSettings,
        WithExperimentName,
        WithEnvironmentVariable,
        WithEnvironmentVariableSecretValue,
        HasMountVolumes.DefinitionStages.WithMountVolumes<WithCreate> {
        }

        public static interface WithEnvironmentVariableSecretValue {
            public WithCreate withEnvironmentVariableSecretValue(String var1, String var2);

            public WithCreate withEnvironmentVariableSecretValue(String var1, String var2, String var3);
        }

        public static interface WithEnvironmentVariable {
            public WithCreate withEnvironmentVariable(String var1, String var2);
        }

        public static interface WithExperimentName {
            public WithCreate withExperimentName(String var1);
        }

        public static interface WithContainerSettings {
            public WithCreate withContainerImage(String var1);

            public ContainerImageSettings.DefinitionStages.Blank<WithCreate> defineContainerSettings(String var1);
        }

        public static interface WithJobPreparation {
            public WithCreate withCommandLine(String var1);
        }

        public static interface WithOutputDirectory {
            public WithCreate withOutputDirectory(String var1, String var2);

            @Method
            @Beta(value=Beta.SinceVersion.V1_8_0)
            public OutputDirectorySettings.DefinitionStages.Blank<WithCreate> defineOutputDirectory(String var1);
        }

        public static interface WithInputDirectory {
            public WithCreate withInputDirectory(String var1, String var2);
        }

        public static interface WithToolType {
            @Method
            public ToolTypeSettings.CognitiveToolkit.DefinitionStages.Blank<WithCreate> defineCognitiveToolkit();

            @Method
            public ToolTypeSettings.TensorFlow.DefinitionStages.Blank<WithCreate> defineTensorflow();

            @Method
            public ToolTypeSettings.Caffe.DefinitionStages.Blank<WithCreate> defineCaffe();

            @Method
            public ToolTypeSettings.Caffe2.DefinitionStages.Blank<WithCreate> defineCaffe2();

            @Method
            public ToolTypeSettings.Chainer.DefinitionStages.Blank<WithCreate> defineChainer();

            @Method
            @Beta(value=Beta.SinceVersion.V1_8_0)
            public ToolTypeSettings.PyTorch.DefinitionStages.Blank<WithCreate> definePyTorch();

            public WithCreate withCustomCommandLine(String var1);
        }

        public static interface WithNodeCount {
            public WithStdOutErrPathPrefix withNodeCount(int var1);
        }

        public static interface WithStdOutErrPathPrefix {
            public WithToolType withStdOutErrPathPrefix(String var1);
        }

        public static interface WithCluster {
            public WithNodeCount withExistingCluster(BatchAICluster var1);

            public WithNodeCount withExistingClusterId(String var1);
        }

        public static interface Blank
        extends WithCluster {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithStdOutErrPathPrefix,
    DefinitionStages.WithNodeCount,
    DefinitionStages.WithToolType,
    DefinitionStages.WithCreate {
    }
}

