/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.batchai.implementation;

import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.AzureResponseBuilder;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.batchai.BatchAIClusters;
import com.microsoft.azure.management.batchai.BatchAIFileServers;
import com.microsoft.azure.management.batchai.BatchAIJobs;
import com.microsoft.azure.management.batchai.BatchAIUsages;
import com.microsoft.azure.management.batchai.implementation.BatchAIClustersImpl;
import com.microsoft.azure.management.batchai.implementation.BatchAIFileServersImpl;
import com.microsoft.azure.management.batchai.implementation.BatchAIJobsImpl;
import com.microsoft.azure.management.batchai.implementation.BatchAIManagementClientImpl;
import com.microsoft.azure.management.batchai.implementation.BatchAIUsagesImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.AzureConfigurable;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.AzureConfigurableImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.Manager;
import com.microsoft.azure.management.resources.fluentcore.utils.ProviderRegistrationInterceptor;
import com.microsoft.azure.serializer.AzureJacksonAdapter;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import com.microsoft.rest.protocol.Environment;
import com.microsoft.rest.protocol.ResponseBuilder;
import com.microsoft.rest.protocol.SerializerAdapter;
import okhttp3.Interceptor;

@Beta(value=Beta.SinceVersion.V1_6_0)
public final class BatchAIManager
extends Manager<BatchAIManager, BatchAIManagementClientImpl> {
    private BatchAIClusters batchAIClusters;
    private BatchAIJobs batchAIJobs;
    private BatchAIFileServers batchAIFileServers;
    private BatchAIUsages batchAIUsages;

    public static Configurable configure() {
        return new ConfigurableImpl();
    }

    public static BatchAIManager authenticate(AzureTokenCredentials credentials, String subscriptionId) {
        return new BatchAIManager(new RestClient.Builder().withBaseUrl((Environment)credentials.environment(), (Environment.Endpoint)AzureEnvironment.Endpoint.RESOURCE_MANAGER).withCredentials((ServiceClientCredentials)credentials).withSerializerAdapter((SerializerAdapter)new AzureJacksonAdapter()).withResponseBuilderFactory((ResponseBuilder.Factory)new AzureResponseBuilder.Factory()).withInterceptor((Interceptor)new ProviderRegistrationInterceptor(credentials)).build(), subscriptionId);
    }

    public static BatchAIManager authenticate(RestClient restClient, String subscriptionId) {
        return new BatchAIManager(restClient, subscriptionId);
    }

    private BatchAIManager(RestClient restClient, String subscriptionId) {
        super(restClient, subscriptionId, (Object)new BatchAIManagementClientImpl(restClient).withSubscriptionId(subscriptionId));
    }

    public BatchAIClusters clusters() {
        if (this.batchAIClusters == null) {
            this.batchAIClusters = new BatchAIClustersImpl(this);
        }
        return this.batchAIClusters;
    }

    public BatchAIJobs jobs() {
        if (this.batchAIJobs == null) {
            this.batchAIJobs = new BatchAIJobsImpl(this);
        }
        return this.batchAIJobs;
    }

    public BatchAIFileServers fileServers() {
        if (this.batchAIFileServers == null) {
            this.batchAIFileServers = new BatchAIFileServersImpl(this);
        }
        return this.batchAIFileServers;
    }

    public BatchAIUsages usages() {
        if (this.batchAIUsages == null) {
            this.batchAIUsages = new BatchAIUsagesImpl((BatchAIManagementClientImpl)((Object)this.innerManagementClient));
        }
        return this.batchAIUsages;
    }

    private static final class ConfigurableImpl
    extends AzureConfigurableImpl<Configurable>
    implements Configurable {
        private ConfigurableImpl() {
        }

        @Override
        public BatchAIManager authenticate(AzureTokenCredentials credentials, String subscriptionId) {
            return BatchAIManager.authenticate(this.buildRestClient(credentials), subscriptionId);
        }
    }

    public static interface Configurable
    extends AzureConfigurable<Configurable> {
        public BatchAIManager authenticate(AzureTokenCredentials var1, String var2);
    }
}

