/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.batchai.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.batchai.BatchAIJob;
import com.microsoft.azure.management.batchai.ContainerImageSettings;
import com.microsoft.azure.management.batchai.ImageSourceRegistry;
import com.microsoft.azure.management.batchai.KeyVaultSecretReference;
import com.microsoft.azure.management.batchai.PrivateRegistryCredentials;
import com.microsoft.azure.management.batchai.ResourceId;
import com.microsoft.azure.management.batchai.implementation.BatchAIJobImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableWrapperImpl;

@LangDefinition
class ContainerImageSettingsImpl
extends IndexableWrapperImpl<ImageSourceRegistry>
implements ContainerImageSettings.Definition<BatchAIJob.DefinitionStages.WithCreate> {
    private BatchAIJobImpl parent;

    protected ContainerImageSettingsImpl(ImageSourceRegistry inner, BatchAIJobImpl parent) {
        super((Object)inner);
        this.parent = parent;
    }

    public BatchAIJob.DefinitionStages.WithCreate attach() {
        this.parent.attachImageSourceRegistry(this);
        return this.parent;
    }

    public ContainerImageSettingsImpl withRegistryUrl(String serverUrl) {
        ((ImageSourceRegistry)this.inner()).withServerUrl(serverUrl);
        return this;
    }

    public ContainerImageSettingsImpl withRegistryUsername(String username) {
        ((ImageSourceRegistry)this.inner()).withCredentials(new PrivateRegistryCredentials().withUsername(username));
        return this;
    }

    public ContainerImageSettingsImpl withRegistryPassword(String password) {
        ((ImageSourceRegistry)this.inner()).credentials().withPassword(password);
        return this;
    }

    public ContainerImageSettingsImpl withRegistrySecretReference(String keyVaultId, String secretUrl) {
        ((ImageSourceRegistry)this.inner()).credentials().withPasswordSecretReference(new KeyVaultSecretReference().withSourceVault(new ResourceId().withId(keyVaultId)).withSecretUrl(secretUrl));
        return this;
    }
}

