/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.batchai.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.batchai.BatchAIUsage;
import com.microsoft.azure.management.batchai.BatchAIUsages;
import com.microsoft.azure.management.batchai.implementation.BatchAIManagementClientImpl;
import com.microsoft.azure.management.batchai.implementation.BatchAIUsageImpl;
import com.microsoft.azure.management.batchai.implementation.UsageInner;
import com.microsoft.azure.management.resources.fluentcore.arm.Region;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.ReadableWrappersImpl;
import rx.Observable;

@LangDefinition
class BatchAIUsagesImpl
extends ReadableWrappersImpl<BatchAIUsage, BatchAIUsageImpl, UsageInner>
implements BatchAIUsages {
    private final BatchAIManagementClientImpl client;

    BatchAIUsagesImpl(BatchAIManagementClientImpl client) {
        this.client = client;
    }

    public PagedList<BatchAIUsage> listByRegion(Region region) {
        return this.listByRegion(region.name());
    }

    public PagedList<BatchAIUsage> listByRegion(String regionName) {
        return this.wrapList(this.client.usages().list(regionName));
    }

    public Observable<BatchAIUsage> listByRegionAsync(Region region) {
        return this.listByRegionAsync(region.name());
    }

    public Observable<BatchAIUsage> listByRegionAsync(String regionName) {
        return this.wrapPageAsync(this.client.usages().listAsync(regionName));
    }

    protected BatchAIUsageImpl wrapModel(UsageInner usageInner) {
        if (usageInner == null) {
            return null;
        }
        return new BatchAIUsageImpl(usageInner);
    }
}

