/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batchai.implementation;

import com.microsoft.azure.management.batchai.UsageUnit;
import com.microsoft.azure.management.batchai.UsageName;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Describes Batch AI Resource Usage.
 */
public class UsageInner {
    /**
     * An enum describing the unit of usage measurement. Possible values
     * include: 'Count'.
     */
    @JsonProperty(value = "unit", access = JsonProperty.Access.WRITE_ONLY)
    private UsageUnit unit;

    /**
     * The current usage of the resource.
     */
    @JsonProperty(value = "currentValue", access = JsonProperty.Access.WRITE_ONLY)
    private Integer currentValue;

    /**
     * The maximum permitted usage of the resource.
     */
    @JsonProperty(value = "limit", access = JsonProperty.Access.WRITE_ONLY)
    private Long limit;

    /**
     * The name of the type of usage.
     */
    @JsonProperty(value = "name", access = JsonProperty.Access.WRITE_ONLY)
    private UsageName name;

    /**
     * Get an enum describing the unit of usage measurement. Possible values include: 'Count'.
     *
     * @return the unit value
     */
    public UsageUnit unit() {
        return this.unit;
    }

    /**
     * Get the current usage of the resource.
     *
     * @return the currentValue value
     */
    public Integer currentValue() {
        return this.currentValue;
    }

    /**
     * Get the maximum permitted usage of the resource.
     *
     * @return the limit value
     */
    public Long limit() {
        return this.limit;
    }

    /**
     * Get the name of the type of usage.
     *
     * @return the name value
     */
    public UsageName name() {
        return this.name;
    }

}
