/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batchai;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;

/**
 * File Server creation parameters.
 */
@JsonFlatten
public class FileServerCreateParameters {
    /**
     * VM size.
     * The size of the virtual machine for the File Server. For information
     * about available VM sizes from the Virtual Machines Marketplace, see
     * Sizes for Virtual Machines (Linux).
     */
    @JsonProperty(value = "properties.vmSize", required = true)
    private String vmSize;

    /**
     * SSH configuration.
     * SSH configuration for the File Server node.
     */
    @JsonProperty(value = "properties.sshConfiguration", required = true)
    private SshConfiguration sshConfiguration;

    /**
     * Data disks.
     * Settings for the data disks which will be created for the File Server.
     */
    @JsonProperty(value = "properties.dataDisks", required = true)
    private DataDisks dataDisks;

    /**
     * Subnet identifier.
     * Identifier of an existing virtual network subnet to put the File Server
     * in. If not provided, a new virtual network and subnet will be created.
     */
    @JsonProperty(value = "properties.subnet")
    private ResourceId subnet;

    /**
     * Get the size of the virtual machine for the File Server. For information about available VM sizes from the Virtual Machines Marketplace, see Sizes for Virtual Machines (Linux).
     *
     * @return the vmSize value
     */
    public String vmSize() {
        return this.vmSize;
    }

    /**
     * Set the size of the virtual machine for the File Server. For information about available VM sizes from the Virtual Machines Marketplace, see Sizes for Virtual Machines (Linux).
     *
     * @param vmSize the vmSize value to set
     * @return the FileServerCreateParameters object itself.
     */
    public FileServerCreateParameters withVmSize(String vmSize) {
        this.vmSize = vmSize;
        return this;
    }

    /**
     * Get sSH configuration for the File Server node.
     *
     * @return the sshConfiguration value
     */
    public SshConfiguration sshConfiguration() {
        return this.sshConfiguration;
    }

    /**
     * Set sSH configuration for the File Server node.
     *
     * @param sshConfiguration the sshConfiguration value to set
     * @return the FileServerCreateParameters object itself.
     */
    public FileServerCreateParameters withSshConfiguration(SshConfiguration sshConfiguration) {
        this.sshConfiguration = sshConfiguration;
        return this;
    }

    /**
     * Get settings for the data disks which will be created for the File Server.
     *
     * @return the dataDisks value
     */
    public DataDisks dataDisks() {
        return this.dataDisks;
    }

    /**
     * Set settings for the data disks which will be created for the File Server.
     *
     * @param dataDisks the dataDisks value to set
     * @return the FileServerCreateParameters object itself.
     */
    public FileServerCreateParameters withDataDisks(DataDisks dataDisks) {
        this.dataDisks = dataDisks;
        return this;
    }

    /**
     * Get identifier of an existing virtual network subnet to put the File Server in. If not provided, a new virtual network and subnet will be created.
     *
     * @return the subnet value
     */
    public ResourceId subnet() {
        return this.subnet;
    }

    /**
     * Set identifier of an existing virtual network subnet to put the File Server in. If not provided, a new virtual network and subnet will be created.
     *
     * @param subnet the subnet value to set
     * @return the FileServerCreateParameters object itself.
     */
    public FileServerCreateParameters withSubnet(ResourceId subnet) {
        this.subnet = subnet;
        return this;
    }

}
