/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batchai;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Node setup settings.
 */
public class NodeSetup {
    /**
     * Setup task.
     * Setup task to run on cluster nodes when nodes got created or rebooted.
     * The setup task code needs to be idempotent. Generally the setup task is
     * used to download static data that is required for all jobs that run on
     * the cluster VMs and/or to download/install software.
     */
    @JsonProperty(value = "setupTask")
    private SetupTask setupTask;

    /**
     * Mount volumes.
     * Mount volumes to be available to setup task and all jobs executing on
     * the cluster. The volumes will be mounted at location specified by
     * $AZ_BATCHAI_MOUNT_ROOT environment variable.
     */
    @JsonProperty(value = "mountVolumes")
    private MountVolumes mountVolumes;

    /**
     * Performance counters settings.
     * Settings for performance counters collecting and uploading.
     */
    @JsonProperty(value = "performanceCountersSettings")
    private PerformanceCountersSettings performanceCountersSettings;

    /**
     * Get setup task to run on cluster nodes when nodes got created or rebooted. The setup task code needs to be idempotent. Generally the setup task is used to download static data that is required for all jobs that run on the cluster VMs and/or to download/install software.
     *
     * @return the setupTask value
     */
    public SetupTask setupTask() {
        return this.setupTask;
    }

    /**
     * Set setup task to run on cluster nodes when nodes got created or rebooted. The setup task code needs to be idempotent. Generally the setup task is used to download static data that is required for all jobs that run on the cluster VMs and/or to download/install software.
     *
     * @param setupTask the setupTask value to set
     * @return the NodeSetup object itself.
     */
    public NodeSetup withSetupTask(SetupTask setupTask) {
        this.setupTask = setupTask;
        return this;
    }

    /**
     * Get mount volumes to be available to setup task and all jobs executing on the cluster. The volumes will be mounted at location specified by $AZ_BATCHAI_MOUNT_ROOT environment variable.
     *
     * @return the mountVolumes value
     */
    public MountVolumes mountVolumes() {
        return this.mountVolumes;
    }

    /**
     * Set mount volumes to be available to setup task and all jobs executing on the cluster. The volumes will be mounted at location specified by $AZ_BATCHAI_MOUNT_ROOT environment variable.
     *
     * @param mountVolumes the mountVolumes value to set
     * @return the NodeSetup object itself.
     */
    public NodeSetup withMountVolumes(MountVolumes mountVolumes) {
        this.mountVolumes = mountVolumes;
        return this;
    }

    /**
     * Get settings for performance counters collecting and uploading.
     *
     * @return the performanceCountersSettings value
     */
    public PerformanceCountersSettings performanceCountersSettings() {
        return this.performanceCountersSettings;
    }

    /**
     * Set settings for performance counters collecting and uploading.
     *
     * @param performanceCountersSettings the performanceCountersSettings value to set
     * @return the NodeSetup object itself.
     */
    public NodeSetup withPerformanceCountersSettings(PerformanceCountersSettings performanceCountersSettings) {
        this.performanceCountersSettings = performanceCountersSettings;
        return this;
    }

}
