/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batchai;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * TensorFlow job settings.
 */
public class TensorFlowSettings {
    /**
     * Python script file path.
     * The python script to execute.
     */
    @JsonProperty(value = "pythonScriptFilePath", required = true)
    private String pythonScriptFilePath;

    /**
     * Python interpreter path.
     * The path to the Python interpreter.
     */
    @JsonProperty(value = "pythonInterpreterPath")
    private String pythonInterpreterPath;

    /**
     * Master command line arguments.
     * Command line arguments that need to be passed to the python script for
     * the master task.
     */
    @JsonProperty(value = "masterCommandLineArgs")
    private String masterCommandLineArgs;

    /**
     * Worker command line arguments.
     * Command line arguments that need to be passed to the python script for
     * the worker task. Optional for single process jobs.
     */
    @JsonProperty(value = "workerCommandLineArgs")
    private String workerCommandLineArgs;

    /**
     * Parameter server command line arguments.
     * Command line arguments that need to be passed to the python script for
     * the parameter server. Optional for single process jobs.
     */
    @JsonProperty(value = "parameterServerCommandLineArgs")
    private String parameterServerCommandLineArgs;

    /**
     * Worker count.
     * The number of worker tasks. If specified, the value must be less than or
     * equal to (nodeCount * numberOfGPUs per VM). If not specified, the
     * default value is equal to nodeCount. This property can be specified only
     * for distributed TensorFlow training.
     */
    @JsonProperty(value = "workerCount")
    private Integer workerCount;

    /**
     * Parameter server count.
     * The number of parameter server tasks. If specified, the value must be
     * less than or equal to nodeCount. If not specified, the default value is
     * equal to 1 for distributed TensorFlow training. This property can be
     * specified only for distributed TensorFlow training.
     */
    @JsonProperty(value = "parameterServerCount")
    private Integer parameterServerCount;

    /**
     * Get the python script to execute.
     *
     * @return the pythonScriptFilePath value
     */
    public String pythonScriptFilePath() {
        return this.pythonScriptFilePath;
    }

    /**
     * Set the python script to execute.
     *
     * @param pythonScriptFilePath the pythonScriptFilePath value to set
     * @return the TensorFlowSettings object itself.
     */
    public TensorFlowSettings withPythonScriptFilePath(String pythonScriptFilePath) {
        this.pythonScriptFilePath = pythonScriptFilePath;
        return this;
    }

    /**
     * Get the path to the Python interpreter.
     *
     * @return the pythonInterpreterPath value
     */
    public String pythonInterpreterPath() {
        return this.pythonInterpreterPath;
    }

    /**
     * Set the path to the Python interpreter.
     *
     * @param pythonInterpreterPath the pythonInterpreterPath value to set
     * @return the TensorFlowSettings object itself.
     */
    public TensorFlowSettings withPythonInterpreterPath(String pythonInterpreterPath) {
        this.pythonInterpreterPath = pythonInterpreterPath;
        return this;
    }

    /**
     * Get command line arguments that need to be passed to the python script for the master task.
     *
     * @return the masterCommandLineArgs value
     */
    public String masterCommandLineArgs() {
        return this.masterCommandLineArgs;
    }

    /**
     * Set command line arguments that need to be passed to the python script for the master task.
     *
     * @param masterCommandLineArgs the masterCommandLineArgs value to set
     * @return the TensorFlowSettings object itself.
     */
    public TensorFlowSettings withMasterCommandLineArgs(String masterCommandLineArgs) {
        this.masterCommandLineArgs = masterCommandLineArgs;
        return this;
    }

    /**
     * Get command line arguments that need to be passed to the python script for the worker task. Optional for single process jobs.
     *
     * @return the workerCommandLineArgs value
     */
    public String workerCommandLineArgs() {
        return this.workerCommandLineArgs;
    }

    /**
     * Set command line arguments that need to be passed to the python script for the worker task. Optional for single process jobs.
     *
     * @param workerCommandLineArgs the workerCommandLineArgs value to set
     * @return the TensorFlowSettings object itself.
     */
    public TensorFlowSettings withWorkerCommandLineArgs(String workerCommandLineArgs) {
        this.workerCommandLineArgs = workerCommandLineArgs;
        return this;
    }

    /**
     * Get command line arguments that need to be passed to the python script for the parameter server. Optional for single process jobs.
     *
     * @return the parameterServerCommandLineArgs value
     */
    public String parameterServerCommandLineArgs() {
        return this.parameterServerCommandLineArgs;
    }

    /**
     * Set command line arguments that need to be passed to the python script for the parameter server. Optional for single process jobs.
     *
     * @param parameterServerCommandLineArgs the parameterServerCommandLineArgs value to set
     * @return the TensorFlowSettings object itself.
     */
    public TensorFlowSettings withParameterServerCommandLineArgs(String parameterServerCommandLineArgs) {
        this.parameterServerCommandLineArgs = parameterServerCommandLineArgs;
        return this;
    }

    /**
     * Get the number of worker tasks. If specified, the value must be less than or equal to (nodeCount * numberOfGPUs per VM). If not specified, the default value is equal to nodeCount. This property can be specified only for distributed TensorFlow training.
     *
     * @return the workerCount value
     */
    public Integer workerCount() {
        return this.workerCount;
    }

    /**
     * Set the number of worker tasks. If specified, the value must be less than or equal to (nodeCount * numberOfGPUs per VM). If not specified, the default value is equal to nodeCount. This property can be specified only for distributed TensorFlow training.
     *
     * @param workerCount the workerCount value to set
     * @return the TensorFlowSettings object itself.
     */
    public TensorFlowSettings withWorkerCount(Integer workerCount) {
        this.workerCount = workerCount;
        return this;
    }

    /**
     * Get the number of parameter server tasks. If specified, the value must be less than or equal to nodeCount. If not specified, the default value is equal to 1 for distributed TensorFlow training. This property can be specified only for distributed TensorFlow training.
     *
     * @return the parameterServerCount value
     */
    public Integer parameterServerCount() {
        return this.parameterServerCount;
    }

    /**
     * Set the number of parameter server tasks. If specified, the value must be less than or equal to nodeCount. If not specified, the default value is equal to 1 for distributed TensorFlow training. This property can be specified only for distributed TensorFlow training.
     *
     * @param parameterServerCount the parameterServerCount value to set
     * @return the TensorFlowSettings object itself.
     */
    public TensorFlowSettings withParameterServerCount(Integer parameterServerCount) {
        this.parameterServerCount = parameterServerCount;
        return this;
    }

}
