/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batchai;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * File Server mount Information.
 */
public class MountSettings {
    /**
     * Mount Point.
     * Path where the data disks are mounted on the File Server.
     */
    @JsonProperty(value = "mountPoint")
    private String mountPoint;

    /**
     * Public IP.
     * Public IP address of the File Server which can be used to SSH to the
     * node from outside of the subnet.
     */
    @JsonProperty(value = "fileServerPublicIP")
    private String fileServerPublicIP;

    /**
     * Internal IP.
     * Internal IP address of the File Server which can be used to access the
     * File Server from within the subnet.
     */
    @JsonProperty(value = "fileServerInternalIP")
    private String fileServerInternalIP;

    /**
     * Get path where the data disks are mounted on the File Server.
     *
     * @return the mountPoint value
     */
    public String mountPoint() {
        return this.mountPoint;
    }

    /**
     * Set path where the data disks are mounted on the File Server.
     *
     * @param mountPoint the mountPoint value to set
     * @return the MountSettings object itself.
     */
    public MountSettings withMountPoint(String mountPoint) {
        this.mountPoint = mountPoint;
        return this;
    }

    /**
     * Get public IP address of the File Server which can be used to SSH to the node from outside of the subnet.
     *
     * @return the fileServerPublicIP value
     */
    public String fileServerPublicIP() {
        return this.fileServerPublicIP;
    }

    /**
     * Set public IP address of the File Server which can be used to SSH to the node from outside of the subnet.
     *
     * @param fileServerPublicIP the fileServerPublicIP value to set
     * @return the MountSettings object itself.
     */
    public MountSettings withFileServerPublicIP(String fileServerPublicIP) {
        this.fileServerPublicIP = fileServerPublicIP;
        return this;
    }

    /**
     * Get internal IP address of the File Server which can be used to access the File Server from within the subnet.
     *
     * @return the fileServerInternalIP value
     */
    public String fileServerInternalIP() {
        return this.fileServerInternalIP;
    }

    /**
     * Set internal IP address of the File Server which can be used to access the File Server from within the subnet.
     *
     * @param fileServerInternalIP the fileServerInternalIP value to set
     * @return the MountSettings object itself.
     */
    public MountSettings withFileServerInternalIP(String fileServerInternalIP) {
        this.fileServerInternalIP = fileServerInternalIP;
        return this;
    }

}
