/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batchai;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Caffe job settings.
 */
public class CaffeSettings {
    /**
     * Config file path.
     * Path of the config file for the job. This property cannot be specified
     * if pythonScriptFilePath is specified.
     */
    @JsonProperty(value = "configFilePath")
    private String configFilePath;

    /**
     * Python script file path.
     * Python script to execute. This property cannot be specified if
     * configFilePath is specified.
     */
    @JsonProperty(value = "pythonScriptFilePath")
    private String pythonScriptFilePath;

    /**
     * Python interpreter path.
     * The path to the Python interpreter. The property can be specified only
     * if the pythonScriptFilePath is specified.
     */
    @JsonProperty(value = "pythonInterpreterPath")
    private String pythonInterpreterPath;

    /**
     * Command line arguments.
     * Command line arguments that need to be passed to the Caffe job.
     */
    @JsonProperty(value = "commandLineArgs")
    private String commandLineArgs;

    /**
     * Process count.
     * Number of processes to launch for the job execution. The default value
     * for this property is equal to nodeCount property.
     */
    @JsonProperty(value = "processCount")
    private Integer processCount;

    /**
     * Get path of the config file for the job. This property cannot be specified if pythonScriptFilePath is specified.
     *
     * @return the configFilePath value
     */
    public String configFilePath() {
        return this.configFilePath;
    }

    /**
     * Set path of the config file for the job. This property cannot be specified if pythonScriptFilePath is specified.
     *
     * @param configFilePath the configFilePath value to set
     * @return the CaffeSettings object itself.
     */
    public CaffeSettings withConfigFilePath(String configFilePath) {
        this.configFilePath = configFilePath;
        return this;
    }

    /**
     * Get python script to execute. This property cannot be specified if configFilePath is specified.
     *
     * @return the pythonScriptFilePath value
     */
    public String pythonScriptFilePath() {
        return this.pythonScriptFilePath;
    }

    /**
     * Set python script to execute. This property cannot be specified if configFilePath is specified.
     *
     * @param pythonScriptFilePath the pythonScriptFilePath value to set
     * @return the CaffeSettings object itself.
     */
    public CaffeSettings withPythonScriptFilePath(String pythonScriptFilePath) {
        this.pythonScriptFilePath = pythonScriptFilePath;
        return this;
    }

    /**
     * Get the path to the Python interpreter. The property can be specified only if the pythonScriptFilePath is specified.
     *
     * @return the pythonInterpreterPath value
     */
    public String pythonInterpreterPath() {
        return this.pythonInterpreterPath;
    }

    /**
     * Set the path to the Python interpreter. The property can be specified only if the pythonScriptFilePath is specified.
     *
     * @param pythonInterpreterPath the pythonInterpreterPath value to set
     * @return the CaffeSettings object itself.
     */
    public CaffeSettings withPythonInterpreterPath(String pythonInterpreterPath) {
        this.pythonInterpreterPath = pythonInterpreterPath;
        return this;
    }

    /**
     * Get command line arguments that need to be passed to the Caffe job.
     *
     * @return the commandLineArgs value
     */
    public String commandLineArgs() {
        return this.commandLineArgs;
    }

    /**
     * Set command line arguments that need to be passed to the Caffe job.
     *
     * @param commandLineArgs the commandLineArgs value to set
     * @return the CaffeSettings object itself.
     */
    public CaffeSettings withCommandLineArgs(String commandLineArgs) {
        this.commandLineArgs = commandLineArgs;
        return this;
    }

    /**
     * Get number of processes to launch for the job execution. The default value for this property is equal to nodeCount property.
     *
     * @return the processCount value
     */
    public Integer processCount() {
        return this.processCount;
    }

    /**
     * Set number of processes to launch for the job execution. The default value for this property is equal to nodeCount property.
     *
     * @param processCount the processCount value to set
     * @return the CaffeSettings object itself.
     */
    public CaffeSettings withProcessCount(Integer processCount) {
        this.processCount = processCount;
        return this;
    }

}
