/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batchai;

import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * SSH configuration.
 */
public class SshConfiguration {
    /**
     * Allowed public IPs.
     * List of source IP ranges to allow SSH connection from. The default value
     * is '*' (all source IPs are allowed). Maximum number of IP ranges that
     * can be specified is 400.
     */
    @JsonProperty(value = "publicIPsToAllow")
    private List<String> publicIPsToAllow;

    /**
     * User account settings.
     * Settings for administrator user account to be created on a node. The
     * account can be used to establish SSH connection to the node.
     */
    @JsonProperty(value = "userAccountSettings", required = true)
    private UserAccountSettings userAccountSettings;

    /**
     * Get list of source IP ranges to allow SSH connection from. The default value is '*' (all source IPs are allowed). Maximum number of IP ranges that can be specified is 400.
     *
     * @return the publicIPsToAllow value
     */
    public List<String> publicIPsToAllow() {
        return this.publicIPsToAllow;
    }

    /**
     * Set list of source IP ranges to allow SSH connection from. The default value is '*' (all source IPs are allowed). Maximum number of IP ranges that can be specified is 400.
     *
     * @param publicIPsToAllow the publicIPsToAllow value to set
     * @return the SshConfiguration object itself.
     */
    public SshConfiguration withPublicIPsToAllow(List<String> publicIPsToAllow) {
        this.publicIPsToAllow = publicIPsToAllow;
        return this;
    }

    /**
     * Get settings for administrator user account to be created on a node. The account can be used to establish SSH connection to the node.
     *
     * @return the userAccountSettings value
     */
    public UserAccountSettings userAccountSettings() {
        return this.userAccountSettings;
    }

    /**
     * Set settings for administrator user account to be created on a node. The account can be used to establish SSH connection to the node.
     *
     * @param userAccountSettings the userAccountSettings value to set
     * @return the SshConfiguration object itself.
     */
    public SshConfiguration withUserAccountSettings(UserAccountSettings userAccountSettings) {
        this.userAccountSettings = userAccountSettings;
        return this;
    }

}
