/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batchai.implementation;

import com.microsoft.azure.management.batchai.FileType;
import org.joda.time.DateTime;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;

/**
 * Properties of the file or directory.
 */
@JsonFlatten
public class FileInner {
    /**
     * Name.
     * Name of the file.
     */
    @JsonProperty(value = "name", access = JsonProperty.Access.WRITE_ONLY)
    private String name;

    /**
     * File type.
     * Type of the file. Possible values are file and directory. Possible
     * values include: 'file', 'directory'.
     */
    @JsonProperty(value = "fileType", access = JsonProperty.Access.WRITE_ONLY)
    private FileType fileType;

    /**
     * Download URL.
     * URL to download the corresponding file. The downloadUrl is not returned
     * for directories.
     */
    @JsonProperty(value = "downloadUrl", access = JsonProperty.Access.WRITE_ONLY)
    private String downloadUrl;

    /**
     * Last modified time.
     * The time at which the file was last modified.
     */
    @JsonProperty(value = "properties.lastModified", access = JsonProperty.Access.WRITE_ONLY)
    private DateTime lastModified;

    /**
     * Content length.
     * The file of the size.
     */
    @JsonProperty(value = "properties.contentLength", access = JsonProperty.Access.WRITE_ONLY)
    private Long contentLength;

    /**
     * Get name of the file.
     *
     * @return the name value
     */
    public String name() {
        return this.name;
    }

    /**
     * Get type of the file. Possible values are file and directory. Possible values include: 'file', 'directory'.
     *
     * @return the fileType value
     */
    public FileType fileType() {
        return this.fileType;
    }

    /**
     * Get uRL to download the corresponding file. The downloadUrl is not returned for directories.
     *
     * @return the downloadUrl value
     */
    public String downloadUrl() {
        return this.downloadUrl;
    }

    /**
     * Get the time at which the file was last modified.
     *
     * @return the lastModified value
     */
    public DateTime lastModified() {
        return this.lastModified;
    }

    /**
     * Get the file of the size.
     *
     * @return the contentLength value
     */
    public Long contentLength() {
        return this.contentLength;
    }

}
