/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batchai;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Docker container settings.
 */
public class ContainerSettings {
    /**
     * Image source registry.
     * Information about docker image and docker registry to download the
     * container from.
     */
    @JsonProperty(value = "imageSourceRegistry", required = true)
    private ImageSourceRegistry imageSourceRegistry;

    /**
     * /dev/shm size.
     * Size of /dev/shm. Please refer to docker documentation for supported
     * argument formats.
     */
    @JsonProperty(value = "shmSize")
    private String shmSize;

    /**
     * Get information about docker image and docker registry to download the container from.
     *
     * @return the imageSourceRegistry value
     */
    public ImageSourceRegistry imageSourceRegistry() {
        return this.imageSourceRegistry;
    }

    /**
     * Set information about docker image and docker registry to download the container from.
     *
     * @param imageSourceRegistry the imageSourceRegistry value to set
     * @return the ContainerSettings object itself.
     */
    public ContainerSettings withImageSourceRegistry(ImageSourceRegistry imageSourceRegistry) {
        this.imageSourceRegistry = imageSourceRegistry;
        return this;
    }

    /**
     * Get size of /dev/shm. Please refer to docker documentation for supported argument formats.
     *
     * @return the shmSize value
     */
    public String shmSize() {
        return this.shmSize;
    }

    /**
     * Set size of /dev/shm. Please refer to docker documentation for supported argument formats.
     *
     * @param shmSize the shmSize value to set
     * @return the ContainerSettings object itself.
     */
    public ContainerSettings withShmSize(String shmSize) {
        this.shmSize = shmSize;
        return this;
    }

}
