/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batchai;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The OS image reference.
 */
public class ImageReference {
    /**
     * Publisher.
     * Publisher of the image.
     */
    @JsonProperty(value = "publisher", required = true)
    private String publisher;

    /**
     * Offer.
     * Offer of the image.
     */
    @JsonProperty(value = "offer", required = true)
    private String offer;

    /**
     * SKU.
     * SKU of the image.
     */
    @JsonProperty(value = "sku", required = true)
    private String sku;

    /**
     * Version.
     * Version of the image.
     */
    @JsonProperty(value = "version")
    private String version;

    /**
     * Custom VM image resource ID.
     * The ARM resource identifier of the virtual machine image for the compute
     * nodes. This is of the form
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/images/{imageName}.
     * The virtual machine image must be in the same region and subscription as
     * the cluster. For information about the firewall settings for the Batch
     * node agent to communicate with the Batch service see
     * https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration.
     * Note, you need to provide publisher, offer and sku of the base OS image
     * of which the custom image has been derived from.
     */
    @JsonProperty(value = "virtualMachineImageId")
    private String virtualMachineImageId;

    /**
     * Get publisher of the image.
     *
     * @return the publisher value
     */
    public String publisher() {
        return this.publisher;
    }

    /**
     * Set publisher of the image.
     *
     * @param publisher the publisher value to set
     * @return the ImageReference object itself.
     */
    public ImageReference withPublisher(String publisher) {
        this.publisher = publisher;
        return this;
    }

    /**
     * Get offer of the image.
     *
     * @return the offer value
     */
    public String offer() {
        return this.offer;
    }

    /**
     * Set offer of the image.
     *
     * @param offer the offer value to set
     * @return the ImageReference object itself.
     */
    public ImageReference withOffer(String offer) {
        this.offer = offer;
        return this;
    }

    /**
     * Get sKU of the image.
     *
     * @return the sku value
     */
    public String sku() {
        return this.sku;
    }

    /**
     * Set sKU of the image.
     *
     * @param sku the sku value to set
     * @return the ImageReference object itself.
     */
    public ImageReference withSku(String sku) {
        this.sku = sku;
        return this;
    }

    /**
     * Get version of the image.
     *
     * @return the version value
     */
    public String version() {
        return this.version;
    }

    /**
     * Set version of the image.
     *
     * @param version the version value to set
     * @return the ImageReference object itself.
     */
    public ImageReference withVersion(String version) {
        this.version = version;
        return this;
    }

    /**
     * Get the ARM resource identifier of the virtual machine image for the compute nodes. This is of the form /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/images/{imageName}. The virtual machine image must be in the same region and subscription as the cluster. For information about the firewall settings for the Batch node agent to communicate with the Batch service see https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration. Note, you need to provide publisher, offer and sku of the base OS image of which the custom image has been derived from.
     *
     * @return the virtualMachineImageId value
     */
    public String virtualMachineImageId() {
        return this.virtualMachineImageId;
    }

    /**
     * Set the ARM resource identifier of the virtual machine image for the compute nodes. This is of the form /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/images/{imageName}. The virtual machine image must be in the same region and subscription as the cluster. For information about the firewall settings for the Batch node agent to communicate with the Batch service see https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration. Note, you need to provide publisher, offer and sku of the base OS image of which the custom image has been derived from.
     *
     * @param virtualMachineImageId the virtualMachineImageId value to set
     * @return the ImageReference object itself.
     */
    public ImageReference withVirtualMachineImageId(String virtualMachineImageId) {
        this.virtualMachineImageId = virtualMachineImageId;
        return this;
    }

}
