/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batchai;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Key Vault Secret reference.
 */
public class KeyVaultSecretReference {
    /**
     * Key Vault resource identifier.
     * Fully qualified resource indentifier of the Key Vault.
     */
    @JsonProperty(value = "sourceVault", required = true)
    private ResourceId sourceVault;

    /**
     * Secret URL.
     * The URL referencing a secret in the Key Vault.
     */
    @JsonProperty(value = "secretUrl", required = true)
    private String secretUrl;

    /**
     * Get fully qualified resource indentifier of the Key Vault.
     *
     * @return the sourceVault value
     */
    public ResourceId sourceVault() {
        return this.sourceVault;
    }

    /**
     * Set fully qualified resource indentifier of the Key Vault.
     *
     * @param sourceVault the sourceVault value to set
     * @return the KeyVaultSecretReference object itself.
     */
    public KeyVaultSecretReference withSourceVault(ResourceId sourceVault) {
        this.sourceVault = sourceVault;
        return this;
    }

    /**
     * Get the URL referencing a secret in the Key Vault.
     *
     * @return the secretUrl value
     */
    public String secretUrl() {
        return this.secretUrl;
    }

    /**
     * Set the URL referencing a secret in the Key Vault.
     *
     * @param secretUrl the secretUrl value to set
     * @return the KeyVaultSecretReference object itself.
     */
    public KeyVaultSecretReference withSecretUrl(String secretUrl) {
        this.secretUrl = secretUrl;
        return this;
    }

}
