/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batchai.implementation;

import retrofit2.Retrofit;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.management.batchai.JobCreateParameters;
import com.microsoft.azure.management.batchai.JobsListByExperimentOptions;
import com.microsoft.azure.management.batchai.JobsListOutputFilesOptions;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.HTTP;
import retrofit2.http.Path;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Query;
import retrofit2.http.Url;
import retrofit2.Response;
import rx.functions.Func1;
import rx.Observable;

/**
 * An instance of this class provides access to all the operations defined
 * in Jobs.
 */
public class JobsInner {
    /** The Retrofit service to perform REST calls. */
    private JobsService service;
    /** The service client containing this operation class. */
    private BatchAIManagementClientImpl client;

    /**
     * Initializes an instance of JobsInner.
     *
     * @param retrofit the Retrofit instance built from a Retrofit Builder.
     * @param client the instance of the service client containing this operation class.
     */
    public JobsInner(Retrofit retrofit, BatchAIManagementClientImpl client) {
        this.service = retrofit.create(JobsService.class);
        this.client = client;
    }

    /**
     * The interface defining all the services for Jobs to be
     * used by Retrofit to perform actually REST calls.
     */
    interface JobsService {
        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Jobs listByExperiment" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/experiments/{experimentName}/jobs")
        Observable<Response<ResponseBody>> listByExperiment(@Path("resourceGroupName") String resourceGroupName, @Path("workspaceName") String workspaceName, @Path("experimentName") String experimentName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Query("maxresults") Integer maxResults, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Jobs create" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/experiments/{experimentName}/jobs/{jobName}")
        Observable<Response<ResponseBody>> create(@Path("resourceGroupName") String resourceGroupName, @Path("workspaceName") String workspaceName, @Path("experimentName") String experimentName, @Path("jobName") String jobName, @Path("subscriptionId") String subscriptionId, @Body JobCreateParameters parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Jobs beginCreate" })
        @PUT("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/experiments/{experimentName}/jobs/{jobName}")
        Observable<Response<ResponseBody>> beginCreate(@Path("resourceGroupName") String resourceGroupName, @Path("workspaceName") String workspaceName, @Path("experimentName") String experimentName, @Path("jobName") String jobName, @Path("subscriptionId") String subscriptionId, @Body JobCreateParameters parameters, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Jobs delete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/experiments/{experimentName}/jobs/{jobName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> delete(@Path("resourceGroupName") String resourceGroupName, @Path("workspaceName") String workspaceName, @Path("experimentName") String experimentName, @Path("jobName") String jobName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Jobs beginDelete" })
        @HTTP(path = "subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/experiments/{experimentName}/jobs/{jobName}", method = "DELETE", hasBody = true)
        Observable<Response<ResponseBody>> beginDelete(@Path("resourceGroupName") String resourceGroupName, @Path("workspaceName") String workspaceName, @Path("experimentName") String experimentName, @Path("jobName") String jobName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Jobs get" })
        @GET("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/experiments/{experimentName}/jobs/{jobName}")
        Observable<Response<ResponseBody>> get(@Path("resourceGroupName") String resourceGroupName, @Path("workspaceName") String workspaceName, @Path("experimentName") String experimentName, @Path("jobName") String jobName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Jobs listOutputFiles" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/experiments/{experimentName}/jobs/{jobName}/listOutputFiles")
        Observable<Response<ResponseBody>> listOutputFiles(@Path("resourceGroupName") String resourceGroupName, @Path("workspaceName") String workspaceName, @Path("experimentName") String experimentName, @Path("jobName") String jobName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Query("outputdirectoryid") String outputdirectoryid, @Query("directory") String directory, @Query("linkexpiryinminutes") Integer linkexpiryinminutes, @Query("maxresults") Integer maxResults, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Jobs listRemoteLoginInformation" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/experiments/{experimentName}/jobs/{jobName}/listRemoteLoginInformation")
        Observable<Response<ResponseBody>> listRemoteLoginInformation(@Path("resourceGroupName") String resourceGroupName, @Path("workspaceName") String workspaceName, @Path("experimentName") String experimentName, @Path("jobName") String jobName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Jobs terminate" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/experiments/{experimentName}/jobs/{jobName}/terminate")
        Observable<Response<ResponseBody>> terminate(@Path("resourceGroupName") String resourceGroupName, @Path("workspaceName") String workspaceName, @Path("experimentName") String experimentName, @Path("jobName") String jobName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Jobs beginTerminate" })
        @POST("subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/experiments/{experimentName}/jobs/{jobName}/terminate")
        Observable<Response<ResponseBody>> beginTerminate(@Path("resourceGroupName") String resourceGroupName, @Path("workspaceName") String workspaceName, @Path("experimentName") String experimentName, @Path("jobName") String jobName, @Path("subscriptionId") String subscriptionId, @Query("api-version") String apiVersion, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Jobs listByExperimentNext" })
        @GET
        Observable<Response<ResponseBody>> listByExperimentNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Jobs listOutputFilesNext" })
        @GET
        Observable<Response<ResponseBody>> listOutputFilesNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

        @Headers({ "Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Jobs listRemoteLoginInformationNext" })
        @GET
        Observable<Response<ResponseBody>> listRemoteLoginInformationNext(@Url String nextUrl, @Header("accept-language") String acceptLanguage, @Header("User-Agent") String userAgent);

    }

    /**
     * Gets a list of Jobs within the specified Experiment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param workspaceName The name of the workspace. Workspace names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param experimentName The name of the experiment. Experiment names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;JobInner&gt; object if successful.
     */
    public PagedList<JobInner> listByExperiment(final String resourceGroupName, final String workspaceName, final String experimentName) {
        ServiceResponse<Page<JobInner>> response = listByExperimentSinglePageAsync(resourceGroupName, workspaceName, experimentName).toBlocking().single();
        return new PagedList<JobInner>(response.body()) {
            @Override
            public Page<JobInner> nextPage(String nextPageLink) {
                return listByExperimentNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets a list of Jobs within the specified Experiment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param workspaceName The name of the workspace. Workspace names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param experimentName The name of the experiment. Experiment names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<JobInner>> listByExperimentAsync(final String resourceGroupName, final String workspaceName, final String experimentName, final ListOperationCallback<JobInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByExperimentSinglePageAsync(resourceGroupName, workspaceName, experimentName),
            new Func1<String, Observable<ServiceResponse<Page<JobInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobInner>>> call(String nextPageLink) {
                    return listByExperimentNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets a list of Jobs within the specified Experiment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param workspaceName The name of the workspace. Workspace names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param experimentName The name of the experiment. Experiment names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;JobInner&gt; object
     */
    public Observable<Page<JobInner>> listByExperimentAsync(final String resourceGroupName, final String workspaceName, final String experimentName) {
        return listByExperimentWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName)
            .map(new Func1<ServiceResponse<Page<JobInner>>, Page<JobInner>>() {
                @Override
                public Page<JobInner> call(ServiceResponse<Page<JobInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets a list of Jobs within the specified Experiment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param workspaceName The name of the workspace. Workspace names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param experimentName The name of the experiment. Experiment names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;JobInner&gt; object
     */
    public Observable<ServiceResponse<Page<JobInner>>> listByExperimentWithServiceResponseAsync(final String resourceGroupName, final String workspaceName, final String experimentName) {
        return listByExperimentSinglePageAsync(resourceGroupName, workspaceName, experimentName)
            .concatMap(new Func1<ServiceResponse<Page<JobInner>>, Observable<ServiceResponse<Page<JobInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobInner>>> call(ServiceResponse<Page<JobInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByExperimentNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets a list of Jobs within the specified Experiment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param workspaceName The name of the workspace. Workspace names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param experimentName The name of the experiment. Experiment names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;JobInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<JobInner>>> listByExperimentSinglePageAsync(final String resourceGroupName, final String workspaceName, final String experimentName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (workspaceName == null) {
            throw new IllegalArgumentException("Parameter workspaceName is required and cannot be null.");
        }
        if (experimentName == null) {
            throw new IllegalArgumentException("Parameter experimentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        final JobsListByExperimentOptions jobsListByExperimentOptions = null;
        Integer maxResults = null;
        return service.listByExperiment(resourceGroupName, workspaceName, experimentName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), maxResults, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<JobInner>> result = listByExperimentDelegate(response);
                        return Observable.just(new ServiceResponse<Page<JobInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    /**
     * Gets a list of Jobs within the specified Experiment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param workspaceName The name of the workspace. Workspace names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param experimentName The name of the experiment. Experiment names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param jobsListByExperimentOptions Additional parameters for the operation
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;JobInner&gt; object if successful.
     */
    public PagedList<JobInner> listByExperiment(final String resourceGroupName, final String workspaceName, final String experimentName, final JobsListByExperimentOptions jobsListByExperimentOptions) {
        ServiceResponse<Page<JobInner>> response = listByExperimentSinglePageAsync(resourceGroupName, workspaceName, experimentName, jobsListByExperimentOptions).toBlocking().single();
        return new PagedList<JobInner>(response.body()) {
            @Override
            public Page<JobInner> nextPage(String nextPageLink) {
                return listByExperimentNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets a list of Jobs within the specified Experiment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param workspaceName The name of the workspace. Workspace names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param experimentName The name of the experiment. Experiment names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param jobsListByExperimentOptions Additional parameters for the operation
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<JobInner>> listByExperimentAsync(final String resourceGroupName, final String workspaceName, final String experimentName, final JobsListByExperimentOptions jobsListByExperimentOptions, final ListOperationCallback<JobInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByExperimentSinglePageAsync(resourceGroupName, workspaceName, experimentName, jobsListByExperimentOptions),
            new Func1<String, Observable<ServiceResponse<Page<JobInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobInner>>> call(String nextPageLink) {
                    return listByExperimentNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets a list of Jobs within the specified Experiment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param workspaceName The name of the workspace. Workspace names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param experimentName The name of the experiment. Experiment names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param jobsListByExperimentOptions Additional parameters for the operation
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;JobInner&gt; object
     */
    public Observable<Page<JobInner>> listByExperimentAsync(final String resourceGroupName, final String workspaceName, final String experimentName, final JobsListByExperimentOptions jobsListByExperimentOptions) {
        return listByExperimentWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName, jobsListByExperimentOptions)
            .map(new Func1<ServiceResponse<Page<JobInner>>, Page<JobInner>>() {
                @Override
                public Page<JobInner> call(ServiceResponse<Page<JobInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets a list of Jobs within the specified Experiment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param workspaceName The name of the workspace. Workspace names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param experimentName The name of the experiment. Experiment names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param jobsListByExperimentOptions Additional parameters for the operation
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;JobInner&gt; object
     */
    public Observable<ServiceResponse<Page<JobInner>>> listByExperimentWithServiceResponseAsync(final String resourceGroupName, final String workspaceName, final String experimentName, final JobsListByExperimentOptions jobsListByExperimentOptions) {
        return listByExperimentSinglePageAsync(resourceGroupName, workspaceName, experimentName, jobsListByExperimentOptions)
            .concatMap(new Func1<ServiceResponse<Page<JobInner>>, Observable<ServiceResponse<Page<JobInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobInner>>> call(ServiceResponse<Page<JobInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByExperimentNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets a list of Jobs within the specified Experiment.
     *
    ServiceResponse<PageImpl<JobInner>> * @param resourceGroupName Name of the resource group to which the resource belongs.
    ServiceResponse<PageImpl<JobInner>> * @param workspaceName The name of the workspace. Workspace names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
    ServiceResponse<PageImpl<JobInner>> * @param experimentName The name of the experiment. Experiment names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
    ServiceResponse<PageImpl<JobInner>> * @param jobsListByExperimentOptions Additional parameters for the operation
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;JobInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<JobInner>>> listByExperimentSinglePageAsync(final String resourceGroupName, final String workspaceName, final String experimentName, final JobsListByExperimentOptions jobsListByExperimentOptions) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (workspaceName == null) {
            throw new IllegalArgumentException("Parameter workspaceName is required and cannot be null.");
        }
        if (experimentName == null) {
            throw new IllegalArgumentException("Parameter experimentName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(jobsListByExperimentOptions);
        Integer maxResults = null;
        if (jobsListByExperimentOptions != null) {
            maxResults = jobsListByExperimentOptions.maxResults();
        }
        return service.listByExperiment(resourceGroupName, workspaceName, experimentName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), maxResults, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<JobInner>> result = listByExperimentDelegate(response);
                        return Observable.just(new ServiceResponse<Page<JobInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<JobInner>> listByExperimentDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<JobInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<JobInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Creates a Job in the given Experiment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param workspaceName The name of the workspace. Workspace names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param experimentName The name of the experiment. Experiment names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param parameters The parameters to provide for job creation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the JobInner object if successful.
     */
    public JobInner create(String resourceGroupName, String workspaceName, String experimentName, String jobName, JobCreateParameters parameters) {
        return createWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName, jobName, parameters).toBlocking().last().body();
    }

    /**
     * Creates a Job in the given Experiment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param workspaceName The name of the workspace. Workspace names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param experimentName The name of the experiment. Experiment names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param parameters The parameters to provide for job creation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<JobInner> createAsync(String resourceGroupName, String workspaceName, String experimentName, String jobName, JobCreateParameters parameters, final ServiceCallback<JobInner> serviceCallback) {
        return ServiceFuture.fromResponse(createWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName, jobName, parameters), serviceCallback);
    }

    /**
     * Creates a Job in the given Experiment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param workspaceName The name of the workspace. Workspace names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param experimentName The name of the experiment. Experiment names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param parameters The parameters to provide for job creation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<JobInner> createAsync(String resourceGroupName, String workspaceName, String experimentName, String jobName, JobCreateParameters parameters) {
        return createWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName, jobName, parameters).map(new Func1<ServiceResponse<JobInner>, JobInner>() {
            @Override
            public JobInner call(ServiceResponse<JobInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a Job in the given Experiment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param workspaceName The name of the workspace. Workspace names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param experimentName The name of the experiment. Experiment names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param parameters The parameters to provide for job creation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<JobInner>> createWithServiceResponseAsync(String resourceGroupName, String workspaceName, String experimentName, String jobName, JobCreateParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (workspaceName == null) {
            throw new IllegalArgumentException("Parameter workspaceName is required and cannot be null.");
        }
        if (experimentName == null) {
            throw new IllegalArgumentException("Parameter experimentName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        Observable<Response<ResponseBody>> observable = service.create(resourceGroupName, workspaceName, experimentName, jobName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<JobInner>() { }.getType());
    }

    /**
     * Creates a Job in the given Experiment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param workspaceName The name of the workspace. Workspace names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param experimentName The name of the experiment. Experiment names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param parameters The parameters to provide for job creation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the JobInner object if successful.
     */
    public JobInner beginCreate(String resourceGroupName, String workspaceName, String experimentName, String jobName, JobCreateParameters parameters) {
        return beginCreateWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName, jobName, parameters).toBlocking().single().body();
    }

    /**
     * Creates a Job in the given Experiment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param workspaceName The name of the workspace. Workspace names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param experimentName The name of the experiment. Experiment names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param parameters The parameters to provide for job creation.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<JobInner> beginCreateAsync(String resourceGroupName, String workspaceName, String experimentName, String jobName, JobCreateParameters parameters, final ServiceCallback<JobInner> serviceCallback) {
        return ServiceFuture.fromResponse(beginCreateWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName, jobName, parameters), serviceCallback);
    }

    /**
     * Creates a Job in the given Experiment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param workspaceName The name of the workspace. Workspace names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param experimentName The name of the experiment. Experiment names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param parameters The parameters to provide for job creation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the JobInner object
     */
    public Observable<JobInner> beginCreateAsync(String resourceGroupName, String workspaceName, String experimentName, String jobName, JobCreateParameters parameters) {
        return beginCreateWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName, jobName, parameters).map(new Func1<ServiceResponse<JobInner>, JobInner>() {
            @Override
            public JobInner call(ServiceResponse<JobInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Creates a Job in the given Experiment.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param workspaceName The name of the workspace. Workspace names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param experimentName The name of the experiment. Experiment names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param parameters The parameters to provide for job creation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the JobInner object
     */
    public Observable<ServiceResponse<JobInner>> beginCreateWithServiceResponseAsync(String resourceGroupName, String workspaceName, String experimentName, String jobName, JobCreateParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (workspaceName == null) {
            throw new IllegalArgumentException("Parameter workspaceName is required and cannot be null.");
        }
        if (experimentName == null) {
            throw new IllegalArgumentException("Parameter experimentName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate(parameters);
        return service.beginCreate(resourceGroupName, workspaceName, experimentName, jobName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<JobInner>>>() {
                @Override
                public Observable<ServiceResponse<JobInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<JobInner> clientResponse = beginCreateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<JobInner> beginCreateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<JobInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<JobInner>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Deletes a Job.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param workspaceName The name of the workspace. Workspace names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param experimentName The name of the experiment. Experiment names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void delete(String resourceGroupName, String workspaceName, String experimentName, String jobName) {
        deleteWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName, jobName).toBlocking().last().body();
    }

    /**
     * Deletes a Job.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param workspaceName The name of the workspace. Workspace names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param experimentName The name of the experiment. Experiment names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String workspaceName, String experimentName, String jobName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(deleteWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName, jobName), serviceCallback);
    }

    /**
     * Deletes a Job.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param workspaceName The name of the workspace. Workspace names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param experimentName The name of the experiment. Experiment names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> deleteAsync(String resourceGroupName, String workspaceName, String experimentName, String jobName) {
        return deleteWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName, jobName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a Job.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param workspaceName The name of the workspace. Workspace names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param experimentName The name of the experiment. Experiment names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String workspaceName, String experimentName, String jobName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (workspaceName == null) {
            throw new IllegalArgumentException("Parameter workspaceName is required and cannot be null.");
        }
        if (experimentName == null) {
            throw new IllegalArgumentException("Parameter experimentName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = service.delete(resourceGroupName, workspaceName, experimentName, jobName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Deletes a Job.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param workspaceName The name of the workspace. Workspace names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param experimentName The name of the experiment. Experiment names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginDelete(String resourceGroupName, String workspaceName, String experimentName, String jobName) {
        beginDeleteWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName, jobName).toBlocking().single().body();
    }

    /**
     * Deletes a Job.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param workspaceName The name of the workspace. Workspace names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param experimentName The name of the experiment. Experiment names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String workspaceName, String experimentName, String jobName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginDeleteWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName, jobName), serviceCallback);
    }

    /**
     * Deletes a Job.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param workspaceName The name of the workspace. Workspace names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param experimentName The name of the experiment. Experiment names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginDeleteAsync(String resourceGroupName, String workspaceName, String experimentName, String jobName) {
        return beginDeleteWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName, jobName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Deletes a Job.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param workspaceName The name of the workspace. Workspace names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param experimentName The name of the experiment. Experiment names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String workspaceName, String experimentName, String jobName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (workspaceName == null) {
            throw new IllegalArgumentException("Parameter workspaceName is required and cannot be null.");
        }
        if (experimentName == null) {
            throw new IllegalArgumentException("Parameter experimentName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.beginDelete(resourceGroupName, workspaceName, experimentName, jobName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginDeleteDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .register(204, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets information about a Job.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param workspaceName The name of the workspace. Workspace names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param experimentName The name of the experiment. Experiment names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the JobInner object if successful.
     */
    public JobInner get(String resourceGroupName, String workspaceName, String experimentName, String jobName) {
        return getWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName, jobName).toBlocking().single().body();
    }

    /**
     * Gets information about a Job.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param workspaceName The name of the workspace. Workspace names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param experimentName The name of the experiment. Experiment names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<JobInner> getAsync(String resourceGroupName, String workspaceName, String experimentName, String jobName, final ServiceCallback<JobInner> serviceCallback) {
        return ServiceFuture.fromResponse(getWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName, jobName), serviceCallback);
    }

    /**
     * Gets information about a Job.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param workspaceName The name of the workspace. Workspace names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param experimentName The name of the experiment. Experiment names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the JobInner object
     */
    public Observable<JobInner> getAsync(String resourceGroupName, String workspaceName, String experimentName, String jobName) {
        return getWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName, jobName).map(new Func1<ServiceResponse<JobInner>, JobInner>() {
            @Override
            public JobInner call(ServiceResponse<JobInner> response) {
                return response.body();
            }
        });
    }

    /**
     * Gets information about a Job.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param workspaceName The name of the workspace. Workspace names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param experimentName The name of the experiment. Experiment names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the JobInner object
     */
    public Observable<ServiceResponse<JobInner>> getWithServiceResponseAsync(String resourceGroupName, String workspaceName, String experimentName, String jobName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (workspaceName == null) {
            throw new IllegalArgumentException("Parameter workspaceName is required and cannot be null.");
        }
        if (experimentName == null) {
            throw new IllegalArgumentException("Parameter experimentName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.get(resourceGroupName, workspaceName, experimentName, jobName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<JobInner>>>() {
                @Override
                public Observable<ServiceResponse<JobInner>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<JobInner> clientResponse = getDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<JobInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<JobInner, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<JobInner>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * List all directories and files inside the given directory of the Job's output directory (if the output directory is on Azure File Share or Azure Storage Container).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param workspaceName The name of the workspace. Workspace names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param experimentName The name of the experiment. Experiment names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param jobsListOutputFilesOptions Additional parameters for the operation
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;FileInner&gt; object if successful.
     */
    public PagedList<FileInner> listOutputFiles(final String resourceGroupName, final String workspaceName, final String experimentName, final String jobName, final JobsListOutputFilesOptions jobsListOutputFilesOptions) {
        ServiceResponse<Page<FileInner>> response = listOutputFilesSinglePageAsync(resourceGroupName, workspaceName, experimentName, jobName, jobsListOutputFilesOptions).toBlocking().single();
        return new PagedList<FileInner>(response.body()) {
            @Override
            public Page<FileInner> nextPage(String nextPageLink) {
                return listOutputFilesNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * List all directories and files inside the given directory of the Job's output directory (if the output directory is on Azure File Share or Azure Storage Container).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param workspaceName The name of the workspace. Workspace names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param experimentName The name of the experiment. Experiment names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param jobsListOutputFilesOptions Additional parameters for the operation
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<FileInner>> listOutputFilesAsync(final String resourceGroupName, final String workspaceName, final String experimentName, final String jobName, final JobsListOutputFilesOptions jobsListOutputFilesOptions, final ListOperationCallback<FileInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listOutputFilesSinglePageAsync(resourceGroupName, workspaceName, experimentName, jobName, jobsListOutputFilesOptions),
            new Func1<String, Observable<ServiceResponse<Page<FileInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<FileInner>>> call(String nextPageLink) {
                    return listOutputFilesNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * List all directories and files inside the given directory of the Job's output directory (if the output directory is on Azure File Share or Azure Storage Container).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param workspaceName The name of the workspace. Workspace names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param experimentName The name of the experiment. Experiment names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param jobsListOutputFilesOptions Additional parameters for the operation
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;FileInner&gt; object
     */
    public Observable<Page<FileInner>> listOutputFilesAsync(final String resourceGroupName, final String workspaceName, final String experimentName, final String jobName, final JobsListOutputFilesOptions jobsListOutputFilesOptions) {
        return listOutputFilesWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName, jobName, jobsListOutputFilesOptions)
            .map(new Func1<ServiceResponse<Page<FileInner>>, Page<FileInner>>() {
                @Override
                public Page<FileInner> call(ServiceResponse<Page<FileInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * List all directories and files inside the given directory of the Job's output directory (if the output directory is on Azure File Share or Azure Storage Container).
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param workspaceName The name of the workspace. Workspace names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param experimentName The name of the experiment. Experiment names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param jobsListOutputFilesOptions Additional parameters for the operation
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;FileInner&gt; object
     */
    public Observable<ServiceResponse<Page<FileInner>>> listOutputFilesWithServiceResponseAsync(final String resourceGroupName, final String workspaceName, final String experimentName, final String jobName, final JobsListOutputFilesOptions jobsListOutputFilesOptions) {
        return listOutputFilesSinglePageAsync(resourceGroupName, workspaceName, experimentName, jobName, jobsListOutputFilesOptions)
            .concatMap(new Func1<ServiceResponse<Page<FileInner>>, Observable<ServiceResponse<Page<FileInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<FileInner>>> call(ServiceResponse<Page<FileInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listOutputFilesNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * List all directories and files inside the given directory of the Job's output directory (if the output directory is on Azure File Share or Azure Storage Container).
     *
    ServiceResponse<PageImpl<FileInner>> * @param resourceGroupName Name of the resource group to which the resource belongs.
    ServiceResponse<PageImpl<FileInner>> * @param workspaceName The name of the workspace. Workspace names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
    ServiceResponse<PageImpl<FileInner>> * @param experimentName The name of the experiment. Experiment names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
    ServiceResponse<PageImpl<FileInner>> * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
    ServiceResponse<PageImpl<FileInner>> * @param jobsListOutputFilesOptions Additional parameters for the operation
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;FileInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<FileInner>>> listOutputFilesSinglePageAsync(final String resourceGroupName, final String workspaceName, final String experimentName, final String jobName, final JobsListOutputFilesOptions jobsListOutputFilesOptions) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (workspaceName == null) {
            throw new IllegalArgumentException("Parameter workspaceName is required and cannot be null.");
        }
        if (experimentName == null) {
            throw new IllegalArgumentException("Parameter experimentName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (jobsListOutputFilesOptions == null) {
            throw new IllegalArgumentException("Parameter jobsListOutputFilesOptions is required and cannot be null.");
        }
        Validator.validate(jobsListOutputFilesOptions);
        String outputdirectoryid = jobsListOutputFilesOptions.outputdirectoryid();
        String directory = jobsListOutputFilesOptions.directory();
        Integer linkexpiryinminutes = jobsListOutputFilesOptions.linkexpiryinminutes();
        Integer maxResults = jobsListOutputFilesOptions.maxResults();
        return service.listOutputFiles(resourceGroupName, workspaceName, experimentName, jobName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), outputdirectoryid, directory, linkexpiryinminutes, maxResults, this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<FileInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<FileInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<FileInner>> result = listOutputFilesDelegate(response);
                        return Observable.just(new ServiceResponse<Page<FileInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<FileInner>> listOutputFilesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<FileInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<FileInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets a list of currently existing nodes which were used for the Job execution. The returned information contains the node ID, its public IP and SSH port.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param workspaceName The name of the workspace. Workspace names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param experimentName The name of the experiment. Experiment names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;RemoteLoginInformationInner&gt; object if successful.
     */
    public PagedList<RemoteLoginInformationInner> listRemoteLoginInformation(final String resourceGroupName, final String workspaceName, final String experimentName, final String jobName) {
        ServiceResponse<Page<RemoteLoginInformationInner>> response = listRemoteLoginInformationSinglePageAsync(resourceGroupName, workspaceName, experimentName, jobName).toBlocking().single();
        return new PagedList<RemoteLoginInformationInner>(response.body()) {
            @Override
            public Page<RemoteLoginInformationInner> nextPage(String nextPageLink) {
                return listRemoteLoginInformationNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets a list of currently existing nodes which were used for the Job execution. The returned information contains the node ID, its public IP and SSH port.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param workspaceName The name of the workspace. Workspace names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param experimentName The name of the experiment. Experiment names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<RemoteLoginInformationInner>> listRemoteLoginInformationAsync(final String resourceGroupName, final String workspaceName, final String experimentName, final String jobName, final ListOperationCallback<RemoteLoginInformationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listRemoteLoginInformationSinglePageAsync(resourceGroupName, workspaceName, experimentName, jobName),
            new Func1<String, Observable<ServiceResponse<Page<RemoteLoginInformationInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RemoteLoginInformationInner>>> call(String nextPageLink) {
                    return listRemoteLoginInformationNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets a list of currently existing nodes which were used for the Job execution. The returned information contains the node ID, its public IP and SSH port.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param workspaceName The name of the workspace. Workspace names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param experimentName The name of the experiment. Experiment names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RemoteLoginInformationInner&gt; object
     */
    public Observable<Page<RemoteLoginInformationInner>> listRemoteLoginInformationAsync(final String resourceGroupName, final String workspaceName, final String experimentName, final String jobName) {
        return listRemoteLoginInformationWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName, jobName)
            .map(new Func1<ServiceResponse<Page<RemoteLoginInformationInner>>, Page<RemoteLoginInformationInner>>() {
                @Override
                public Page<RemoteLoginInformationInner> call(ServiceResponse<Page<RemoteLoginInformationInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets a list of currently existing nodes which were used for the Job execution. The returned information contains the node ID, its public IP and SSH port.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param workspaceName The name of the workspace. Workspace names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param experimentName The name of the experiment. Experiment names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RemoteLoginInformationInner&gt; object
     */
    public Observable<ServiceResponse<Page<RemoteLoginInformationInner>>> listRemoteLoginInformationWithServiceResponseAsync(final String resourceGroupName, final String workspaceName, final String experimentName, final String jobName) {
        return listRemoteLoginInformationSinglePageAsync(resourceGroupName, workspaceName, experimentName, jobName)
            .concatMap(new Func1<ServiceResponse<Page<RemoteLoginInformationInner>>, Observable<ServiceResponse<Page<RemoteLoginInformationInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RemoteLoginInformationInner>>> call(ServiceResponse<Page<RemoteLoginInformationInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listRemoteLoginInformationNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets a list of currently existing nodes which were used for the Job execution. The returned information contains the node ID, its public IP and SSH port.
     *
    ServiceResponse<PageImpl<RemoteLoginInformationInner>> * @param resourceGroupName Name of the resource group to which the resource belongs.
    ServiceResponse<PageImpl<RemoteLoginInformationInner>> * @param workspaceName The name of the workspace. Workspace names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
    ServiceResponse<PageImpl<RemoteLoginInformationInner>> * @param experimentName The name of the experiment. Experiment names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
    ServiceResponse<PageImpl<RemoteLoginInformationInner>> * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;RemoteLoginInformationInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<RemoteLoginInformationInner>>> listRemoteLoginInformationSinglePageAsync(final String resourceGroupName, final String workspaceName, final String experimentName, final String jobName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (workspaceName == null) {
            throw new IllegalArgumentException("Parameter workspaceName is required and cannot be null.");
        }
        if (experimentName == null) {
            throw new IllegalArgumentException("Parameter experimentName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.listRemoteLoginInformation(resourceGroupName, workspaceName, experimentName, jobName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RemoteLoginInformationInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RemoteLoginInformationInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<RemoteLoginInformationInner>> result = listRemoteLoginInformationDelegate(response);
                        return Observable.just(new ServiceResponse<Page<RemoteLoginInformationInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<RemoteLoginInformationInner>> listRemoteLoginInformationDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<RemoteLoginInformationInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<RemoteLoginInformationInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Terminates a job.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param workspaceName The name of the workspace. Workspace names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param experimentName The name of the experiment. Experiment names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void terminate(String resourceGroupName, String workspaceName, String experimentName, String jobName) {
        terminateWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName, jobName).toBlocking().last().body();
    }

    /**
     * Terminates a job.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param workspaceName The name of the workspace. Workspace names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param experimentName The name of the experiment. Experiment names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> terminateAsync(String resourceGroupName, String workspaceName, String experimentName, String jobName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(terminateWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName, jobName), serviceCallback);
    }

    /**
     * Terminates a job.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param workspaceName The name of the workspace. Workspace names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param experimentName The name of the experiment. Experiment names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<Void> terminateAsync(String resourceGroupName, String workspaceName, String experimentName, String jobName) {
        return terminateWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName, jobName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Terminates a job.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param workspaceName The name of the workspace. Workspace names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param experimentName The name of the experiment. Experiment names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable for the request
     */
    public Observable<ServiceResponse<Void>> terminateWithServiceResponseAsync(String resourceGroupName, String workspaceName, String experimentName, String jobName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (workspaceName == null) {
            throw new IllegalArgumentException("Parameter workspaceName is required and cannot be null.");
        }
        if (experimentName == null) {
            throw new IllegalArgumentException("Parameter experimentName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = service.terminate(resourceGroupName, workspaceName, experimentName, jobName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>() { }.getType());
    }

    /**
     * Terminates a job.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param workspaceName The name of the workspace. Workspace names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param experimentName The name of the experiment. Experiment names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     */
    public void beginTerminate(String resourceGroupName, String workspaceName, String experimentName, String jobName) {
        beginTerminateWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName, jobName).toBlocking().single().body();
    }

    /**
     * Terminates a job.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param workspaceName The name of the workspace. Workspace names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param experimentName The name of the experiment. Experiment names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<Void> beginTerminateAsync(String resourceGroupName, String workspaceName, String experimentName, String jobName, final ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(beginTerminateWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName, jobName), serviceCallback);
    }

    /**
     * Terminates a job.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param workspaceName The name of the workspace. Workspace names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param experimentName The name of the experiment. Experiment names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<Void> beginTerminateAsync(String resourceGroupName, String workspaceName, String experimentName, String jobName) {
        return beginTerminateWithServiceResponseAsync(resourceGroupName, workspaceName, experimentName, jobName).map(new Func1<ServiceResponse<Void>, Void>() {
            @Override
            public Void call(ServiceResponse<Void> response) {
                return response.body();
            }
        });
    }

    /**
     * Terminates a job.
     *
     * @param resourceGroupName Name of the resource group to which the resource belongs.
     * @param workspaceName The name of the workspace. Workspace names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param experimentName The name of the experiment. Experiment names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @param jobName The name of the job within the specified resource group. Job names can only contain a combination of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceResponse} object if successful.
     */
    public Observable<ServiceResponse<Void>> beginTerminateWithServiceResponseAsync(String resourceGroupName, String workspaceName, String experimentName, String jobName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (workspaceName == null) {
            throw new IllegalArgumentException("Parameter workspaceName is required and cannot be null.");
        }
        if (experimentName == null) {
            throw new IllegalArgumentException("Parameter experimentName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return service.beginTerminate(resourceGroupName, workspaceName, experimentName, jobName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>() {
                @Override
                public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<Void> clientResponse = beginTerminateDelegate(response);
                        return Observable.just(clientResponse);
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<Void> beginTerminateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<Void, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<Void>() { }.getType())
                .register(202, new TypeToken<Void>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets a list of Jobs within the specified Experiment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;JobInner&gt; object if successful.
     */
    public PagedList<JobInner> listByExperimentNext(final String nextPageLink) {
        ServiceResponse<Page<JobInner>> response = listByExperimentNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<JobInner>(response.body()) {
            @Override
            public Page<JobInner> nextPage(String nextPageLink) {
                return listByExperimentNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets a list of Jobs within the specified Experiment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<JobInner>> listByExperimentNextAsync(final String nextPageLink, final ServiceFuture<List<JobInner>> serviceFuture, final ListOperationCallback<JobInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listByExperimentNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<JobInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobInner>>> call(String nextPageLink) {
                    return listByExperimentNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets a list of Jobs within the specified Experiment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;JobInner&gt; object
     */
    public Observable<Page<JobInner>> listByExperimentNextAsync(final String nextPageLink) {
        return listByExperimentNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<JobInner>>, Page<JobInner>>() {
                @Override
                public Page<JobInner> call(ServiceResponse<Page<JobInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets a list of Jobs within the specified Experiment.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;JobInner&gt; object
     */
    public Observable<ServiceResponse<Page<JobInner>>> listByExperimentNextWithServiceResponseAsync(final String nextPageLink) {
        return listByExperimentNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<JobInner>>, Observable<ServiceResponse<Page<JobInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobInner>>> call(ServiceResponse<Page<JobInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listByExperimentNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets a list of Jobs within the specified Experiment.
     *
    ServiceResponse<PageImpl<JobInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;JobInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<JobInner>>> listByExperimentNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listByExperimentNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<JobInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<JobInner>> result = listByExperimentNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<JobInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<JobInner>> listByExperimentNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<JobInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<JobInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * List all directories and files inside the given directory of the Job's output directory (if the output directory is on Azure File Share or Azure Storage Container).
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;FileInner&gt; object if successful.
     */
    public PagedList<FileInner> listOutputFilesNext(final String nextPageLink) {
        ServiceResponse<Page<FileInner>> response = listOutputFilesNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<FileInner>(response.body()) {
            @Override
            public Page<FileInner> nextPage(String nextPageLink) {
                return listOutputFilesNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * List all directories and files inside the given directory of the Job's output directory (if the output directory is on Azure File Share or Azure Storage Container).
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<FileInner>> listOutputFilesNextAsync(final String nextPageLink, final ServiceFuture<List<FileInner>> serviceFuture, final ListOperationCallback<FileInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listOutputFilesNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<FileInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<FileInner>>> call(String nextPageLink) {
                    return listOutputFilesNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * List all directories and files inside the given directory of the Job's output directory (if the output directory is on Azure File Share or Azure Storage Container).
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;FileInner&gt; object
     */
    public Observable<Page<FileInner>> listOutputFilesNextAsync(final String nextPageLink) {
        return listOutputFilesNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<FileInner>>, Page<FileInner>>() {
                @Override
                public Page<FileInner> call(ServiceResponse<Page<FileInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * List all directories and files inside the given directory of the Job's output directory (if the output directory is on Azure File Share or Azure Storage Container).
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;FileInner&gt; object
     */
    public Observable<ServiceResponse<Page<FileInner>>> listOutputFilesNextWithServiceResponseAsync(final String nextPageLink) {
        return listOutputFilesNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<FileInner>>, Observable<ServiceResponse<Page<FileInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<FileInner>>> call(ServiceResponse<Page<FileInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listOutputFilesNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * List all directories and files inside the given directory of the Job's output directory (if the output directory is on Azure File Share or Azure Storage Container).
     *
    ServiceResponse<PageImpl<FileInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;FileInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<FileInner>>> listOutputFilesNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listOutputFilesNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<FileInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<FileInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<FileInner>> result = listOutputFilesNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<FileInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<FileInner>> listOutputFilesNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<FileInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<FileInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

    /**
     * Gets a list of currently existing nodes which were used for the Job execution. The returned information contains the node ID, its public IP and SSH port.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @throws CloudException thrown if the request is rejected by server
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent
     * @return the PagedList&lt;RemoteLoginInformationInner&gt; object if successful.
     */
    public PagedList<RemoteLoginInformationInner> listRemoteLoginInformationNext(final String nextPageLink) {
        ServiceResponse<Page<RemoteLoginInformationInner>> response = listRemoteLoginInformationNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<RemoteLoginInformationInner>(response.body()) {
            @Override
            public Page<RemoteLoginInformationInner> nextPage(String nextPageLink) {
                return listRemoteLoginInformationNextSinglePageAsync(nextPageLink).toBlocking().single().body();
            }
        };
    }

    /**
     * Gets a list of currently existing nodes which were used for the Job execution. The returned information contains the node ID, its public IP and SSH port.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @param serviceFuture the ServiceFuture object tracking the Retrofit calls
     * @param serviceCallback the async ServiceCallback to handle successful and failed responses.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the {@link ServiceFuture} object
     */
    public ServiceFuture<List<RemoteLoginInformationInner>> listRemoteLoginInformationNextAsync(final String nextPageLink, final ServiceFuture<List<RemoteLoginInformationInner>> serviceFuture, final ListOperationCallback<RemoteLoginInformationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(
            listRemoteLoginInformationNextSinglePageAsync(nextPageLink),
            new Func1<String, Observable<ServiceResponse<Page<RemoteLoginInformationInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RemoteLoginInformationInner>>> call(String nextPageLink) {
                    return listRemoteLoginInformationNextSinglePageAsync(nextPageLink);
                }
            },
            serviceCallback);
    }

    /**
     * Gets a list of currently existing nodes which were used for the Job execution. The returned information contains the node ID, its public IP and SSH port.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RemoteLoginInformationInner&gt; object
     */
    public Observable<Page<RemoteLoginInformationInner>> listRemoteLoginInformationNextAsync(final String nextPageLink) {
        return listRemoteLoginInformationNextWithServiceResponseAsync(nextPageLink)
            .map(new Func1<ServiceResponse<Page<RemoteLoginInformationInner>>, Page<RemoteLoginInformationInner>>() {
                @Override
                public Page<RemoteLoginInformationInner> call(ServiceResponse<Page<RemoteLoginInformationInner>> response) {
                    return response.body();
                }
            });
    }

    /**
     * Gets a list of currently existing nodes which were used for the Job execution. The returned information contains the node ID, its public IP and SSH port.
     *
     * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the observable to the PagedList&lt;RemoteLoginInformationInner&gt; object
     */
    public Observable<ServiceResponse<Page<RemoteLoginInformationInner>>> listRemoteLoginInformationNextWithServiceResponseAsync(final String nextPageLink) {
        return listRemoteLoginInformationNextSinglePageAsync(nextPageLink)
            .concatMap(new Func1<ServiceResponse<Page<RemoteLoginInformationInner>>, Observable<ServiceResponse<Page<RemoteLoginInformationInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RemoteLoginInformationInner>>> call(ServiceResponse<Page<RemoteLoginInformationInner>> page) {
                    String nextPageLink = page.body().nextPageLink();
                    if (nextPageLink == null) {
                        return Observable.just(page);
                    }
                    return Observable.just(page).concatWith(listRemoteLoginInformationNextWithServiceResponseAsync(nextPageLink));
                }
            });
    }

    /**
     * Gets a list of currently existing nodes which were used for the Job execution. The returned information contains the node ID, its public IP and SSH port.
     *
    ServiceResponse<PageImpl<RemoteLoginInformationInner>> * @param nextPageLink The NextLink from the previous successful call to List operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation
     * @return the PagedList&lt;RemoteLoginInformationInner&gt; object wrapped in {@link ServiceResponse} if successful.
     */
    public Observable<ServiceResponse<Page<RemoteLoginInformationInner>>> listRemoteLoginInformationNextSinglePageAsync(final String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return service.listRemoteLoginInformationNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent())
            .flatMap(new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RemoteLoginInformationInner>>>>() {
                @Override
                public Observable<ServiceResponse<Page<RemoteLoginInformationInner>>> call(Response<ResponseBody> response) {
                    try {
                        ServiceResponse<PageImpl<RemoteLoginInformationInner>> result = listRemoteLoginInformationNextDelegate(response);
                        return Observable.just(new ServiceResponse<Page<RemoteLoginInformationInner>>(result.body(), result.response()));
                    } catch (Throwable t) {
                        return Observable.error(t);
                    }
                }
            });
    }

    private ServiceResponse<PageImpl<RemoteLoginInformationInner>> listRemoteLoginInformationNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().<PageImpl<RemoteLoginInformationInner>, CloudException>newInstance(this.client.serializerAdapter())
                .register(200, new TypeToken<PageImpl<RemoteLoginInformationInner>>() { }.getType())
                .registerError(CloudException.class)
                .build(response);
    }

}
