/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batchai.implementation;

import com.microsoft.azure.management.batchai.JobPriority;
import com.microsoft.azure.management.batchai.ResourceId;
import com.microsoft.azure.management.batchai.MountVolumes;
import com.microsoft.azure.management.batchai.ContainerSettings;
import com.microsoft.azure.management.batchai.ToolType;
import com.microsoft.azure.management.batchai.CNTKsettings;
import com.microsoft.azure.management.batchai.PyTorchSettings;
import com.microsoft.azure.management.batchai.TensorFlowSettings;
import com.microsoft.azure.management.batchai.CaffeSettings;
import com.microsoft.azure.management.batchai.Caffe2Settings;
import com.microsoft.azure.management.batchai.ChainerSettings;
import com.microsoft.azure.management.batchai.CustomToolkitSettings;
import com.microsoft.azure.management.batchai.CustomMpiSettings;
import com.microsoft.azure.management.batchai.HorovodSettings;
import com.microsoft.azure.management.batchai.JobPreparation;
import java.util.List;
import com.microsoft.azure.management.batchai.InputDirectory;
import com.microsoft.azure.management.batchai.OutputDirectory;
import com.microsoft.azure.management.batchai.EnvironmentVariable;
import com.microsoft.azure.management.batchai.EnvironmentVariableWithSecretValue;
import com.microsoft.azure.management.batchai.JobPropertiesConstraints;
import org.joda.time.DateTime;
import com.microsoft.azure.management.batchai.ProvisioningState;
import com.microsoft.azure.management.batchai.ExecutionState;
import com.microsoft.azure.management.batchai.JobPropertiesExecutionInfo;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;
import com.microsoft.azure.ProxyResource;

/**
 * Information about a Job.
 */
@JsonFlatten
public class JobInner extends ProxyResource {
    /**
     * Scheduling priority.
     * Scheduling priority associated with the job. Possible values include:
     * 'low', 'normal', 'high'.
     */
    @JsonProperty(value = "properties.schedulingPriority")
    private JobPriority schedulingPriority;

    /**
     * Cluster.
     * Resource ID of the cluster associated with the job.
     */
    @JsonProperty(value = "properties.cluster")
    private ResourceId cluster;

    /**
     * Mount volumes.
     * Collection of mount volumes available to the job during execution. These
     * volumes are mounted before the job execution and unmouted after the job
     * completion. The volumes are mounted at location specified by
     * $AZ_BATCHAI_JOB_MOUNT_ROOT environment variable.
     */
    @JsonProperty(value = "properties.mountVolumes")
    private MountVolumes mountVolumes;

    /**
     * Number of compute nodes to run the job on.
     * The job will be gang scheduled on that many compute nodes.
     */
    @JsonProperty(value = "properties.nodeCount")
    private Integer nodeCount;

    /**
     * If provided the job will run in the specified container.
     * If the container was downloaded as part of cluster setup then the same
     * container image will be used. If not provided, the job will run on the
     * VM.
     */
    @JsonProperty(value = "properties.containerSettings")
    private ContainerSettings containerSettings;

    /**
     * The toolkit type of this job.
     * Possible values are: cntk, tensorflow, caffe, caffe2, chainer, pytorch,
     * custom, mpi, horovod. Possible values include: 'cntk', 'tensorflow',
     * 'caffe', 'caffe2', 'chainer', 'horovod', 'mpi', 'custom'.
     */
    @JsonProperty(value = "properties.toolType")
    private ToolType toolType;

    /**
     * Specifies the settings for CNTK (aka Microsoft Cognitive Toolkit) job.
     */
    @JsonProperty(value = "properties.cntkSettings")
    private CNTKsettings cntkSettings;

    /**
     * Specifies the settings for pyTorch job.
     */
    @JsonProperty(value = "properties.pyTorchSettings")
    private PyTorchSettings pyTorchSettings;

    /**
     * Specifies the settings for Tensor Flow job.
     */
    @JsonProperty(value = "properties.tensorFlowSettings")
    private TensorFlowSettings tensorFlowSettings;

    /**
     * Specifies the settings for Caffe job.
     */
    @JsonProperty(value = "properties.caffeSettings")
    private CaffeSettings caffeSettings;

    /**
     * Specifies the settings for Caffe2 job.
     */
    @JsonProperty(value = "properties.caffe2Settings")
    private Caffe2Settings caffe2Settings;

    /**
     * Specifies the settings for Chainer job.
     */
    @JsonProperty(value = "properties.chainerSettings")
    private ChainerSettings chainerSettings;

    /**
     * Specifies the settings for custom tool kit job.
     */
    @JsonProperty(value = "properties.customToolkitSettings")
    private CustomToolkitSettings customToolkitSettings;

    /**
     * Specifies the settings for custom MPI job.
     */
    @JsonProperty(value = "properties.customMpiSettings")
    private CustomMpiSettings customMpiSettings;

    /**
     * Specifies the settings for Horovod job.
     */
    @JsonProperty(value = "properties.horovodSettings")
    private HorovodSettings horovodSettings;

    /**
     * Specifies the actions to be performed before tool kit is launched.
     * The specified actions will run on all the nodes that are part of the
     * job.
     */
    @JsonProperty(value = "properties.jobPreparation")
    private JobPreparation jobPreparation;

    /**
     * Output directory path segment.
     * A segment of job's output directories path created by Batch AI. Batch AI
     * creates job's output directories under an unique path to avoid conflicts
     * between jobs. This value contains a path segment generated by Batch AI
     * to make the path unique and can be used to find the output directory on
     * the node or mounted filesystem.
     */
    @JsonProperty(value = "properties.jobOutputDirectoryPathSegment", access = JsonProperty.Access.WRITE_ONLY)
    private String jobOutputDirectoryPathSegment;

    /**
     * Standard output directory path prefix.
     * The path where the Batch AI service stores stdout, stderror and
     * execution log of the job.
     */
    @JsonProperty(value = "properties.stdOutErrPathPrefix")
    private String stdOutErrPathPrefix;

    /**
     * Input directories.
     * A list of input directories for the job.
     */
    @JsonProperty(value = "properties.inputDirectories")
    private List<InputDirectory> inputDirectories;

    /**
     * Output directories.
     * A list of output directories for the job.
     */
    @JsonProperty(value = "properties.outputDirectories")
    private List<OutputDirectory> outputDirectories;

    /**
     * Environment variables.
     * A collection of user defined environment variables to be setup for the
     * job.
     */
    @JsonProperty(value = "properties.environmentVariables")
    private List<EnvironmentVariable> environmentVariables;

    /**
     * Secrets.
     * A collection of user defined environment variables with secret values to
     * be setup for the job. Server will never report values of these variables
     * back.
     */
    @JsonProperty(value = "properties.secrets")
    private List<EnvironmentVariableWithSecretValue> secrets;

    /**
     * Constraints associated with the Job.
     */
    @JsonProperty(value = "properties.constraints")
    private JobPropertiesConstraints constraints;

    /**
     * Creation time.
     * The creation time of the job.
     */
    @JsonProperty(value = "properties.creationTime", access = JsonProperty.Access.WRITE_ONLY)
    private DateTime creationTime;

    /**
     * Provisioning state.
     * The provisioned state of the Batch AI job. Possible values include:
     * 'creating', 'succeeded', 'failed', 'deleting'.
     */
    @JsonProperty(value = "properties.provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    /**
     * Provisioning state transition time.
     * The time at which the job entered its current provisioning state.
     */
    @JsonProperty(value = "properties.provisioningStateTransitionTime", access = JsonProperty.Access.WRITE_ONLY)
    private DateTime provisioningStateTransitionTime;

    /**
     * Execution state.
     * The current state of the job. Possible values are: queued - The job is
     * queued and able to run. A job enters this state when it is created, or
     * when it is awaiting a retry after a failed run. running - The job is
     * running on a compute cluster. This includes job-level preparation such
     * as downloading resource files or set up container specified on the job -
     * it does not necessarily mean that the job command line has started
     * executing. terminating - The job is terminated by the user, the
     * terminate operation is in progress. succeeded - The job has completed
     * running succesfully and exited with exit code 0. failed - The job has
     * finished unsuccessfully (failed with a non-zero exit code) and has
     * exhausted its retry limit. A job is also marked as failed if an error
     * occurred launching the job. Possible values include: 'queued',
     * 'running', 'terminating', 'succeeded', 'failed'.
     */
    @JsonProperty(value = "properties.executionState", access = JsonProperty.Access.WRITE_ONLY)
    private ExecutionState executionState;

    /**
     * Execution state transition time.
     * The time at which the job entered its current execution state.
     */
    @JsonProperty(value = "properties.executionStateTransitionTime", access = JsonProperty.Access.WRITE_ONLY)
    private DateTime executionStateTransitionTime;

    /**
     * Information about the execution of a job.
     */
    @JsonProperty(value = "properties.executionInfo")
    private JobPropertiesExecutionInfo executionInfo;

    /**
     * Get scheduling priority associated with the job. Possible values include: 'low', 'normal', 'high'.
     *
     * @return the schedulingPriority value
     */
    public JobPriority schedulingPriority() {
        return this.schedulingPriority;
    }

    /**
     * Set scheduling priority associated with the job. Possible values include: 'low', 'normal', 'high'.
     *
     * @param schedulingPriority the schedulingPriority value to set
     * @return the JobInner object itself.
     */
    public JobInner withSchedulingPriority(JobPriority schedulingPriority) {
        this.schedulingPriority = schedulingPriority;
        return this;
    }

    /**
     * Get resource ID of the cluster associated with the job.
     *
     * @return the cluster value
     */
    public ResourceId cluster() {
        return this.cluster;
    }

    /**
     * Set resource ID of the cluster associated with the job.
     *
     * @param cluster the cluster value to set
     * @return the JobInner object itself.
     */
    public JobInner withCluster(ResourceId cluster) {
        this.cluster = cluster;
        return this;
    }

    /**
     * Get collection of mount volumes available to the job during execution. These volumes are mounted before the job execution and unmouted after the job completion. The volumes are mounted at location specified by $AZ_BATCHAI_JOB_MOUNT_ROOT environment variable.
     *
     * @return the mountVolumes value
     */
    public MountVolumes mountVolumes() {
        return this.mountVolumes;
    }

    /**
     * Set collection of mount volumes available to the job during execution. These volumes are mounted before the job execution and unmouted after the job completion. The volumes are mounted at location specified by $AZ_BATCHAI_JOB_MOUNT_ROOT environment variable.
     *
     * @param mountVolumes the mountVolumes value to set
     * @return the JobInner object itself.
     */
    public JobInner withMountVolumes(MountVolumes mountVolumes) {
        this.mountVolumes = mountVolumes;
        return this;
    }

    /**
     * Get the job will be gang scheduled on that many compute nodes.
     *
     * @return the nodeCount value
     */
    public Integer nodeCount() {
        return this.nodeCount;
    }

    /**
     * Set the job will be gang scheduled on that many compute nodes.
     *
     * @param nodeCount the nodeCount value to set
     * @return the JobInner object itself.
     */
    public JobInner withNodeCount(Integer nodeCount) {
        this.nodeCount = nodeCount;
        return this;
    }

    /**
     * Get if the container was downloaded as part of cluster setup then the same container image will be used. If not provided, the job will run on the VM.
     *
     * @return the containerSettings value
     */
    public ContainerSettings containerSettings() {
        return this.containerSettings;
    }

    /**
     * Set if the container was downloaded as part of cluster setup then the same container image will be used. If not provided, the job will run on the VM.
     *
     * @param containerSettings the containerSettings value to set
     * @return the JobInner object itself.
     */
    public JobInner withContainerSettings(ContainerSettings containerSettings) {
        this.containerSettings = containerSettings;
        return this;
    }

    /**
     * Get possible values are: cntk, tensorflow, caffe, caffe2, chainer, pytorch, custom, mpi, horovod. Possible values include: 'cntk', 'tensorflow', 'caffe', 'caffe2', 'chainer', 'horovod', 'mpi', 'custom'.
     *
     * @return the toolType value
     */
    public ToolType toolType() {
        return this.toolType;
    }

    /**
     * Set possible values are: cntk, tensorflow, caffe, caffe2, chainer, pytorch, custom, mpi, horovod. Possible values include: 'cntk', 'tensorflow', 'caffe', 'caffe2', 'chainer', 'horovod', 'mpi', 'custom'.
     *
     * @param toolType the toolType value to set
     * @return the JobInner object itself.
     */
    public JobInner withToolType(ToolType toolType) {
        this.toolType = toolType;
        return this;
    }

    /**
     * Get the cntkSettings value.
     *
     * @return the cntkSettings value
     */
    public CNTKsettings cntkSettings() {
        return this.cntkSettings;
    }

    /**
     * Set the cntkSettings value.
     *
     * @param cntkSettings the cntkSettings value to set
     * @return the JobInner object itself.
     */
    public JobInner withCntkSettings(CNTKsettings cntkSettings) {
        this.cntkSettings = cntkSettings;
        return this;
    }

    /**
     * Get the pyTorchSettings value.
     *
     * @return the pyTorchSettings value
     */
    public PyTorchSettings pyTorchSettings() {
        return this.pyTorchSettings;
    }

    /**
     * Set the pyTorchSettings value.
     *
     * @param pyTorchSettings the pyTorchSettings value to set
     * @return the JobInner object itself.
     */
    public JobInner withPyTorchSettings(PyTorchSettings pyTorchSettings) {
        this.pyTorchSettings = pyTorchSettings;
        return this;
    }

    /**
     * Get the tensorFlowSettings value.
     *
     * @return the tensorFlowSettings value
     */
    public TensorFlowSettings tensorFlowSettings() {
        return this.tensorFlowSettings;
    }

    /**
     * Set the tensorFlowSettings value.
     *
     * @param tensorFlowSettings the tensorFlowSettings value to set
     * @return the JobInner object itself.
     */
    public JobInner withTensorFlowSettings(TensorFlowSettings tensorFlowSettings) {
        this.tensorFlowSettings = tensorFlowSettings;
        return this;
    }

    /**
     * Get the caffeSettings value.
     *
     * @return the caffeSettings value
     */
    public CaffeSettings caffeSettings() {
        return this.caffeSettings;
    }

    /**
     * Set the caffeSettings value.
     *
     * @param caffeSettings the caffeSettings value to set
     * @return the JobInner object itself.
     */
    public JobInner withCaffeSettings(CaffeSettings caffeSettings) {
        this.caffeSettings = caffeSettings;
        return this;
    }

    /**
     * Get the caffe2Settings value.
     *
     * @return the caffe2Settings value
     */
    public Caffe2Settings caffe2Settings() {
        return this.caffe2Settings;
    }

    /**
     * Set the caffe2Settings value.
     *
     * @param caffe2Settings the caffe2Settings value to set
     * @return the JobInner object itself.
     */
    public JobInner withCaffe2Settings(Caffe2Settings caffe2Settings) {
        this.caffe2Settings = caffe2Settings;
        return this;
    }

    /**
     * Get the chainerSettings value.
     *
     * @return the chainerSettings value
     */
    public ChainerSettings chainerSettings() {
        return this.chainerSettings;
    }

    /**
     * Set the chainerSettings value.
     *
     * @param chainerSettings the chainerSettings value to set
     * @return the JobInner object itself.
     */
    public JobInner withChainerSettings(ChainerSettings chainerSettings) {
        this.chainerSettings = chainerSettings;
        return this;
    }

    /**
     * Get the customToolkitSettings value.
     *
     * @return the customToolkitSettings value
     */
    public CustomToolkitSettings customToolkitSettings() {
        return this.customToolkitSettings;
    }

    /**
     * Set the customToolkitSettings value.
     *
     * @param customToolkitSettings the customToolkitSettings value to set
     * @return the JobInner object itself.
     */
    public JobInner withCustomToolkitSettings(CustomToolkitSettings customToolkitSettings) {
        this.customToolkitSettings = customToolkitSettings;
        return this;
    }

    /**
     * Get the customMpiSettings value.
     *
     * @return the customMpiSettings value
     */
    public CustomMpiSettings customMpiSettings() {
        return this.customMpiSettings;
    }

    /**
     * Set the customMpiSettings value.
     *
     * @param customMpiSettings the customMpiSettings value to set
     * @return the JobInner object itself.
     */
    public JobInner withCustomMpiSettings(CustomMpiSettings customMpiSettings) {
        this.customMpiSettings = customMpiSettings;
        return this;
    }

    /**
     * Get the horovodSettings value.
     *
     * @return the horovodSettings value
     */
    public HorovodSettings horovodSettings() {
        return this.horovodSettings;
    }

    /**
     * Set the horovodSettings value.
     *
     * @param horovodSettings the horovodSettings value to set
     * @return the JobInner object itself.
     */
    public JobInner withHorovodSettings(HorovodSettings horovodSettings) {
        this.horovodSettings = horovodSettings;
        return this;
    }

    /**
     * Get the specified actions will run on all the nodes that are part of the job.
     *
     * @return the jobPreparation value
     */
    public JobPreparation jobPreparation() {
        return this.jobPreparation;
    }

    /**
     * Set the specified actions will run on all the nodes that are part of the job.
     *
     * @param jobPreparation the jobPreparation value to set
     * @return the JobInner object itself.
     */
    public JobInner withJobPreparation(JobPreparation jobPreparation) {
        this.jobPreparation = jobPreparation;
        return this;
    }

    /**
     * Get a segment of job's output directories path created by Batch AI. Batch AI creates job's output directories under an unique path to avoid conflicts between jobs. This value contains a path segment generated by Batch AI to make the path unique and can be used to find the output directory on the node or mounted filesystem.
     *
     * @return the jobOutputDirectoryPathSegment value
     */
    public String jobOutputDirectoryPathSegment() {
        return this.jobOutputDirectoryPathSegment;
    }

    /**
     * Get the path where the Batch AI service stores stdout, stderror and execution log of the job.
     *
     * @return the stdOutErrPathPrefix value
     */
    public String stdOutErrPathPrefix() {
        return this.stdOutErrPathPrefix;
    }

    /**
     * Set the path where the Batch AI service stores stdout, stderror and execution log of the job.
     *
     * @param stdOutErrPathPrefix the stdOutErrPathPrefix value to set
     * @return the JobInner object itself.
     */
    public JobInner withStdOutErrPathPrefix(String stdOutErrPathPrefix) {
        this.stdOutErrPathPrefix = stdOutErrPathPrefix;
        return this;
    }

    /**
     * Get a list of input directories for the job.
     *
     * @return the inputDirectories value
     */
    public List<InputDirectory> inputDirectories() {
        return this.inputDirectories;
    }

    /**
     * Set a list of input directories for the job.
     *
     * @param inputDirectories the inputDirectories value to set
     * @return the JobInner object itself.
     */
    public JobInner withInputDirectories(List<InputDirectory> inputDirectories) {
        this.inputDirectories = inputDirectories;
        return this;
    }

    /**
     * Get a list of output directories for the job.
     *
     * @return the outputDirectories value
     */
    public List<OutputDirectory> outputDirectories() {
        return this.outputDirectories;
    }

    /**
     * Set a list of output directories for the job.
     *
     * @param outputDirectories the outputDirectories value to set
     * @return the JobInner object itself.
     */
    public JobInner withOutputDirectories(List<OutputDirectory> outputDirectories) {
        this.outputDirectories = outputDirectories;
        return this;
    }

    /**
     * Get a collection of user defined environment variables to be setup for the job.
     *
     * @return the environmentVariables value
     */
    public List<EnvironmentVariable> environmentVariables() {
        return this.environmentVariables;
    }

    /**
     * Set a collection of user defined environment variables to be setup for the job.
     *
     * @param environmentVariables the environmentVariables value to set
     * @return the JobInner object itself.
     */
    public JobInner withEnvironmentVariables(List<EnvironmentVariable> environmentVariables) {
        this.environmentVariables = environmentVariables;
        return this;
    }

    /**
     * Get a collection of user defined environment variables with secret values to be setup for the job. Server will never report values of these variables back.
     *
     * @return the secrets value
     */
    public List<EnvironmentVariableWithSecretValue> secrets() {
        return this.secrets;
    }

    /**
     * Set a collection of user defined environment variables with secret values to be setup for the job. Server will never report values of these variables back.
     *
     * @param secrets the secrets value to set
     * @return the JobInner object itself.
     */
    public JobInner withSecrets(List<EnvironmentVariableWithSecretValue> secrets) {
        this.secrets = secrets;
        return this;
    }

    /**
     * Get constraints associated with the Job.
     *
     * @return the constraints value
     */
    public JobPropertiesConstraints constraints() {
        return this.constraints;
    }

    /**
     * Set constraints associated with the Job.
     *
     * @param constraints the constraints value to set
     * @return the JobInner object itself.
     */
    public JobInner withConstraints(JobPropertiesConstraints constraints) {
        this.constraints = constraints;
        return this;
    }

    /**
     * Get the creation time of the job.
     *
     * @return the creationTime value
     */
    public DateTime creationTime() {
        return this.creationTime;
    }

    /**
     * Get the provisioned state of the Batch AI job. Possible values include: 'creating', 'succeeded', 'failed', 'deleting'.
     *
     * @return the provisioningState value
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the time at which the job entered its current provisioning state.
     *
     * @return the provisioningStateTransitionTime value
     */
    public DateTime provisioningStateTransitionTime() {
        return this.provisioningStateTransitionTime;
    }

    /**
     * Get the current state of the job. Possible values are: queued - The job is queued and able to run. A job enters this state when it is created, or when it is awaiting a retry after a failed run. running - The job is running on a compute cluster. This includes job-level preparation such as downloading resource files or set up container specified on the job - it does not necessarily mean that the job command line has started executing. terminating - The job is terminated by the user, the terminate operation is in progress. succeeded - The job has completed running succesfully and exited with exit code 0. failed - The job has finished unsuccessfully (failed with a non-zero exit code) and has exhausted its retry limit. A job is also marked as failed if an error occurred launching the job. Possible values include: 'queued', 'running', 'terminating', 'succeeded', 'failed'.
     *
     * @return the executionState value
     */
    public ExecutionState executionState() {
        return this.executionState;
    }

    /**
     * Get the time at which the job entered its current execution state.
     *
     * @return the executionStateTransitionTime value
     */
    public DateTime executionStateTransitionTime() {
        return this.executionStateTransitionTime;
    }

    /**
     * Get information about the execution of a job.
     *
     * @return the executionInfo value
     */
    public JobPropertiesExecutionInfo executionInfo() {
        return this.executionInfo;
    }

    /**
     * Set information about the execution of a job.
     *
     * @param executionInfo the executionInfo value to set
     * @return the JobInner object itself.
     */
    public JobInner withExecutionInfo(JobPropertiesExecutionInfo executionInfo) {
        this.executionInfo = executionInfo;
        return this;
    }

}
