/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batchai;

import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;

/**
 * Job creation parameters.
 */
@JsonFlatten
public class JobCreateParameters {
    /**
     * Scheduling priority.
     * Scheduling priority associated with the job. Possible values: low,
     * normal, high. Possible values include: 'low', 'normal', 'high'.
     */
    @JsonProperty(value = "properties.schedulingPriority")
    private JobPriority schedulingPriority;

    /**
     * Cluster.
     * Resource ID of the cluster on which this job will run.
     */
    @JsonProperty(value = "properties.cluster", required = true)
    private ResourceId cluster;

    /**
     * Mount volumes.
     * Information on mount volumes to be used by the job. These volumes will
     * be mounted before the job execution and will be unmouted after the job
     * completion. The volumes will be mounted at location specified by
     * $AZ_BATCHAI_JOB_MOUNT_ROOT environment variable.
     */
    @JsonProperty(value = "properties.mountVolumes")
    private MountVolumes mountVolumes;

    /**
     * Node count.
     * Number of compute nodes to run the job on. The job will be gang
     * scheduled on that many compute nodes.
     */
    @JsonProperty(value = "properties.nodeCount", required = true)
    private int nodeCount;

    /**
     * Container settings.
     * Docker container settings for the job. If not provided, the job will run
     * directly on the node.
     */
    @JsonProperty(value = "properties.containerSettings")
    private ContainerSettings containerSettings;

    /**
     * CNTK settings.
     * Settings for CNTK (aka Microsoft Cognitive Toolkit) job.
     */
    @JsonProperty(value = "properties.cntkSettings")
    private CNTKsettings cntkSettings;

    /**
     * pyTorch settings.
     * Settings for pyTorch job.
     */
    @JsonProperty(value = "properties.pyTorchSettings")
    private PyTorchSettings pyTorchSettings;

    /**
     * TensorFlow settings.
     * Settings for Tensor Flow job.
     */
    @JsonProperty(value = "properties.tensorFlowSettings")
    private TensorFlowSettings tensorFlowSettings;

    /**
     * Caffe settings.
     * Settings for Caffe job.
     */
    @JsonProperty(value = "properties.caffeSettings")
    private CaffeSettings caffeSettings;

    /**
     * Caffe2 settings.
     * Settings for Caffe2 job.
     */
    @JsonProperty(value = "properties.caffe2Settings")
    private Caffe2Settings caffe2Settings;

    /**
     * Chainer settings.
     * Settings for Chainer job.
     */
    @JsonProperty(value = "properties.chainerSettings")
    private ChainerSettings chainerSettings;

    /**
     * Custom tool kit job.
     * Settings for custom tool kit job.
     */
    @JsonProperty(value = "properties.customToolkitSettings")
    private CustomToolkitSettings customToolkitSettings;

    /**
     * Custom MPI settings.
     * Settings for custom MPI job.
     */
    @JsonProperty(value = "properties.customMpiSettings")
    private CustomMpiSettings customMpiSettings;

    /**
     * Horovod settings.
     * Settings for Horovod job.
     */
    @JsonProperty(value = "properties.horovodSettings")
    private HorovodSettings horovodSettings;

    /**
     * Job preparation.
     * A command line to be executed on each node allocated for the job before
     * tool kit is launched.
     */
    @JsonProperty(value = "properties.jobPreparation")
    private JobPreparation jobPreparation;

    /**
     * Standard output path prefix.
     * The path where the Batch AI service will store stdout, stderror and
     * execution log of the job.
     */
    @JsonProperty(value = "properties.stdOutErrPathPrefix", required = true)
    private String stdOutErrPathPrefix;

    /**
     * Input directories.
     * A list of input directories for the job.
     */
    @JsonProperty(value = "properties.inputDirectories")
    private List<InputDirectory> inputDirectories;

    /**
     * Output directories.
     * A list of output directories for the job.
     */
    @JsonProperty(value = "properties.outputDirectories")
    private List<OutputDirectory> outputDirectories;

    /**
     * Environment variables.
     * A list of user defined environment variables which will be setup for the
     * job.
     */
    @JsonProperty(value = "properties.environmentVariables")
    private List<EnvironmentVariable> environmentVariables;

    /**
     * Secrets.
     * A list of user defined environment variables with secret values which
     * will be setup for the job. Server will never report values of these
     * variables back.
     */
    @JsonProperty(value = "properties.secrets")
    private List<EnvironmentVariableWithSecretValue> secrets;

    /**
     * Constraints associated with the Job.
     */
    @JsonProperty(value = "properties.constraints")
    private JobBasePropertiesConstraints constraints;

    /**
     * Get scheduling priority associated with the job. Possible values: low, normal, high. Possible values include: 'low', 'normal', 'high'.
     *
     * @return the schedulingPriority value
     */
    public JobPriority schedulingPriority() {
        return this.schedulingPriority;
    }

    /**
     * Set scheduling priority associated with the job. Possible values: low, normal, high. Possible values include: 'low', 'normal', 'high'.
     *
     * @param schedulingPriority the schedulingPriority value to set
     * @return the JobCreateParameters object itself.
     */
    public JobCreateParameters withSchedulingPriority(JobPriority schedulingPriority) {
        this.schedulingPriority = schedulingPriority;
        return this;
    }

    /**
     * Get resource ID of the cluster on which this job will run.
     *
     * @return the cluster value
     */
    public ResourceId cluster() {
        return this.cluster;
    }

    /**
     * Set resource ID of the cluster on which this job will run.
     *
     * @param cluster the cluster value to set
     * @return the JobCreateParameters object itself.
     */
    public JobCreateParameters withCluster(ResourceId cluster) {
        this.cluster = cluster;
        return this;
    }

    /**
     * Get information on mount volumes to be used by the job. These volumes will be mounted before the job execution and will be unmouted after the job completion. The volumes will be mounted at location specified by $AZ_BATCHAI_JOB_MOUNT_ROOT environment variable.
     *
     * @return the mountVolumes value
     */
    public MountVolumes mountVolumes() {
        return this.mountVolumes;
    }

    /**
     * Set information on mount volumes to be used by the job. These volumes will be mounted before the job execution and will be unmouted after the job completion. The volumes will be mounted at location specified by $AZ_BATCHAI_JOB_MOUNT_ROOT environment variable.
     *
     * @param mountVolumes the mountVolumes value to set
     * @return the JobCreateParameters object itself.
     */
    public JobCreateParameters withMountVolumes(MountVolumes mountVolumes) {
        this.mountVolumes = mountVolumes;
        return this;
    }

    /**
     * Get number of compute nodes to run the job on. The job will be gang scheduled on that many compute nodes.
     *
     * @return the nodeCount value
     */
    public int nodeCount() {
        return this.nodeCount;
    }

    /**
     * Set number of compute nodes to run the job on. The job will be gang scheduled on that many compute nodes.
     *
     * @param nodeCount the nodeCount value to set
     * @return the JobCreateParameters object itself.
     */
    public JobCreateParameters withNodeCount(int nodeCount) {
        this.nodeCount = nodeCount;
        return this;
    }

    /**
     * Get docker container settings for the job. If not provided, the job will run directly on the node.
     *
     * @return the containerSettings value
     */
    public ContainerSettings containerSettings() {
        return this.containerSettings;
    }

    /**
     * Set docker container settings for the job. If not provided, the job will run directly on the node.
     *
     * @param containerSettings the containerSettings value to set
     * @return the JobCreateParameters object itself.
     */
    public JobCreateParameters withContainerSettings(ContainerSettings containerSettings) {
        this.containerSettings = containerSettings;
        return this;
    }

    /**
     * Get settings for CNTK (aka Microsoft Cognitive Toolkit) job.
     *
     * @return the cntkSettings value
     */
    public CNTKsettings cntkSettings() {
        return this.cntkSettings;
    }

    /**
     * Set settings for CNTK (aka Microsoft Cognitive Toolkit) job.
     *
     * @param cntkSettings the cntkSettings value to set
     * @return the JobCreateParameters object itself.
     */
    public JobCreateParameters withCntkSettings(CNTKsettings cntkSettings) {
        this.cntkSettings = cntkSettings;
        return this;
    }

    /**
     * Get settings for pyTorch job.
     *
     * @return the pyTorchSettings value
     */
    public PyTorchSettings pyTorchSettings() {
        return this.pyTorchSettings;
    }

    /**
     * Set settings for pyTorch job.
     *
     * @param pyTorchSettings the pyTorchSettings value to set
     * @return the JobCreateParameters object itself.
     */
    public JobCreateParameters withPyTorchSettings(PyTorchSettings pyTorchSettings) {
        this.pyTorchSettings = pyTorchSettings;
        return this;
    }

    /**
     * Get settings for Tensor Flow job.
     *
     * @return the tensorFlowSettings value
     */
    public TensorFlowSettings tensorFlowSettings() {
        return this.tensorFlowSettings;
    }

    /**
     * Set settings for Tensor Flow job.
     *
     * @param tensorFlowSettings the tensorFlowSettings value to set
     * @return the JobCreateParameters object itself.
     */
    public JobCreateParameters withTensorFlowSettings(TensorFlowSettings tensorFlowSettings) {
        this.tensorFlowSettings = tensorFlowSettings;
        return this;
    }

    /**
     * Get settings for Caffe job.
     *
     * @return the caffeSettings value
     */
    public CaffeSettings caffeSettings() {
        return this.caffeSettings;
    }

    /**
     * Set settings for Caffe job.
     *
     * @param caffeSettings the caffeSettings value to set
     * @return the JobCreateParameters object itself.
     */
    public JobCreateParameters withCaffeSettings(CaffeSettings caffeSettings) {
        this.caffeSettings = caffeSettings;
        return this;
    }

    /**
     * Get settings for Caffe2 job.
     *
     * @return the caffe2Settings value
     */
    public Caffe2Settings caffe2Settings() {
        return this.caffe2Settings;
    }

    /**
     * Set settings for Caffe2 job.
     *
     * @param caffe2Settings the caffe2Settings value to set
     * @return the JobCreateParameters object itself.
     */
    public JobCreateParameters withCaffe2Settings(Caffe2Settings caffe2Settings) {
        this.caffe2Settings = caffe2Settings;
        return this;
    }

    /**
     * Get settings for Chainer job.
     *
     * @return the chainerSettings value
     */
    public ChainerSettings chainerSettings() {
        return this.chainerSettings;
    }

    /**
     * Set settings for Chainer job.
     *
     * @param chainerSettings the chainerSettings value to set
     * @return the JobCreateParameters object itself.
     */
    public JobCreateParameters withChainerSettings(ChainerSettings chainerSettings) {
        this.chainerSettings = chainerSettings;
        return this;
    }

    /**
     * Get settings for custom tool kit job.
     *
     * @return the customToolkitSettings value
     */
    public CustomToolkitSettings customToolkitSettings() {
        return this.customToolkitSettings;
    }

    /**
     * Set settings for custom tool kit job.
     *
     * @param customToolkitSettings the customToolkitSettings value to set
     * @return the JobCreateParameters object itself.
     */
    public JobCreateParameters withCustomToolkitSettings(CustomToolkitSettings customToolkitSettings) {
        this.customToolkitSettings = customToolkitSettings;
        return this;
    }

    /**
     * Get settings for custom MPI job.
     *
     * @return the customMpiSettings value
     */
    public CustomMpiSettings customMpiSettings() {
        return this.customMpiSettings;
    }

    /**
     * Set settings for custom MPI job.
     *
     * @param customMpiSettings the customMpiSettings value to set
     * @return the JobCreateParameters object itself.
     */
    public JobCreateParameters withCustomMpiSettings(CustomMpiSettings customMpiSettings) {
        this.customMpiSettings = customMpiSettings;
        return this;
    }

    /**
     * Get settings for Horovod job.
     *
     * @return the horovodSettings value
     */
    public HorovodSettings horovodSettings() {
        return this.horovodSettings;
    }

    /**
     * Set settings for Horovod job.
     *
     * @param horovodSettings the horovodSettings value to set
     * @return the JobCreateParameters object itself.
     */
    public JobCreateParameters withHorovodSettings(HorovodSettings horovodSettings) {
        this.horovodSettings = horovodSettings;
        return this;
    }

    /**
     * Get a command line to be executed on each node allocated for the job before tool kit is launched.
     *
     * @return the jobPreparation value
     */
    public JobPreparation jobPreparation() {
        return this.jobPreparation;
    }

    /**
     * Set a command line to be executed on each node allocated for the job before tool kit is launched.
     *
     * @param jobPreparation the jobPreparation value to set
     * @return the JobCreateParameters object itself.
     */
    public JobCreateParameters withJobPreparation(JobPreparation jobPreparation) {
        this.jobPreparation = jobPreparation;
        return this;
    }

    /**
     * Get the path where the Batch AI service will store stdout, stderror and execution log of the job.
     *
     * @return the stdOutErrPathPrefix value
     */
    public String stdOutErrPathPrefix() {
        return this.stdOutErrPathPrefix;
    }

    /**
     * Set the path where the Batch AI service will store stdout, stderror and execution log of the job.
     *
     * @param stdOutErrPathPrefix the stdOutErrPathPrefix value to set
     * @return the JobCreateParameters object itself.
     */
    public JobCreateParameters withStdOutErrPathPrefix(String stdOutErrPathPrefix) {
        this.stdOutErrPathPrefix = stdOutErrPathPrefix;
        return this;
    }

    /**
     * Get a list of input directories for the job.
     *
     * @return the inputDirectories value
     */
    public List<InputDirectory> inputDirectories() {
        return this.inputDirectories;
    }

    /**
     * Set a list of input directories for the job.
     *
     * @param inputDirectories the inputDirectories value to set
     * @return the JobCreateParameters object itself.
     */
    public JobCreateParameters withInputDirectories(List<InputDirectory> inputDirectories) {
        this.inputDirectories = inputDirectories;
        return this;
    }

    /**
     * Get a list of output directories for the job.
     *
     * @return the outputDirectories value
     */
    public List<OutputDirectory> outputDirectories() {
        return this.outputDirectories;
    }

    /**
     * Set a list of output directories for the job.
     *
     * @param outputDirectories the outputDirectories value to set
     * @return the JobCreateParameters object itself.
     */
    public JobCreateParameters withOutputDirectories(List<OutputDirectory> outputDirectories) {
        this.outputDirectories = outputDirectories;
        return this;
    }

    /**
     * Get a list of user defined environment variables which will be setup for the job.
     *
     * @return the environmentVariables value
     */
    public List<EnvironmentVariable> environmentVariables() {
        return this.environmentVariables;
    }

    /**
     * Set a list of user defined environment variables which will be setup for the job.
     *
     * @param environmentVariables the environmentVariables value to set
     * @return the JobCreateParameters object itself.
     */
    public JobCreateParameters withEnvironmentVariables(List<EnvironmentVariable> environmentVariables) {
        this.environmentVariables = environmentVariables;
        return this;
    }

    /**
     * Get a list of user defined environment variables with secret values which will be setup for the job. Server will never report values of these variables back.
     *
     * @return the secrets value
     */
    public List<EnvironmentVariableWithSecretValue> secrets() {
        return this.secrets;
    }

    /**
     * Set a list of user defined environment variables with secret values which will be setup for the job. Server will never report values of these variables back.
     *
     * @param secrets the secrets value to set
     * @return the JobCreateParameters object itself.
     */
    public JobCreateParameters withSecrets(List<EnvironmentVariableWithSecretValue> secrets) {
        this.secrets = secrets;
        return this;
    }

    /**
     * Get constraints associated with the Job.
     *
     * @return the constraints value
     */
    public JobBasePropertiesConstraints constraints() {
        return this.constraints;
    }

    /**
     * Set constraints associated with the Job.
     *
     * @param constraints the constraints value to set
     * @return the JobCreateParameters object itself.
     */
    public JobCreateParameters withConstraints(JobBasePropertiesConstraints constraints) {
        this.constraints = constraints;
        return this;
    }

}
