/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batchai;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Details of the Azure File Share to mount on the cluster.
 */
public class AzureFileShareReference {
    /**
     * Name of the storage account.
     */
    @JsonProperty(value = "accountName", required = true)
    private String accountName;

    /**
     * URL to access the Azure File.
     */
    @JsonProperty(value = "azureFileUrl", required = true)
    private String azureFileUrl;

    /**
     * Information of the Azure File credentials.
     */
    @JsonProperty(value = "credentials", required = true)
    private AzureStorageCredentialsInfo credentials;

    /**
     * Specifies the relative path on the compute node where the Azure file
     * share will be mounted.
     * Note that all file shares will be mounted under $AZ_BATCHAI_MOUNT_ROOT
     * location.
     */
    @JsonProperty(value = "relativeMountPath", required = true)
    private String relativeMountPath;

    /**
     * Specifies the file mode.
     * Default value is 0777. Valid only if OS is linux.
     */
    @JsonProperty(value = "fileMode")
    private String fileMode;

    /**
     * Specifies the directory Mode.
     * Default value is 0777. Valid only if OS is linux.
     */
    @JsonProperty(value = "directoryMode")
    private String directoryMode;

    /**
     * Get the accountName value.
     *
     * @return the accountName value
     */
    public String accountName() {
        return this.accountName;
    }

    /**
     * Set the accountName value.
     *
     * @param accountName the accountName value to set
     * @return the AzureFileShareReference object itself.
     */
    public AzureFileShareReference withAccountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    /**
     * Get the azureFileUrl value.
     *
     * @return the azureFileUrl value
     */
    public String azureFileUrl() {
        return this.azureFileUrl;
    }

    /**
     * Set the azureFileUrl value.
     *
     * @param azureFileUrl the azureFileUrl value to set
     * @return the AzureFileShareReference object itself.
     */
    public AzureFileShareReference withAzureFileUrl(String azureFileUrl) {
        this.azureFileUrl = azureFileUrl;
        return this;
    }

    /**
     * Get the credentials value.
     *
     * @return the credentials value
     */
    public AzureStorageCredentialsInfo credentials() {
        return this.credentials;
    }

    /**
     * Set the credentials value.
     *
     * @param credentials the credentials value to set
     * @return the AzureFileShareReference object itself.
     */
    public AzureFileShareReference withCredentials(AzureStorageCredentialsInfo credentials) {
        this.credentials = credentials;
        return this;
    }

    /**
     * Get the relativeMountPath value.
     *
     * @return the relativeMountPath value
     */
    public String relativeMountPath() {
        return this.relativeMountPath;
    }

    /**
     * Set the relativeMountPath value.
     *
     * @param relativeMountPath the relativeMountPath value to set
     * @return the AzureFileShareReference object itself.
     */
    public AzureFileShareReference withRelativeMountPath(String relativeMountPath) {
        this.relativeMountPath = relativeMountPath;
        return this;
    }

    /**
     * Get the fileMode value.
     *
     * @return the fileMode value
     */
    public String fileMode() {
        return this.fileMode;
    }

    /**
     * Set the fileMode value.
     *
     * @param fileMode the fileMode value to set
     * @return the AzureFileShareReference object itself.
     */
    public AzureFileShareReference withFileMode(String fileMode) {
        this.fileMode = fileMode;
        return this;
    }

    /**
     * Get the directoryMode value.
     *
     * @return the directoryMode value
     */
    public String directoryMode() {
        return this.directoryMode;
    }

    /**
     * Set the directoryMode value.
     *
     * @param directoryMode the directoryMode value to set
     * @return the AzureFileShareReference object itself.
     */
    public AzureFileShareReference withDirectoryMode(String directoryMode) {
        this.directoryMode = directoryMode;
        return this;
    }

}
