/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batchai;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Details of the container image such as name, URL and credentials.
 */
public class ImageSourceRegistry {
    /**
     * URL for image repository.
     */
    @JsonProperty(value = "serverUrl")
    private String serverUrl;

    /**
     * The name of the image in image repository.
     */
    @JsonProperty(value = "image", required = true)
    private String image;

    /**
     * Information to access the private Docker repository.
     */
    @JsonProperty(value = "credentials")
    private PrivateRegistryCredentials credentials;

    /**
     * Get the serverUrl value.
     *
     * @return the serverUrl value
     */
    public String serverUrl() {
        return this.serverUrl;
    }

    /**
     * Set the serverUrl value.
     *
     * @param serverUrl the serverUrl value to set
     * @return the ImageSourceRegistry object itself.
     */
    public ImageSourceRegistry withServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
        return this;
    }

    /**
     * Get the image value.
     *
     * @return the image value
     */
    public String image() {
        return this.image;
    }

    /**
     * Set the image value.
     *
     * @param image the image value to set
     * @return the ImageSourceRegistry object itself.
     */
    public ImageSourceRegistry withImage(String image) {
        this.image = image;
        return this;
    }

    /**
     * Get the credentials value.
     *
     * @return the credentials value
     */
    public PrivateRegistryCredentials credentials() {
        return this.credentials;
    }

    /**
     * Set the credentials value.
     *
     * @param credentials the credentials value to set
     * @return the ImageSourceRegistry object itself.
     */
    public ImageSourceRegistry withCredentials(PrivateRegistryCredentials credentials) {
        this.credentials = credentials;
        return this;
    }

}
