/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.batchai.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.batchai.implementation.BatchAIManagementClientImpl;
import com.microsoft.azure.management.batchai.implementation.FileServerCreateParametersInner;
import com.microsoft.azure.management.batchai.implementation.FileServerInner;
import com.microsoft.azure.management.batchai.implementation.FileServersListByResourceGroupOptionsInner;
import com.microsoft.azure.management.batchai.implementation.FileServersListOptionsInner;
import com.microsoft.azure.management.batchai.implementation.PageImpl;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class FileServersInner
implements InnerSupportsGet<FileServerInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<FileServerInner> {
    private FileServersService service;
    private BatchAIManagementClientImpl client;

    public FileServersInner(Retrofit retrofit, BatchAIManagementClientImpl client) {
        this.service = (FileServersService)retrofit.create(FileServersService.class);
        this.client = client;
    }

    public FileServerInner create(String resourceGroupName, String fileServerName, FileServerCreateParametersInner parameters) {
        return (FileServerInner)((Object)((ServiceResponse)this.createWithServiceResponseAsync(resourceGroupName, fileServerName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<FileServerInner> createAsync(String resourceGroupName, String fileServerName, FileServerCreateParametersInner parameters, ServiceCallback<FileServerInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createWithServiceResponseAsync(resourceGroupName, fileServerName, parameters), serviceCallback);
    }

    public Observable<FileServerInner> createAsync(String resourceGroupName, String fileServerName, FileServerCreateParametersInner parameters) {
        return this.createWithServiceResponseAsync(resourceGroupName, fileServerName, parameters).map((Func1)new Func1<ServiceResponse<FileServerInner>, FileServerInner>(){

            public FileServerInner call(ServiceResponse<FileServerInner> response) {
                return (FileServerInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<FileServerInner>> createWithServiceResponseAsync(String resourceGroupName, String fileServerName, FileServerCreateParametersInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (fileServerName == null) {
            throw new IllegalArgumentException("Parameter fileServerName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        Observable<Response<ResponseBody>> observable = this.service.create(resourceGroupName, fileServerName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<FileServerInner>(){}.getType());
    }

    public FileServerInner beginCreate(String resourceGroupName, String fileServerName, FileServerCreateParametersInner parameters) {
        return (FileServerInner)((Object)((ServiceResponse)this.beginCreateWithServiceResponseAsync(resourceGroupName, fileServerName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<FileServerInner> beginCreateAsync(String resourceGroupName, String fileServerName, FileServerCreateParametersInner parameters, ServiceCallback<FileServerInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateWithServiceResponseAsync(resourceGroupName, fileServerName, parameters), serviceCallback);
    }

    public Observable<FileServerInner> beginCreateAsync(String resourceGroupName, String fileServerName, FileServerCreateParametersInner parameters) {
        return this.beginCreateWithServiceResponseAsync(resourceGroupName, fileServerName, parameters).map((Func1)new Func1<ServiceResponse<FileServerInner>, FileServerInner>(){

            public FileServerInner call(ServiceResponse<FileServerInner> response) {
                return (FileServerInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<FileServerInner>> beginCreateWithServiceResponseAsync(String resourceGroupName, String fileServerName, FileServerCreateParametersInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (fileServerName == null) {
            throw new IllegalArgumentException("Parameter fileServerName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.beginCreate(resourceGroupName, fileServerName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<FileServerInner>>>(){

            public Observable<ServiceResponse<FileServerInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = FileServersInner.this.beginCreateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<FileServerInner> beginCreateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<FileServerInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String fileServerName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, fileServerName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String fileServerName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, fileServerName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String fileServerName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, fileServerName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String fileServerName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (fileServerName == null) {
            throw new IllegalArgumentException("Parameter fileServerName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, fileServerName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String fileServerName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, fileServerName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String fileServerName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, fileServerName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String fileServerName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, fileServerName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String fileServerName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (fileServerName == null) {
            throw new IllegalArgumentException("Parameter fileServerName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginDelete(resourceGroupName, fileServerName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = FileServersInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public FileServerInner getByResourceGroup(String resourceGroupName, String fileServerName) {
        return (FileServerInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, fileServerName).toBlocking().single()).body());
    }

    public ServiceFuture<FileServerInner> getByResourceGroupAsync(String resourceGroupName, String fileServerName, ServiceCallback<FileServerInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, fileServerName), serviceCallback);
    }

    public Observable<FileServerInner> getByResourceGroupAsync(String resourceGroupName, String fileServerName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, fileServerName).map((Func1)new Func1<ServiceResponse<FileServerInner>, FileServerInner>(){

            public FileServerInner call(ServiceResponse<FileServerInner> response) {
                return (FileServerInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<FileServerInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String fileServerName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (fileServerName == null) {
            throw new IllegalArgumentException("Parameter fileServerName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getByResourceGroup(resourceGroupName, fileServerName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<FileServerInner>>>(){

            public Observable<ServiceResponse<FileServerInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = FileServersInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<FileServerInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<FileServerInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<FileServerInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<FileServerInner>((Page)response.body()){

            public Page<FileServerInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)FileServersInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<FileServerInner>> listAsync(ListOperationCallback<FileServerInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<FileServerInner>>>>(){

            public Observable<ServiceResponse<Page<FileServerInner>>> call(String nextPageLink) {
                return FileServersInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<FileServerInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<FileServerInner>>, Page<FileServerInner>>(){

            public Page<FileServerInner> call(ServiceResponse<Page<FileServerInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<FileServerInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<FileServerInner>>, Observable<ServiceResponse<Page<FileServerInner>>>>(){

            public Observable<ServiceResponse<Page<FileServerInner>>> call(ServiceResponse<Page<FileServerInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(FileServersInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<FileServerInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object fileServersListOptions = null;
        String filter = null;
        String select = null;
        Integer maxResults = null;
        return this.service.list(this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), filter, select, maxResults, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<FileServerInner>>>>(){

            public Observable<ServiceResponse<Page<FileServerInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = FileServersInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<FileServerInner> list(FileServersListOptionsInner fileServersListOptions) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(fileServersListOptions).toBlocking().single();
        return new PagedList<FileServerInner>((Page)response.body()){

            public Page<FileServerInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)FileServersInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<FileServerInner>> listAsync(FileServersListOptionsInner fileServersListOptions, ListOperationCallback<FileServerInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(fileServersListOptions), (Func1)new Func1<String, Observable<ServiceResponse<Page<FileServerInner>>>>(){

            public Observable<ServiceResponse<Page<FileServerInner>>> call(String nextPageLink) {
                return FileServersInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<FileServerInner>> listAsync(FileServersListOptionsInner fileServersListOptions) {
        return this.listWithServiceResponseAsync(fileServersListOptions).map((Func1)new Func1<ServiceResponse<Page<FileServerInner>>, Page<FileServerInner>>(){

            public Page<FileServerInner> call(ServiceResponse<Page<FileServerInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<FileServerInner>>> listWithServiceResponseAsync(FileServersListOptionsInner fileServersListOptions) {
        return this.listSinglePageAsync(fileServersListOptions).concatMap((Func1)new Func1<ServiceResponse<Page<FileServerInner>>, Observable<ServiceResponse<Page<FileServerInner>>>>(){

            public Observable<ServiceResponse<Page<FileServerInner>>> call(ServiceResponse<Page<FileServerInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(FileServersInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<FileServerInner>>> listSinglePageAsync(FileServersListOptionsInner fileServersListOptions) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)fileServersListOptions);
        String filter = null;
        if (fileServersListOptions != null) {
            filter = fileServersListOptions.filter();
        }
        String select = null;
        if (fileServersListOptions != null) {
            select = fileServersListOptions.select();
        }
        Integer maxResults = null;
        if (fileServersListOptions != null) {
            maxResults = fileServersListOptions.maxResults();
        }
        return this.service.list(this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), filter, select, maxResults, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<FileServerInner>>>>(){

            public Observable<ServiceResponse<Page<FileServerInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = FileServersInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<FileServerInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<FileServerInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<FileServerInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<FileServerInner>((Page)response.body()){

            public Page<FileServerInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)FileServersInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<FileServerInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<FileServerInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<FileServerInner>>>>(){

            public Observable<ServiceResponse<Page<FileServerInner>>> call(String nextPageLink) {
                return FileServersInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<FileServerInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<FileServerInner>>, Page<FileServerInner>>(){

            public Page<FileServerInner> call(ServiceResponse<Page<FileServerInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<FileServerInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<FileServerInner>>, Observable<ServiceResponse<Page<FileServerInner>>>>(){

            public Observable<ServiceResponse<Page<FileServerInner>>> call(ServiceResponse<Page<FileServerInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(FileServersInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<FileServerInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object fileServersListByResourceGroupOptions = null;
        String filter = null;
        String select = null;
        Integer maxResults = null;
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), filter, select, maxResults, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<FileServerInner>>>>(){

            public Observable<ServiceResponse<Page<FileServerInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = FileServersInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<FileServerInner> listByResourceGroup(String resourceGroupName, FileServersListByResourceGroupOptionsInner fileServersListByResourceGroupOptions) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName, fileServersListByResourceGroupOptions).toBlocking().single();
        return new PagedList<FileServerInner>((Page)response.body()){

            public Page<FileServerInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)FileServersInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<FileServerInner>> listByResourceGroupAsync(String resourceGroupName, FileServersListByResourceGroupOptionsInner fileServersListByResourceGroupOptions, ListOperationCallback<FileServerInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName, fileServersListByResourceGroupOptions), (Func1)new Func1<String, Observable<ServiceResponse<Page<FileServerInner>>>>(){

            public Observable<ServiceResponse<Page<FileServerInner>>> call(String nextPageLink) {
                return FileServersInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<FileServerInner>> listByResourceGroupAsync(String resourceGroupName, FileServersListByResourceGroupOptionsInner fileServersListByResourceGroupOptions) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName, fileServersListByResourceGroupOptions).map((Func1)new Func1<ServiceResponse<Page<FileServerInner>>, Page<FileServerInner>>(){

            public Page<FileServerInner> call(ServiceResponse<Page<FileServerInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<FileServerInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName, FileServersListByResourceGroupOptionsInner fileServersListByResourceGroupOptions) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName, fileServersListByResourceGroupOptions).concatMap((Func1)new Func1<ServiceResponse<Page<FileServerInner>>, Observable<ServiceResponse<Page<FileServerInner>>>>(){

            public Observable<ServiceResponse<Page<FileServerInner>>> call(ServiceResponse<Page<FileServerInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(FileServersInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<FileServerInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName, FileServersListByResourceGroupOptionsInner fileServersListByResourceGroupOptions) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)fileServersListByResourceGroupOptions);
        String filter = null;
        if (fileServersListByResourceGroupOptions != null) {
            filter = fileServersListByResourceGroupOptions.filter();
        }
        String select = null;
        if (fileServersListByResourceGroupOptions != null) {
            select = fileServersListByResourceGroupOptions.select();
        }
        Integer maxResults = null;
        if (fileServersListByResourceGroupOptions != null) {
            maxResults = fileServersListByResourceGroupOptions.maxResults();
        }
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), filter, select, maxResults, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<FileServerInner>>>>(){

            public Observable<ServiceResponse<Page<FileServerInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = FileServersInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<FileServerInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<FileServerInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<FileServerInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<FileServerInner>((Page)response.body()){

            public Page<FileServerInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)FileServersInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<FileServerInner>> listNextAsync(String nextPageLink, ServiceFuture<List<FileServerInner>> serviceFuture, ListOperationCallback<FileServerInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<FileServerInner>>>>(){

            public Observable<ServiceResponse<Page<FileServerInner>>> call(String nextPageLink) {
                return FileServersInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<FileServerInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<FileServerInner>>, Page<FileServerInner>>(){

            public Page<FileServerInner> call(ServiceResponse<Page<FileServerInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<FileServerInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<FileServerInner>>, Observable<ServiceResponse<Page<FileServerInner>>>>(){

            public Observable<ServiceResponse<Page<FileServerInner>>> call(ServiceResponse<Page<FileServerInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(FileServersInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<FileServerInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<FileServerInner>>>>(){

            public Observable<ServiceResponse<Page<FileServerInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = FileServersInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<FileServerInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<FileServerInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<FileServerInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<FileServerInner>((Page)response.body()){

            public Page<FileServerInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)FileServersInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<FileServerInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<FileServerInner>> serviceFuture, ListOperationCallback<FileServerInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<FileServerInner>>>>(){

            public Observable<ServiceResponse<Page<FileServerInner>>> call(String nextPageLink) {
                return FileServersInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<FileServerInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<FileServerInner>>, Page<FileServerInner>>(){

            public Page<FileServerInner> call(ServiceResponse<Page<FileServerInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<FileServerInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<FileServerInner>>, Observable<ServiceResponse<Page<FileServerInner>>>>(){

            public Observable<ServiceResponse<Page<FileServerInner>>> call(ServiceResponse<Page<FileServerInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(FileServersInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<FileServerInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<FileServerInner>>>>(){

            public Observable<ServiceResponse<Page<FileServerInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = FileServersInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<FileServerInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<FileServerInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface FileServersService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.FileServers create"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/fileServers/{fileServerName}")
        public Observable<Response<ResponseBody>> create(@Path(value="resourceGroupName") String var1, @Path(value="fileServerName") String var2, @Path(value="subscriptionId") String var3, @Body FileServerCreateParametersInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.FileServers beginCreate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/fileServers/{fileServerName}")
        public Observable<Response<ResponseBody>> beginCreate(@Path(value="resourceGroupName") String var1, @Path(value="fileServerName") String var2, @Path(value="subscriptionId") String var3, @Body FileServerCreateParametersInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.FileServers delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/fileServers/{fileServerName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="fileServerName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.FileServers beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/fileServers/{fileServerName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="fileServerName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.FileServers getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/fileServers/{fileServerName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="fileServerName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.FileServers list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.BatchAI/fileServers")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Query(value="$filter") String var4, @Query(value="$select") String var5, @Query(value="maxresults") Integer var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.FileServers listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/fileServers")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Query(value="$filter") String var5, @Query(value="$select") String var6, @Query(value="maxresults") Integer var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.FileServers listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.FileServers listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

