/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batchai;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Use this to prepare the VM. NOTE: The volumes specified in mountVolumes are
 * mounted first and then the setupTask is run. Therefore the setup task can
 * use local mountPaths in its execution.
 */
public class NodeSetup {
    /**
     * Specifies a setup task which can be used to customize the compute nodes
     * of the cluster. The NodeSetup task runs everytime a VM is rebooted. For
     * that reason the task code needs to be idempotent. Generally it is used
     * to either download static data that is required for all jobs that run on
     * the cluster VMs or to download/install software.
     */
    @JsonProperty(value = "setupTask")
    private SetupTask setupTask;

    /**
     * Information on shared volumes to be used by jobs.
     */
    @JsonProperty(value = "mountVolumes")
    private MountVolumes mountVolumes;

    /**
     * Get the setupTask value.
     *
     * @return the setupTask value
     */
    public SetupTask setupTask() {
        return this.setupTask;
    }

    /**
     * Set the setupTask value.
     *
     * @param setupTask the setupTask value to set
     * @return the NodeSetup object itself.
     */
    public NodeSetup withSetupTask(SetupTask setupTask) {
        this.setupTask = setupTask;
        return this;
    }

    /**
     * Get the mountVolumes value.
     *
     * @return the mountVolumes value
     */
    public MountVolumes mountVolumes() {
        return this.mountVolumes;
    }

    /**
     * Set the mountVolumes value.
     *
     * @param mountVolumes the mountVolumes value to set
     * @return the NodeSetup object itself.
     */
    public NodeSetup withMountVolumes(MountVolumes mountVolumes) {
        this.mountVolumes = mountVolumes;
        return this;
    }

}
