/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batchai;

import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Specifies a setup task which can be used to customize the compute nodes of
 * the cluster.
 */
public class SetupTask {
    /**
     * Command Line to start Setup process.
     */
    @JsonProperty(value = "commandLine", required = true)
    private String commandLine;

    /**
     * Collection of environment settings.
     */
    @JsonProperty(value = "environmentVariables")
    private List<EnvironmentSetting> environmentVariables;

    /**
     * Specifies whether to run the setup task in elevated mode. The default
     * value is false.
     */
    @JsonProperty(value = "runElevated")
    private Boolean runElevated;

    /**
     * The path where the Batch AI service will upload the stdout and stderror
     * of setup task.
     */
    @JsonProperty(value = "stdOutErrPathPrefix", required = true)
    private String stdOutErrPathPrefix;

    /**
     * Get the commandLine value.
     *
     * @return the commandLine value
     */
    public String commandLine() {
        return this.commandLine;
    }

    /**
     * Set the commandLine value.
     *
     * @param commandLine the commandLine value to set
     * @return the SetupTask object itself.
     */
    public SetupTask withCommandLine(String commandLine) {
        this.commandLine = commandLine;
        return this;
    }

    /**
     * Get the environmentVariables value.
     *
     * @return the environmentVariables value
     */
    public List<EnvironmentSetting> environmentVariables() {
        return this.environmentVariables;
    }

    /**
     * Set the environmentVariables value.
     *
     * @param environmentVariables the environmentVariables value to set
     * @return the SetupTask object itself.
     */
    public SetupTask withEnvironmentVariables(List<EnvironmentSetting> environmentVariables) {
        this.environmentVariables = environmentVariables;
        return this;
    }

    /**
     * Get the runElevated value.
     *
     * @return the runElevated value
     */
    public Boolean runElevated() {
        return this.runElevated;
    }

    /**
     * Set the runElevated value.
     *
     * @param runElevated the runElevated value to set
     * @return the SetupTask object itself.
     */
    public SetupTask withRunElevated(Boolean runElevated) {
        this.runElevated = runElevated;
        return this;
    }

    /**
     * Get the stdOutErrPathPrefix value.
     *
     * @return the stdOutErrPathPrefix value
     */
    public String stdOutErrPathPrefix() {
        return this.stdOutErrPathPrefix;
    }

    /**
     * Set the stdOutErrPathPrefix value.
     *
     * @param stdOutErrPathPrefix the stdOutErrPathPrefix value to set
     * @return the SetupTask object itself.
     */
    public SetupTask withStdOutErrPathPrefix(String stdOutErrPathPrefix) {
        this.stdOutErrPathPrefix = stdOutErrPathPrefix;
        return this;
    }

}
