/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.batchai;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.apigeneration.Method;
import com.microsoft.azure.management.batchai.BatchAICluster;
import com.microsoft.azure.management.batchai.CNTKsettings;
import com.microsoft.azure.management.batchai.CaffeSettings;
import com.microsoft.azure.management.batchai.ChainerSettings;
import com.microsoft.azure.management.batchai.ContainerSettings;
import com.microsoft.azure.management.batchai.CustomToolkitSettings;
import com.microsoft.azure.management.batchai.EnvironmentSetting;
import com.microsoft.azure.management.batchai.ExecutionState;
import com.microsoft.azure.management.batchai.InputDirectory;
import com.microsoft.azure.management.batchai.JobPreparation;
import com.microsoft.azure.management.batchai.JobPropertiesConstraints;
import com.microsoft.azure.management.batchai.JobPropertiesExecutionInfo;
import com.microsoft.azure.management.batchai.OutputDirectory;
import com.microsoft.azure.management.batchai.OutputFile;
import com.microsoft.azure.management.batchai.ProvisioningState;
import com.microsoft.azure.management.batchai.ResourceId;
import com.microsoft.azure.management.batchai.TensorFlowSettings;
import com.microsoft.azure.management.batchai.ToolType;
import com.microsoft.azure.management.batchai.ToolTypeSettings;
import com.microsoft.azure.management.batchai.implementation.BatchAIManager;
import com.microsoft.azure.management.batchai.implementation.JobInner;
import com.microsoft.azure.management.resources.fluentcore.arm.models.HasParent;
import com.microsoft.azure.management.resources.fluentcore.arm.models.IndependentChildResource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import java.util.List;
import org.joda.time.DateTime;
import rx.Completable;
import rx.Observable;

@Fluent
@Beta(value=Beta.SinceVersion.V1_6_0)
public interface BatchAIJob
extends IndependentChildResource<BatchAIManager, JobInner>,
Refreshable<BatchAIJob>,
HasParent<BatchAICluster> {
    @Method
    public void terminate();

    @Method
    public Completable terminateAsync();

    @Method
    public PagedList<OutputFile> listFiles(String var1);

    @Method
    public Observable<OutputFile> listFilesAsync(String var1);

    public String experimentName();

    public Integer priority();

    public ResourceId cluster();

    public int nodeCount();

    public ContainerSettings containerSettings();

    public ToolType toolType();

    public CNTKsettings cntkSettings();

    public TensorFlowSettings tensorFlowSettings();

    public CaffeSettings caffeSettings();

    public ChainerSettings chainerSettings();

    public CustomToolkitSettings customToolkitSettings();

    public JobPreparation jobPreparation();

    public String stdOutErrPathPrefix();

    public List<InputDirectory> inputDirectories();

    public List<OutputDirectory> outputDirectories();

    public List<EnvironmentSetting> environmentVariables();

    public JobPropertiesConstraints constraints();

    public DateTime creationTime();

    public ProvisioningState provisioningState();

    public DateTime provisioningStateTransitionTime();

    public ExecutionState executionState();

    public DateTime executionStateTransitionTime();

    public JobPropertiesExecutionInfo executionInfo();

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<BatchAIJob>,
        Resource.DefinitionWithTags<WithCreate>,
        WithJobPreparation,
        WithInputDirectory,
        WithOutputDirectory,
        WithContainerSettings,
        WithExperimentName {
        }

        public static interface WithExperimentName {
            public WithCreate withExperimentName(String var1);
        }

        public static interface WithContainerSettings {
            public WithCreate withContainerImage(String var1);
        }

        public static interface WithJobPreparation {
            public WithCreate withCommandLine(String var1);
        }

        public static interface WithOutputDirectory {
            public WithCreate withOutputDirectory(String var1, String var2);
        }

        public static interface WithInputDirectory {
            public WithCreate withInputDirectory(String var1, String var2);
        }

        public static interface WithToolType {
            public ToolTypeSettings.CognitiveToolkit.DefinitionStages.Blank<WithCreate> defineCognitiveToolkit();

            public ToolTypeSettings.TensorFlow.DefinitionStages.Blank<WithCreate> defineTensorflow();

            public ToolTypeSettings.Caffe.DefinitionStages.Blank<WithCreate> defineCaffe();

            public ToolTypeSettings.Caffe2.DefinitionStages.Blank<WithCreate> defineCaffe2();

            public ToolTypeSettings.Chainer.DefinitionStages.Blank<WithCreate> defineChainer();

            public WithCreate withCustomCommandLine(String var1);
        }

        public static interface WithNodeCount {
            public WithStdOutErrPathPrefix withNodeCount(int var1);
        }

        public static interface WithStdOutErrPathPrefix {
            public WithToolType withStdOutErrPathPrefix(String var1);
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<WithNodeCount> {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithStdOutErrPathPrefix,
    DefinitionStages.WithNodeCount,
    DefinitionStages.WithToolType,
    DefinitionStages.WithCreate {
    }
}

