/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.batchai.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.batchai.AzureBlobFileSystem;
import com.microsoft.azure.management.batchai.AzureBlobFileSystemReference;
import com.microsoft.azure.management.batchai.AzureStorageCredentialsInfo;
import com.microsoft.azure.management.batchai.BatchAICluster;
import com.microsoft.azure.management.batchai.KeyVaultSecretReference;
import com.microsoft.azure.management.batchai.implementation.BatchAIClusterImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableWrapperImpl;

@LangDefinition
class AzureBlobFileSystemImpl
extends IndexableWrapperImpl<AzureBlobFileSystemReference>
implements AzureBlobFileSystem,
AzureBlobFileSystem.Definition<BatchAICluster.DefinitionStages.WithCreate> {
    private BatchAIClusterImpl parent;

    AzureBlobFileSystemImpl(AzureBlobFileSystemReference inner, BatchAIClusterImpl parent) {
        super((Object)inner);
        this.parent = parent;
    }

    @Override
    public AzureBlobFileSystem.Definition<BatchAICluster.DefinitionStages.WithCreate> withStorageAccountName(String storageAccountName) {
        ((AzureBlobFileSystemReference)this.inner()).withAccountName(storageAccountName);
        return this;
    }

    @Override
    public AzureBlobFileSystem.Definition<BatchAICluster.DefinitionStages.WithCreate> withRelativeMountPath(String mountPath) {
        ((AzureBlobFileSystemReference)this.inner()).withRelativeMountPath(mountPath);
        return this;
    }

    public BatchAICluster parent() {
        return this.parent;
    }

    public BatchAICluster.DefinitionStages.WithCreate attach() {
        this.parent.attachAzureBlobFileSystem(this);
        return this.parent;
    }

    public AzureBlobFileSystemImpl withAccountKey(String accountKey) {
        this.ensureCredentials().withAccountKey(accountKey);
        return this;
    }

    private AzureStorageCredentialsInfo ensureCredentials() {
        if (((AzureBlobFileSystemReference)this.inner()).credentials() == null) {
            ((AzureBlobFileSystemReference)this.inner()).withCredentials(new AzureStorageCredentialsInfo());
        }
        return ((AzureBlobFileSystemReference)this.inner()).credentials();
    }

    public AzureBlobFileSystemImpl withKeyVaultSecretReference(KeyVaultSecretReference keyVaultSecretReference) {
        this.ensureCredentials().withAccountKeySecretReference(keyVaultSecretReference);
        return this;
    }

    public AzureBlobFileSystemImpl withContainerName(String containerName) {
        ((AzureBlobFileSystemReference)this.inner()).withContainerName(containerName);
        return this;
    }

    public AzureBlobFileSystemImpl withMountOptions(String mountOptions) {
        ((AzureBlobFileSystemReference)this.inner()).withMountOptions(mountOptions);
        return this;
    }
}

