/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.batchai.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.batchai.AzureFileShare;
import com.microsoft.azure.management.batchai.AzureFileShareReference;
import com.microsoft.azure.management.batchai.AzureStorageCredentialsInfo;
import com.microsoft.azure.management.batchai.BatchAICluster;
import com.microsoft.azure.management.batchai.KeyVaultSecretReference;
import com.microsoft.azure.management.batchai.implementation.BatchAIClusterImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableWrapperImpl;

@LangDefinition
class AzureFileShareImpl
extends IndexableWrapperImpl<AzureFileShareReference>
implements AzureFileShare,
AzureFileShare.Definition<BatchAICluster.DefinitionStages.WithCreate> {
    private BatchAIClusterImpl parent;

    AzureFileShareImpl(AzureFileShareReference inner, BatchAIClusterImpl parent) {
        super((Object)inner);
        this.parent = parent;
    }

    @Override
    public AzureFileShare.Definition<BatchAICluster.DefinitionStages.WithCreate> withStorageAccountName(String storageAccountName) {
        ((AzureFileShareReference)this.inner()).withAccountName(storageAccountName);
        return this;
    }

    @Override
    public AzureFileShare.Definition<BatchAICluster.DefinitionStages.WithCreate> withAzureFileUrl(String azureFileUrl) {
        ((AzureFileShareReference)this.inner()).withAzureFileUrl(azureFileUrl);
        return this;
    }

    @Override
    public AzureFileShare.Definition<BatchAICluster.DefinitionStages.WithCreate> withRelativeMountPath(String mountPath) {
        ((AzureFileShareReference)this.inner()).withRelativeMountPath(mountPath);
        return this;
    }

    public BatchAICluster parent() {
        return this.parent;
    }

    public BatchAICluster.DefinitionStages.WithCreate attach() {
        this.parent.attachAzureFileShare(this);
        return this.parent;
    }

    @Override
    public AzureFileShare.DefinitionStages.WithAttach<BatchAICluster.DefinitionStages.WithCreate> withAccountKey(String accountKey) {
        this.ensureCredentials().withAccountKey(accountKey);
        return this;
    }

    private AzureStorageCredentialsInfo ensureCredentials() {
        if (((AzureFileShareReference)this.inner()).credentials() == null) {
            ((AzureFileShareReference)this.inner()).withCredentials(new AzureStorageCredentialsInfo());
        }
        return ((AzureFileShareReference)this.inner()).credentials();
    }

    @Override
    public AzureFileShare.DefinitionStages.WithAttach<BatchAICluster.DefinitionStages.WithCreate> withKeyVaultSecretReference(KeyVaultSecretReference keyVaultSecretReference) {
        this.ensureCredentials().withAccountKeySecretReference(keyVaultSecretReference);
        return this;
    }

    @Override
    public AzureFileShare.DefinitionStages.WithAttach<BatchAICluster.DefinitionStages.WithCreate> withFileMode(String fileMode) {
        ((AzureFileShareReference)this.inner()).withFileMode(fileMode);
        return this;
    }

    @Override
    public AzureFileShare.DefinitionStages.WithAttach<BatchAICluster.DefinitionStages.WithCreate> withDirectoryMode(String directoryMode) {
        ((AzureFileShareReference)this.inner()).withDirectoryMode(directoryMode);
        return this;
    }
}

