/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.batchai.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.Resource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.batchai.BatchAICluster;
import com.microsoft.azure.management.batchai.BatchAIJob;
import com.microsoft.azure.management.batchai.CNTKsettings;
import com.microsoft.azure.management.batchai.Caffe2Settings;
import com.microsoft.azure.management.batchai.CaffeSettings;
import com.microsoft.azure.management.batchai.ChainerSettings;
import com.microsoft.azure.management.batchai.ContainerSettings;
import com.microsoft.azure.management.batchai.CustomToolkitSettings;
import com.microsoft.azure.management.batchai.EnvironmentSetting;
import com.microsoft.azure.management.batchai.ExecutionState;
import com.microsoft.azure.management.batchai.ImageSourceRegistry;
import com.microsoft.azure.management.batchai.InputDirectory;
import com.microsoft.azure.management.batchai.JobPreparation;
import com.microsoft.azure.management.batchai.JobPropertiesConstraints;
import com.microsoft.azure.management.batchai.JobPropertiesExecutionInfo;
import com.microsoft.azure.management.batchai.OutputDirectory;
import com.microsoft.azure.management.batchai.OutputFile;
import com.microsoft.azure.management.batchai.ProvisioningState;
import com.microsoft.azure.management.batchai.ResourceId;
import com.microsoft.azure.management.batchai.TensorFlowSettings;
import com.microsoft.azure.management.batchai.ToolType;
import com.microsoft.azure.management.batchai.ToolTypeSettings;
import com.microsoft.azure.management.batchai.implementation.BatchAIClusterImpl;
import com.microsoft.azure.management.batchai.implementation.BatchAIManagementClientImpl;
import com.microsoft.azure.management.batchai.implementation.BatchAIManager;
import com.microsoft.azure.management.batchai.implementation.Caffe2Impl;
import com.microsoft.azure.management.batchai.implementation.CaffeImpl;
import com.microsoft.azure.management.batchai.implementation.ChainerImpl;
import com.microsoft.azure.management.batchai.implementation.CognitiveToolkitImpl;
import com.microsoft.azure.management.batchai.implementation.FileInner;
import com.microsoft.azure.management.batchai.implementation.JobCreateParametersInner;
import com.microsoft.azure.management.batchai.implementation.JobInner;
import com.microsoft.azure.management.batchai.implementation.JobsListOutputFilesOptionsInner;
import com.microsoft.azure.management.batchai.implementation.OutputFileImpl;
import com.microsoft.azure.management.batchai.implementation.TensorFlowImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.ReadableWrappersImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.PagedListConverter;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class BatchAIJobImpl
extends GroupableResourceImpl<BatchAIJob, JobInner, BatchAIJobImpl, BatchAIManager>
implements BatchAIJob,
BatchAIJob.Definition {
    private final BatchAICluster parent;
    private JobCreateParametersInner createParameters = new JobCreateParametersInner();

    BatchAIJobImpl(String name, BatchAIClusterImpl parent, JobInner inner) {
        super(name, (Resource)inner, parent.manager());
        this.parent = parent;
    }

    public BatchAICluster parent() {
        return this.parent;
    }

    protected Observable<JobInner> getInnerAsync() {
        return ((BatchAIManagementClientImpl)((Object)((BatchAIManager)this.myManager).inner())).jobs().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    public Observable<BatchAIJob> createResourceAsync() {
        ResourceId resourceId = new ResourceId().withId(this.parent.id());
        this.createParameters.withCluster(resourceId).withLocation(((JobInner)((Object)this.inner())).location());
        return ((BatchAIManagementClientImpl)((Object)((BatchAIManager)this.myManager).inner())).jobs().createAsync(this.resourceGroupName(), this.name(), this.createParameters).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    @Override
    public BatchAIJobImpl withStdOutErrPathPrefix(String stdOutErrPathPrefix) {
        this.createParameters.withStdOutErrPathPrefix(stdOutErrPathPrefix);
        return this;
    }

    @Override
    public BatchAIJobImpl withNodeCount(int nodeCount) {
        this.createParameters.withNodeCount(nodeCount);
        return this;
    }

    @Override
    public BatchAIJobImpl withCommandLine(String commandLine) {
        this.createParameters.withJobPreparation(new JobPreparation().withCommandLine(commandLine));
        return this;
    }

    @Override
    public BatchAIJobImpl withInputDirectory(String id, String path) {
        this.ensureInputDirectories().add(new InputDirectory().withId(id).withPath(path));
        return this;
    }

    private List<InputDirectory> ensureInputDirectories() {
        if (this.createParameters.inputDirectories() == null) {
            this.createParameters.withInputDirectories(new ArrayList<InputDirectory>());
        }
        return this.createParameters.inputDirectories();
    }

    @Override
    public BatchAIJobImpl withOutputDirectory(String id, String pathPrefix) {
        if (this.createParameters.outputDirectories() == null) {
            this.createParameters.withOutputDirectories(new ArrayList<OutputDirectory>());
        }
        this.createParameters.outputDirectories().add(new OutputDirectory().withId(id).withPathPrefix(pathPrefix));
        return this;
    }

    @Override
    public BatchAIJobImpl withContainerImage(String image) {
        if (this.ensureContainerSettings().imageSourceRegistry() == null) {
            this.createParameters.containerSettings().withImageSourceRegistry(new ImageSourceRegistry());
        }
        this.createParameters.containerSettings().imageSourceRegistry().withImage(image);
        return this;
    }

    private ContainerSettings ensureContainerSettings() {
        if (this.createParameters.containerSettings() == null) {
            this.createParameters.withContainerSettings(new ContainerSettings());
        }
        return this.createParameters.containerSettings();
    }

    @Override
    public BatchAIJob.DefinitionStages.WithCreate withExperimentName(String experimentName) {
        ((JobInner)((Object)this.inner())).withExperimentName(experimentName);
        return this;
    }

    @Override
    public ToolTypeSettings.CognitiveToolkit.DefinitionStages.Blank<BatchAIJob.DefinitionStages.WithCreate> defineCognitiveToolkit() {
        return new CognitiveToolkitImpl(new CNTKsettings(), this);
    }

    @Override
    public ToolTypeSettings.TensorFlow.DefinitionStages.Blank<BatchAIJob.DefinitionStages.WithCreate> defineTensorflow() {
        return new TensorFlowImpl(new TensorFlowSettings(), this);
    }

    @Override
    public ToolTypeSettings.Caffe.DefinitionStages.Blank<BatchAIJob.DefinitionStages.WithCreate> defineCaffe() {
        return new CaffeImpl(new CaffeSettings(), this);
    }

    @Override
    public ToolTypeSettings.Caffe2.DefinitionStages.Blank<BatchAIJob.DefinitionStages.WithCreate> defineCaffe2() {
        return new Caffe2Impl(new Caffe2Settings(), this);
    }

    @Override
    public ToolTypeSettings.Chainer.DefinitionStages.Blank<BatchAIJob.DefinitionStages.WithCreate> defineChainer() {
        return new ChainerImpl(new ChainerSettings(), this);
    }

    @Override
    public BatchAIJobImpl withCustomCommandLine(String commandLine) {
        ((JobInner)((Object)this.inner())).withCustomToolkitSettings(new CustomToolkitSettings().withCommandLine(commandLine));
        return this;
    }

    void attachCntkSettings(CognitiveToolkitImpl cognitiveToolkit) {
        this.createParameters.withCntkSettings((CNTKsettings)cognitiveToolkit.inner());
    }

    void attachTensorFlowSettings(TensorFlowImpl tensorFlow) {
        this.createParameters.withTensorFlowSettings((TensorFlowSettings)tensorFlow.inner());
    }

    void attachCaffeSettings(CaffeImpl caffe) {
        this.createParameters.withCaffeSettings((CaffeSettings)caffe.inner());
    }

    void attachCaffe2Settings(Caffe2Impl caffe2) {
        this.createParameters.withCaffe2Settings((Caffe2Settings)caffe2.inner());
    }

    void attachChainerSettings(ChainerImpl chainer) {
        this.createParameters.withChainerSettings((ChainerSettings)chainer.inner());
    }

    @Override
    public void terminate() {
        this.terminateAsync().await();
    }

    @Override
    public Completable terminateAsync() {
        Observable<Void> stopObservable = ((BatchAIManagementClientImpl)((Object)((BatchAIManager)this.manager()).inner())).jobs().terminateAsync(this.resourceGroupName(), this.name());
        Observable refreshObservable = this.refreshAsync();
        return Observable.concat(stopObservable, (Observable)refreshObservable).toCompletable();
    }

    @Override
    public PagedList<OutputFile> listFiles(String outputDirectoryId) {
        PagedListConverter<FileInner, OutputFile> converter = new PagedListConverter<FileInner, OutputFile>(){

            public Observable<OutputFile> typeConvertAsync(FileInner fileInner) {
                return Observable.just((Object)new OutputFileImpl(fileInner));
            }
        };
        return converter.convert(((BatchAIManagementClientImpl)((Object)((BatchAIManager)this.manager()).inner())).jobs().listOutputFiles(this.resourceGroupName(), this.name(), new JobsListOutputFilesOptionsInner().withOutputdirectoryid(outputDirectoryId)));
    }

    @Override
    public Observable<OutputFile> listFilesAsync(String outputDirectoryId) {
        return ReadableWrappersImpl.convertPageToInnerAsync(((BatchAIManagementClientImpl)((Object)((BatchAIManager)this.manager()).inner())).jobs().listOutputFilesAsync(this.resourceGroupName(), this.name(), new JobsListOutputFilesOptionsInner().withOutputdirectoryid(outputDirectoryId))).map((Func1)new Func1<FileInner, OutputFile>(){

            public OutputFile call(FileInner fileInner) {
                return new OutputFileImpl(fileInner);
            }
        });
    }

    @Override
    public String experimentName() {
        return ((JobInner)((Object)this.inner())).experimentName();
    }

    @Override
    public Integer priority() {
        return ((JobInner)((Object)this.inner())).priority();
    }

    @Override
    public ResourceId cluster() {
        return ((JobInner)((Object)this.inner())).cluster();
    }

    @Override
    public int nodeCount() {
        return Utils.toPrimitiveInt((Integer)((JobInner)((Object)this.inner())).nodeCount());
    }

    @Override
    public ContainerSettings containerSettings() {
        return ((JobInner)((Object)this.inner())).containerSettings();
    }

    @Override
    public ToolType toolType() {
        return ((JobInner)((Object)this.inner())).toolType();
    }

    @Override
    public CNTKsettings cntkSettings() {
        return ((JobInner)((Object)this.inner())).cntkSettings();
    }

    @Override
    public TensorFlowSettings tensorFlowSettings() {
        return ((JobInner)((Object)this.inner())).tensorFlowSettings();
    }

    @Override
    public CaffeSettings caffeSettings() {
        return ((JobInner)((Object)this.inner())).caffeSettings();
    }

    @Override
    public ChainerSettings chainerSettings() {
        return ((JobInner)((Object)this.inner())).chainerSettings();
    }

    @Override
    public CustomToolkitSettings customToolkitSettings() {
        return ((JobInner)((Object)this.inner())).customToolkitSettings();
    }

    @Override
    public JobPreparation jobPreparation() {
        return ((JobInner)((Object)this.inner())).jobPreparation();
    }

    @Override
    public String stdOutErrPathPrefix() {
        return ((JobInner)((Object)this.inner())).stdOutErrPathPrefix();
    }

    @Override
    public List<InputDirectory> inputDirectories() {
        return ((JobInner)((Object)this.inner())).inputDirectories();
    }

    @Override
    public List<OutputDirectory> outputDirectories() {
        return ((JobInner)((Object)this.inner())).outputDirectories();
    }

    @Override
    public List<EnvironmentSetting> environmentVariables() {
        return ((JobInner)((Object)this.inner())).environmentVariables();
    }

    @Override
    public JobPropertiesConstraints constraints() {
        return ((JobInner)((Object)this.inner())).constraints();
    }

    @Override
    public DateTime creationTime() {
        return ((JobInner)((Object)this.inner())).creationTime();
    }

    @Override
    public ProvisioningState provisioningState() {
        return ((JobInner)((Object)this.inner())).provisioningState();
    }

    @Override
    public DateTime provisioningStateTransitionTime() {
        return ((JobInner)((Object)this.inner())).provisioningStateTransitionTime();
    }

    @Override
    public ExecutionState executionState() {
        return ((JobInner)((Object)this.inner())).executionState();
    }

    @Override
    public DateTime executionStateTransitionTime() {
        return ((JobInner)((Object)this.inner())).executionStateTransitionTime();
    }

    @Override
    public JobPropertiesExecutionInfo executionInfo() {
        return ((JobInner)((Object)this.inner())).executionInfo();
    }
}

