/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.batchai.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.batchai.implementation.BatchAIManagementClientImpl;
import com.microsoft.azure.management.batchai.implementation.ClusterCreateParametersInner;
import com.microsoft.azure.management.batchai.implementation.ClusterInner;
import com.microsoft.azure.management.batchai.implementation.ClusterUpdateParametersInner;
import com.microsoft.azure.management.batchai.implementation.ClustersListByResourceGroupOptionsInner;
import com.microsoft.azure.management.batchai.implementation.ClustersListOptionsInner;
import com.microsoft.azure.management.batchai.implementation.PageImpl;
import com.microsoft.azure.management.batchai.implementation.RemoteLoginInformationInner;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class ClustersInner
implements InnerSupportsGet<ClusterInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<ClusterInner> {
    private ClustersService service;
    private BatchAIManagementClientImpl client;

    public ClustersInner(Retrofit retrofit, BatchAIManagementClientImpl client) {
        this.service = (ClustersService)retrofit.create(ClustersService.class);
        this.client = client;
    }

    public ClusterInner create(String resourceGroupName, String clusterName, ClusterCreateParametersInner parameters) {
        return (ClusterInner)((Object)((ServiceResponse)this.createWithServiceResponseAsync(resourceGroupName, clusterName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<ClusterInner> createAsync(String resourceGroupName, String clusterName, ClusterCreateParametersInner parameters, ServiceCallback<ClusterInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createWithServiceResponseAsync(resourceGroupName, clusterName, parameters), serviceCallback);
    }

    public Observable<ClusterInner> createAsync(String resourceGroupName, String clusterName, ClusterCreateParametersInner parameters) {
        return this.createWithServiceResponseAsync(resourceGroupName, clusterName, parameters).map((Func1)new Func1<ServiceResponse<ClusterInner>, ClusterInner>(){

            public ClusterInner call(ServiceResponse<ClusterInner> response) {
                return (ClusterInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ClusterInner>> createWithServiceResponseAsync(String resourceGroupName, String clusterName, ClusterCreateParametersInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (clusterName == null) {
            throw new IllegalArgumentException("Parameter clusterName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        Observable<Response<ResponseBody>> observable = this.service.create(resourceGroupName, clusterName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<ClusterInner>(){}.getType());
    }

    public ClusterInner beginCreate(String resourceGroupName, String clusterName, ClusterCreateParametersInner parameters) {
        return (ClusterInner)((Object)((ServiceResponse)this.beginCreateWithServiceResponseAsync(resourceGroupName, clusterName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<ClusterInner> beginCreateAsync(String resourceGroupName, String clusterName, ClusterCreateParametersInner parameters, ServiceCallback<ClusterInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateWithServiceResponseAsync(resourceGroupName, clusterName, parameters), serviceCallback);
    }

    public Observable<ClusterInner> beginCreateAsync(String resourceGroupName, String clusterName, ClusterCreateParametersInner parameters) {
        return this.beginCreateWithServiceResponseAsync(resourceGroupName, clusterName, parameters).map((Func1)new Func1<ServiceResponse<ClusterInner>, ClusterInner>(){

            public ClusterInner call(ServiceResponse<ClusterInner> response) {
                return (ClusterInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ClusterInner>> beginCreateWithServiceResponseAsync(String resourceGroupName, String clusterName, ClusterCreateParametersInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (clusterName == null) {
            throw new IllegalArgumentException("Parameter clusterName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.beginCreate(resourceGroupName, clusterName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ClusterInner>>>(){

            public Observable<ServiceResponse<ClusterInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ClustersInner.this.beginCreateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ClusterInner> beginCreateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ClusterInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ClusterInner update(String resourceGroupName, String clusterName, ClusterUpdateParametersInner parameters) {
        return (ClusterInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, clusterName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<ClusterInner> updateAsync(String resourceGroupName, String clusterName, ClusterUpdateParametersInner parameters, ServiceCallback<ClusterInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, clusterName, parameters), serviceCallback);
    }

    public Observable<ClusterInner> updateAsync(String resourceGroupName, String clusterName, ClusterUpdateParametersInner parameters) {
        return this.updateWithServiceResponseAsync(resourceGroupName, clusterName, parameters).map((Func1)new Func1<ServiceResponse<ClusterInner>, ClusterInner>(){

            public ClusterInner call(ServiceResponse<ClusterInner> response) {
                return (ClusterInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ClusterInner>> updateWithServiceResponseAsync(String resourceGroupName, String clusterName, ClusterUpdateParametersInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (clusterName == null) {
            throw new IllegalArgumentException("Parameter clusterName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.update(resourceGroupName, clusterName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ClusterInner>>>(){

            public Observable<ServiceResponse<ClusterInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ClustersInner.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ClusterInner> updateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ClusterInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String clusterName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, clusterName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String clusterName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, clusterName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String clusterName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, clusterName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String clusterName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (clusterName == null) {
            throw new IllegalArgumentException("Parameter clusterName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, clusterName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String clusterName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, clusterName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String clusterName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, clusterName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String clusterName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, clusterName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String clusterName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (clusterName == null) {
            throw new IllegalArgumentException("Parameter clusterName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginDelete(resourceGroupName, clusterName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ClustersInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ClusterInner getByResourceGroup(String resourceGroupName, String clusterName) {
        return (ClusterInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, clusterName).toBlocking().single()).body());
    }

    public ServiceFuture<ClusterInner> getByResourceGroupAsync(String resourceGroupName, String clusterName, ServiceCallback<ClusterInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, clusterName), serviceCallback);
    }

    public Observable<ClusterInner> getByResourceGroupAsync(String resourceGroupName, String clusterName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, clusterName).map((Func1)new Func1<ServiceResponse<ClusterInner>, ClusterInner>(){

            public ClusterInner call(ServiceResponse<ClusterInner> response) {
                return (ClusterInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ClusterInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String clusterName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (clusterName == null) {
            throw new IllegalArgumentException("Parameter clusterName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getByResourceGroup(resourceGroupName, clusterName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ClusterInner>>>(){

            public Observable<ServiceResponse<ClusterInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ClustersInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ClusterInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ClusterInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<RemoteLoginInformationInner> listRemoteLoginInformation(String resourceGroupName, String clusterName) {
        ServiceResponse response = (ServiceResponse)this.listRemoteLoginInformationSinglePageAsync(resourceGroupName, clusterName).toBlocking().single();
        return new PagedList<RemoteLoginInformationInner>((Page)response.body()){

            public Page<RemoteLoginInformationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ClustersInner.this.listRemoteLoginInformationNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RemoteLoginInformationInner>> listRemoteLoginInformationAsync(String resourceGroupName, String clusterName, ListOperationCallback<RemoteLoginInformationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listRemoteLoginInformationSinglePageAsync(resourceGroupName, clusterName), (Func1)new Func1<String, Observable<ServiceResponse<Page<RemoteLoginInformationInner>>>>(){

            public Observable<ServiceResponse<Page<RemoteLoginInformationInner>>> call(String nextPageLink) {
                return ClustersInner.this.listRemoteLoginInformationNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RemoteLoginInformationInner>> listRemoteLoginInformationAsync(String resourceGroupName, String clusterName) {
        return this.listRemoteLoginInformationWithServiceResponseAsync(resourceGroupName, clusterName).map((Func1)new Func1<ServiceResponse<Page<RemoteLoginInformationInner>>, Page<RemoteLoginInformationInner>>(){

            public Page<RemoteLoginInformationInner> call(ServiceResponse<Page<RemoteLoginInformationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RemoteLoginInformationInner>>> listRemoteLoginInformationWithServiceResponseAsync(String resourceGroupName, String clusterName) {
        return this.listRemoteLoginInformationSinglePageAsync(resourceGroupName, clusterName).concatMap((Func1)new Func1<ServiceResponse<Page<RemoteLoginInformationInner>>, Observable<ServiceResponse<Page<RemoteLoginInformationInner>>>>(){

            public Observable<ServiceResponse<Page<RemoteLoginInformationInner>>> call(ServiceResponse<Page<RemoteLoginInformationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ClustersInner.this.listRemoteLoginInformationNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RemoteLoginInformationInner>>> listRemoteLoginInformationSinglePageAsync(String resourceGroupName, String clusterName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (clusterName == null) {
            throw new IllegalArgumentException("Parameter clusterName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listRemoteLoginInformation(resourceGroupName, clusterName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RemoteLoginInformationInner>>>>(){

            public Observable<ServiceResponse<Page<RemoteLoginInformationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ClustersInner.this.listRemoteLoginInformationDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RemoteLoginInformationInner>> listRemoteLoginInformationDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RemoteLoginInformationInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ClusterInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<ClusterInner>((Page)response.body()){

            public Page<ClusterInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ClustersInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ClusterInner>> listAsync(ListOperationCallback<ClusterInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<ClusterInner>>>>(){

            public Observable<ServiceResponse<Page<ClusterInner>>> call(String nextPageLink) {
                return ClustersInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ClusterInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<ClusterInner>>, Page<ClusterInner>>(){

            public Page<ClusterInner> call(ServiceResponse<Page<ClusterInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ClusterInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<ClusterInner>>, Observable<ServiceResponse<Page<ClusterInner>>>>(){

            public Observable<ServiceResponse<Page<ClusterInner>>> call(ServiceResponse<Page<ClusterInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ClustersInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ClusterInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object clustersListOptions = null;
        String filter = null;
        String select = null;
        Integer maxResults = null;
        return this.service.list(this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), filter, select, maxResults, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ClusterInner>>>>(){

            public Observable<ServiceResponse<Page<ClusterInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ClustersInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<ClusterInner> list(ClustersListOptionsInner clustersListOptions) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(clustersListOptions).toBlocking().single();
        return new PagedList<ClusterInner>((Page)response.body()){

            public Page<ClusterInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ClustersInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ClusterInner>> listAsync(ClustersListOptionsInner clustersListOptions, ListOperationCallback<ClusterInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(clustersListOptions), (Func1)new Func1<String, Observable<ServiceResponse<Page<ClusterInner>>>>(){

            public Observable<ServiceResponse<Page<ClusterInner>>> call(String nextPageLink) {
                return ClustersInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ClusterInner>> listAsync(ClustersListOptionsInner clustersListOptions) {
        return this.listWithServiceResponseAsync(clustersListOptions).map((Func1)new Func1<ServiceResponse<Page<ClusterInner>>, Page<ClusterInner>>(){

            public Page<ClusterInner> call(ServiceResponse<Page<ClusterInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ClusterInner>>> listWithServiceResponseAsync(ClustersListOptionsInner clustersListOptions) {
        return this.listSinglePageAsync(clustersListOptions).concatMap((Func1)new Func1<ServiceResponse<Page<ClusterInner>>, Observable<ServiceResponse<Page<ClusterInner>>>>(){

            public Observable<ServiceResponse<Page<ClusterInner>>> call(ServiceResponse<Page<ClusterInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ClustersInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ClusterInner>>> listSinglePageAsync(ClustersListOptionsInner clustersListOptions) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)clustersListOptions);
        String filter = null;
        if (clustersListOptions != null) {
            filter = clustersListOptions.filter();
        }
        String select = null;
        if (clustersListOptions != null) {
            select = clustersListOptions.select();
        }
        Integer maxResults = null;
        if (clustersListOptions != null) {
            maxResults = clustersListOptions.maxResults();
        }
        return this.service.list(this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), filter, select, maxResults, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ClusterInner>>>>(){

            public Observable<ServiceResponse<Page<ClusterInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ClustersInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ClusterInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ClusterInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ClusterInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<ClusterInner>((Page)response.body()){

            public Page<ClusterInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ClustersInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ClusterInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<ClusterInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<ClusterInner>>>>(){

            public Observable<ServiceResponse<Page<ClusterInner>>> call(String nextPageLink) {
                return ClustersInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ClusterInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<ClusterInner>>, Page<ClusterInner>>(){

            public Page<ClusterInner> call(ServiceResponse<Page<ClusterInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ClusterInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<ClusterInner>>, Observable<ServiceResponse<Page<ClusterInner>>>>(){

            public Observable<ServiceResponse<Page<ClusterInner>>> call(ServiceResponse<Page<ClusterInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ClustersInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ClusterInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object clustersListByResourceGroupOptions = null;
        String filter = null;
        String select = null;
        Integer maxResults = null;
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), filter, select, maxResults, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ClusterInner>>>>(){

            public Observable<ServiceResponse<Page<ClusterInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ClustersInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<ClusterInner> listByResourceGroup(String resourceGroupName, ClustersListByResourceGroupOptionsInner clustersListByResourceGroupOptions) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName, clustersListByResourceGroupOptions).toBlocking().single();
        return new PagedList<ClusterInner>((Page)response.body()){

            public Page<ClusterInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ClustersInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ClusterInner>> listByResourceGroupAsync(String resourceGroupName, ClustersListByResourceGroupOptionsInner clustersListByResourceGroupOptions, ListOperationCallback<ClusterInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName, clustersListByResourceGroupOptions), (Func1)new Func1<String, Observable<ServiceResponse<Page<ClusterInner>>>>(){

            public Observable<ServiceResponse<Page<ClusterInner>>> call(String nextPageLink) {
                return ClustersInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ClusterInner>> listByResourceGroupAsync(String resourceGroupName, ClustersListByResourceGroupOptionsInner clustersListByResourceGroupOptions) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName, clustersListByResourceGroupOptions).map((Func1)new Func1<ServiceResponse<Page<ClusterInner>>, Page<ClusterInner>>(){

            public Page<ClusterInner> call(ServiceResponse<Page<ClusterInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ClusterInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName, ClustersListByResourceGroupOptionsInner clustersListByResourceGroupOptions) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName, clustersListByResourceGroupOptions).concatMap((Func1)new Func1<ServiceResponse<Page<ClusterInner>>, Observable<ServiceResponse<Page<ClusterInner>>>>(){

            public Observable<ServiceResponse<Page<ClusterInner>>> call(ServiceResponse<Page<ClusterInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ClustersInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ClusterInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName, ClustersListByResourceGroupOptionsInner clustersListByResourceGroupOptions) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)clustersListByResourceGroupOptions);
        String filter = null;
        if (clustersListByResourceGroupOptions != null) {
            filter = clustersListByResourceGroupOptions.filter();
        }
        String select = null;
        if (clustersListByResourceGroupOptions != null) {
            select = clustersListByResourceGroupOptions.select();
        }
        Integer maxResults = null;
        if (clustersListByResourceGroupOptions != null) {
            maxResults = clustersListByResourceGroupOptions.maxResults();
        }
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), filter, select, maxResults, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ClusterInner>>>>(){

            public Observable<ServiceResponse<Page<ClusterInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ClustersInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ClusterInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ClusterInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<RemoteLoginInformationInner> listRemoteLoginInformationNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listRemoteLoginInformationNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<RemoteLoginInformationInner>((Page)response.body()){

            public Page<RemoteLoginInformationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ClustersInner.this.listRemoteLoginInformationNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RemoteLoginInformationInner>> listRemoteLoginInformationNextAsync(String nextPageLink, ServiceFuture<List<RemoteLoginInformationInner>> serviceFuture, ListOperationCallback<RemoteLoginInformationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listRemoteLoginInformationNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<RemoteLoginInformationInner>>>>(){

            public Observable<ServiceResponse<Page<RemoteLoginInformationInner>>> call(String nextPageLink) {
                return ClustersInner.this.listRemoteLoginInformationNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RemoteLoginInformationInner>> listRemoteLoginInformationNextAsync(String nextPageLink) {
        return this.listRemoteLoginInformationNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<RemoteLoginInformationInner>>, Page<RemoteLoginInformationInner>>(){

            public Page<RemoteLoginInformationInner> call(ServiceResponse<Page<RemoteLoginInformationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RemoteLoginInformationInner>>> listRemoteLoginInformationNextWithServiceResponseAsync(String nextPageLink) {
        return this.listRemoteLoginInformationNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<RemoteLoginInformationInner>>, Observable<ServiceResponse<Page<RemoteLoginInformationInner>>>>(){

            public Observable<ServiceResponse<Page<RemoteLoginInformationInner>>> call(ServiceResponse<Page<RemoteLoginInformationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ClustersInner.this.listRemoteLoginInformationNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RemoteLoginInformationInner>>> listRemoteLoginInformationNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listRemoteLoginInformationNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RemoteLoginInformationInner>>>>(){

            public Observable<ServiceResponse<Page<RemoteLoginInformationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ClustersInner.this.listRemoteLoginInformationNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RemoteLoginInformationInner>> listRemoteLoginInformationNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RemoteLoginInformationInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ClusterInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ClusterInner>((Page)response.body()){

            public Page<ClusterInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ClustersInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ClusterInner>> listNextAsync(String nextPageLink, ServiceFuture<List<ClusterInner>> serviceFuture, ListOperationCallback<ClusterInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ClusterInner>>>>(){

            public Observable<ServiceResponse<Page<ClusterInner>>> call(String nextPageLink) {
                return ClustersInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ClusterInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ClusterInner>>, Page<ClusterInner>>(){

            public Page<ClusterInner> call(ServiceResponse<Page<ClusterInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ClusterInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ClusterInner>>, Observable<ServiceResponse<Page<ClusterInner>>>>(){

            public Observable<ServiceResponse<Page<ClusterInner>>> call(ServiceResponse<Page<ClusterInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ClustersInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ClusterInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ClusterInner>>>>(){

            public Observable<ServiceResponse<Page<ClusterInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ClustersInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ClusterInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ClusterInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ClusterInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ClusterInner>((Page)response.body()){

            public Page<ClusterInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ClustersInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ClusterInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<ClusterInner>> serviceFuture, ListOperationCallback<ClusterInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ClusterInner>>>>(){

            public Observable<ServiceResponse<Page<ClusterInner>>> call(String nextPageLink) {
                return ClustersInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ClusterInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ClusterInner>>, Page<ClusterInner>>(){

            public Page<ClusterInner> call(ServiceResponse<Page<ClusterInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ClusterInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ClusterInner>>, Observable<ServiceResponse<Page<ClusterInner>>>>(){

            public Observable<ServiceResponse<Page<ClusterInner>>> call(ServiceResponse<Page<ClusterInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ClustersInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ClusterInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ClusterInner>>>>(){

            public Observable<ServiceResponse<Page<ClusterInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ClustersInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ClusterInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ClusterInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ClustersService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Clusters create"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/clusters/{clusterName}")
        public Observable<Response<ResponseBody>> create(@Path(value="resourceGroupName") String var1, @Path(value="clusterName") String var2, @Path(value="subscriptionId") String var3, @Body ClusterCreateParametersInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Clusters beginCreate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/clusters/{clusterName}")
        public Observable<Response<ResponseBody>> beginCreate(@Path(value="resourceGroupName") String var1, @Path(value="clusterName") String var2, @Path(value="subscriptionId") String var3, @Body ClusterCreateParametersInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Clusters update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/clusters/{clusterName}")
        public Observable<Response<ResponseBody>> update(@Path(value="resourceGroupName") String var1, @Path(value="clusterName") String var2, @Path(value="subscriptionId") String var3, @Body ClusterUpdateParametersInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Clusters delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/clusters/{clusterName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="clusterName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Clusters beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/clusters/{clusterName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="clusterName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Clusters getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/clusters/{clusterName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="clusterName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Clusters listRemoteLoginInformation"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/clusters/{clusterName}/listRemoteLoginInformation")
        public Observable<Response<ResponseBody>> listRemoteLoginInformation(@Path(value="resourceGroupName") String var1, @Path(value="clusterName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Clusters list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.BatchAI/clusters")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Query(value="$filter") String var4, @Query(value="$select") String var5, @Query(value="maxresults") Integer var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Clusters listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/clusters")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Query(value="$filter") String var5, @Query(value="$select") String var6, @Query(value="maxresults") Integer var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Clusters listRemoteLoginInformationNext"})
        @GET
        public Observable<Response<ResponseBody>> listRemoteLoginInformationNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Clusters listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Clusters listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

