/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.batchai.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.batchai.implementation.BatchAIManagementClientImpl;
import com.microsoft.azure.management.batchai.implementation.FileInner;
import com.microsoft.azure.management.batchai.implementation.JobCreateParametersInner;
import com.microsoft.azure.management.batchai.implementation.JobInner;
import com.microsoft.azure.management.batchai.implementation.JobsListByResourceGroupOptionsInner;
import com.microsoft.azure.management.batchai.implementation.JobsListOptionsInner;
import com.microsoft.azure.management.batchai.implementation.JobsListOutputFilesOptionsInner;
import com.microsoft.azure.management.batchai.implementation.PageImpl;
import com.microsoft.azure.management.batchai.implementation.RemoteLoginInformationInner;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsDelete;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsGet;
import com.microsoft.azure.management.resources.fluentcore.collection.InnerSupportsListing;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class JobsInner
implements InnerSupportsGet<JobInner>,
InnerSupportsDelete<Void>,
InnerSupportsListing<JobInner> {
    private JobsService service;
    private BatchAIManagementClientImpl client;

    public JobsInner(Retrofit retrofit, BatchAIManagementClientImpl client) {
        this.service = (JobsService)retrofit.create(JobsService.class);
        this.client = client;
    }

    public JobInner create(String resourceGroupName, String jobName, JobCreateParametersInner parameters) {
        return (JobInner)((Object)((ServiceResponse)this.createWithServiceResponseAsync(resourceGroupName, jobName, parameters).toBlocking().last()).body());
    }

    public ServiceFuture<JobInner> createAsync(String resourceGroupName, String jobName, JobCreateParametersInner parameters, ServiceCallback<JobInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createWithServiceResponseAsync(resourceGroupName, jobName, parameters), serviceCallback);
    }

    public Observable<JobInner> createAsync(String resourceGroupName, String jobName, JobCreateParametersInner parameters) {
        return this.createWithServiceResponseAsync(resourceGroupName, jobName, parameters).map((Func1)new Func1<ServiceResponse<JobInner>, JobInner>(){

            public JobInner call(ServiceResponse<JobInner> response) {
                return (JobInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<JobInner>> createWithServiceResponseAsync(String resourceGroupName, String jobName, JobCreateParametersInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        Observable<Response<ResponseBody>> observable = this.service.create(resourceGroupName, jobName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPutOrPatchResultAsync(observable, new TypeToken<JobInner>(){}.getType());
    }

    public JobInner beginCreate(String resourceGroupName, String jobName, JobCreateParametersInner parameters) {
        return (JobInner)((Object)((ServiceResponse)this.beginCreateWithServiceResponseAsync(resourceGroupName, jobName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<JobInner> beginCreateAsync(String resourceGroupName, String jobName, JobCreateParametersInner parameters, ServiceCallback<JobInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginCreateWithServiceResponseAsync(resourceGroupName, jobName, parameters), serviceCallback);
    }

    public Observable<JobInner> beginCreateAsync(String resourceGroupName, String jobName, JobCreateParametersInner parameters) {
        return this.beginCreateWithServiceResponseAsync(resourceGroupName, jobName, parameters).map((Func1)new Func1<ServiceResponse<JobInner>, JobInner>(){

            public JobInner call(ServiceResponse<JobInner> response) {
                return (JobInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<JobInner>> beginCreateWithServiceResponseAsync(String resourceGroupName, String jobName, JobCreateParametersInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.beginCreate(resourceGroupName, jobName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<JobInner>>>(){

            public Observable<ServiceResponse<JobInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = JobsInner.this.beginCreateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<JobInner> beginCreateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<JobInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String jobName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, jobName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String jobName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, jobName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String jobName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, jobName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String jobName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, jobName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName, String jobName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName, jobName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, String jobName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName, jobName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName, String jobName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName, jobName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName, String jobName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginDelete(resourceGroupName, jobName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = JobsInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public JobInner getByResourceGroup(String resourceGroupName, String jobName) {
        return (JobInner)((Object)((ServiceResponse)this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, jobName).toBlocking().single()).body());
    }

    public ServiceFuture<JobInner> getByResourceGroupAsync(String resourceGroupName, String jobName, ServiceCallback<JobInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, jobName), serviceCallback);
    }

    public Observable<JobInner> getByResourceGroupAsync(String resourceGroupName, String jobName) {
        return this.getByResourceGroupWithServiceResponseAsync(resourceGroupName, jobName).map((Func1)new Func1<ServiceResponse<JobInner>, JobInner>(){

            public JobInner call(ServiceResponse<JobInner> response) {
                return (JobInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<JobInner>> getByResourceGroupWithServiceResponseAsync(String resourceGroupName, String jobName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.getByResourceGroup(resourceGroupName, jobName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<JobInner>>>(){

            public Observable<ServiceResponse<JobInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = JobsInner.this.getByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<JobInner> getByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<JobInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<RemoteLoginInformationInner> listRemoteLoginInformation(String resourceGroupName, String jobName) {
        ServiceResponse response = (ServiceResponse)this.listRemoteLoginInformationSinglePageAsync(resourceGroupName, jobName).toBlocking().single();
        return new PagedList<RemoteLoginInformationInner>((Page)response.body()){

            public Page<RemoteLoginInformationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)JobsInner.this.listRemoteLoginInformationNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RemoteLoginInformationInner>> listRemoteLoginInformationAsync(String resourceGroupName, String jobName, ListOperationCallback<RemoteLoginInformationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listRemoteLoginInformationSinglePageAsync(resourceGroupName, jobName), (Func1)new Func1<String, Observable<ServiceResponse<Page<RemoteLoginInformationInner>>>>(){

            public Observable<ServiceResponse<Page<RemoteLoginInformationInner>>> call(String nextPageLink) {
                return JobsInner.this.listRemoteLoginInformationNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RemoteLoginInformationInner>> listRemoteLoginInformationAsync(String resourceGroupName, String jobName) {
        return this.listRemoteLoginInformationWithServiceResponseAsync(resourceGroupName, jobName).map((Func1)new Func1<ServiceResponse<Page<RemoteLoginInformationInner>>, Page<RemoteLoginInformationInner>>(){

            public Page<RemoteLoginInformationInner> call(ServiceResponse<Page<RemoteLoginInformationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RemoteLoginInformationInner>>> listRemoteLoginInformationWithServiceResponseAsync(String resourceGroupName, String jobName) {
        return this.listRemoteLoginInformationSinglePageAsync(resourceGroupName, jobName).concatMap((Func1)new Func1<ServiceResponse<Page<RemoteLoginInformationInner>>, Observable<ServiceResponse<Page<RemoteLoginInformationInner>>>>(){

            public Observable<ServiceResponse<Page<RemoteLoginInformationInner>>> call(ServiceResponse<Page<RemoteLoginInformationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(JobsInner.this.listRemoteLoginInformationNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RemoteLoginInformationInner>>> listRemoteLoginInformationSinglePageAsync(String resourceGroupName, String jobName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.listRemoteLoginInformation(resourceGroupName, jobName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RemoteLoginInformationInner>>>>(){

            public Observable<ServiceResponse<Page<RemoteLoginInformationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = JobsInner.this.listRemoteLoginInformationDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RemoteLoginInformationInner>> listRemoteLoginInformationDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RemoteLoginInformationInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void terminate(String resourceGroupName, String jobName) {
        ((ServiceResponse)this.terminateWithServiceResponseAsync(resourceGroupName, jobName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> terminateAsync(String resourceGroupName, String jobName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.terminateWithServiceResponseAsync(resourceGroupName, jobName), serviceCallback);
    }

    public Observable<Void> terminateAsync(String resourceGroupName, String jobName) {
        return this.terminateWithServiceResponseAsync(resourceGroupName, jobName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> terminateWithServiceResponseAsync(String resourceGroupName, String jobName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.terminate(resourceGroupName, jobName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginTerminate(String resourceGroupName, String jobName) {
        ((ServiceResponse)this.beginTerminateWithServiceResponseAsync(resourceGroupName, jobName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginTerminateAsync(String resourceGroupName, String jobName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginTerminateWithServiceResponseAsync(resourceGroupName, jobName), serviceCallback);
    }

    public Observable<Void> beginTerminateAsync(String resourceGroupName, String jobName) {
        return this.beginTerminateWithServiceResponseAsync(resourceGroupName, jobName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginTerminateWithServiceResponseAsync(String resourceGroupName, String jobName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginTerminate(resourceGroupName, jobName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = JobsInner.this.beginTerminateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginTerminateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<JobInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<JobInner>((Page)response.body()){

            public Page<JobInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)JobsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<JobInner>> listAsync(ListOperationCallback<JobInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<JobInner>>>>(){

            public Observable<ServiceResponse<Page<JobInner>>> call(String nextPageLink) {
                return JobsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<JobInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<JobInner>>, Page<JobInner>>(){

            public Page<JobInner> call(ServiceResponse<Page<JobInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<JobInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<JobInner>>, Observable<ServiceResponse<Page<JobInner>>>>(){

            public Observable<ServiceResponse<Page<JobInner>>> call(ServiceResponse<Page<JobInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(JobsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<JobInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object jobsListOptions = null;
        String filter = null;
        String select = null;
        Integer maxResults = null;
        return this.service.list(this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), filter, select, maxResults, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobInner>>>>(){

            public Observable<ServiceResponse<Page<JobInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = JobsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<JobInner> list(JobsListOptionsInner jobsListOptions) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(jobsListOptions).toBlocking().single();
        return new PagedList<JobInner>((Page)response.body()){

            public Page<JobInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)JobsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<JobInner>> listAsync(JobsListOptionsInner jobsListOptions, ListOperationCallback<JobInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(jobsListOptions), (Func1)new Func1<String, Observable<ServiceResponse<Page<JobInner>>>>(){

            public Observable<ServiceResponse<Page<JobInner>>> call(String nextPageLink) {
                return JobsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<JobInner>> listAsync(JobsListOptionsInner jobsListOptions) {
        return this.listWithServiceResponseAsync(jobsListOptions).map((Func1)new Func1<ServiceResponse<Page<JobInner>>, Page<JobInner>>(){

            public Page<JobInner> call(ServiceResponse<Page<JobInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<JobInner>>> listWithServiceResponseAsync(JobsListOptionsInner jobsListOptions) {
        return this.listSinglePageAsync(jobsListOptions).concatMap((Func1)new Func1<ServiceResponse<Page<JobInner>>, Observable<ServiceResponse<Page<JobInner>>>>(){

            public Observable<ServiceResponse<Page<JobInner>>> call(ServiceResponse<Page<JobInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(JobsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<JobInner>>> listSinglePageAsync(JobsListOptionsInner jobsListOptions) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)jobsListOptions);
        String filter = null;
        if (jobsListOptions != null) {
            filter = jobsListOptions.filter();
        }
        String select = null;
        if (jobsListOptions != null) {
            select = jobsListOptions.select();
        }
        Integer maxResults = null;
        if (jobsListOptions != null) {
            maxResults = jobsListOptions.maxResults();
        }
        return this.service.list(this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), filter, select, maxResults, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobInner>>>>(){

            public Observable<ServiceResponse<Page<JobInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = JobsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<JobInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<JobInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<JobInner> listByResourceGroup(String resourceGroupName) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName).toBlocking().single();
        return new PagedList<JobInner>((Page)response.body()){

            public Page<JobInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)JobsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<JobInner>> listByResourceGroupAsync(String resourceGroupName, ListOperationCallback<JobInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName), (Func1)new Func1<String, Observable<ServiceResponse<Page<JobInner>>>>(){

            public Observable<ServiceResponse<Page<JobInner>>> call(String nextPageLink) {
                return JobsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<JobInner>> listByResourceGroupAsync(String resourceGroupName) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Page<JobInner>>, Page<JobInner>>(){

            public Page<JobInner> call(ServiceResponse<Page<JobInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<JobInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName).concatMap((Func1)new Func1<ServiceResponse<Page<JobInner>>, Observable<ServiceResponse<Page<JobInner>>>>(){

            public Observable<ServiceResponse<Page<JobInner>>> call(ServiceResponse<Page<JobInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(JobsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<JobInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Object jobsListByResourceGroupOptions = null;
        String filter = null;
        String select = null;
        Integer maxResults = null;
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), filter, select, maxResults, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobInner>>>>(){

            public Observable<ServiceResponse<Page<JobInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = JobsInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<JobInner> listByResourceGroup(String resourceGroupName, JobsListByResourceGroupOptionsInner jobsListByResourceGroupOptions) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupSinglePageAsync(resourceGroupName, jobsListByResourceGroupOptions).toBlocking().single();
        return new PagedList<JobInner>((Page)response.body()){

            public Page<JobInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)JobsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<JobInner>> listByResourceGroupAsync(String resourceGroupName, JobsListByResourceGroupOptionsInner jobsListByResourceGroupOptions, ListOperationCallback<JobInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupSinglePageAsync(resourceGroupName, jobsListByResourceGroupOptions), (Func1)new Func1<String, Observable<ServiceResponse<Page<JobInner>>>>(){

            public Observable<ServiceResponse<Page<JobInner>>> call(String nextPageLink) {
                return JobsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<JobInner>> listByResourceGroupAsync(String resourceGroupName, JobsListByResourceGroupOptionsInner jobsListByResourceGroupOptions) {
        return this.listByResourceGroupWithServiceResponseAsync(resourceGroupName, jobsListByResourceGroupOptions).map((Func1)new Func1<ServiceResponse<Page<JobInner>>, Page<JobInner>>(){

            public Page<JobInner> call(ServiceResponse<Page<JobInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<JobInner>>> listByResourceGroupWithServiceResponseAsync(String resourceGroupName, JobsListByResourceGroupOptionsInner jobsListByResourceGroupOptions) {
        return this.listByResourceGroupSinglePageAsync(resourceGroupName, jobsListByResourceGroupOptions).concatMap((Func1)new Func1<ServiceResponse<Page<JobInner>>, Observable<ServiceResponse<Page<JobInner>>>>(){

            public Observable<ServiceResponse<Page<JobInner>>> call(ServiceResponse<Page<JobInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(JobsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<JobInner>>> listByResourceGroupSinglePageAsync(String resourceGroupName, JobsListByResourceGroupOptionsInner jobsListByResourceGroupOptions) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)jobsListByResourceGroupOptions);
        String filter = null;
        if (jobsListByResourceGroupOptions != null) {
            filter = jobsListByResourceGroupOptions.filter();
        }
        String select = null;
        if (jobsListByResourceGroupOptions != null) {
            select = jobsListByResourceGroupOptions.select();
        }
        Integer maxResults = null;
        if (jobsListByResourceGroupOptions != null) {
            maxResults = jobsListByResourceGroupOptions.maxResults();
        }
        return this.service.listByResourceGroup(resourceGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), filter, select, maxResults, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobInner>>>>(){

            public Observable<ServiceResponse<Page<JobInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = JobsInner.this.listByResourceGroupDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<JobInner>> listByResourceGroupDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<JobInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<FileInner> listOutputFiles(String resourceGroupName, String jobName, JobsListOutputFilesOptionsInner jobsListOutputFilesOptions) {
        ServiceResponse response = (ServiceResponse)this.listOutputFilesSinglePageAsync(resourceGroupName, jobName, jobsListOutputFilesOptions).toBlocking().single();
        return new PagedList<FileInner>((Page)response.body()){

            public Page<FileInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)JobsInner.this.listOutputFilesNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<FileInner>> listOutputFilesAsync(String resourceGroupName, String jobName, JobsListOutputFilesOptionsInner jobsListOutputFilesOptions, ListOperationCallback<FileInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listOutputFilesSinglePageAsync(resourceGroupName, jobName, jobsListOutputFilesOptions), (Func1)new Func1<String, Observable<ServiceResponse<Page<FileInner>>>>(){

            public Observable<ServiceResponse<Page<FileInner>>> call(String nextPageLink) {
                return JobsInner.this.listOutputFilesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<FileInner>> listOutputFilesAsync(String resourceGroupName, String jobName, JobsListOutputFilesOptionsInner jobsListOutputFilesOptions) {
        return this.listOutputFilesWithServiceResponseAsync(resourceGroupName, jobName, jobsListOutputFilesOptions).map((Func1)new Func1<ServiceResponse<Page<FileInner>>, Page<FileInner>>(){

            public Page<FileInner> call(ServiceResponse<Page<FileInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<FileInner>>> listOutputFilesWithServiceResponseAsync(String resourceGroupName, String jobName, JobsListOutputFilesOptionsInner jobsListOutputFilesOptions) {
        return this.listOutputFilesSinglePageAsync(resourceGroupName, jobName, jobsListOutputFilesOptions).concatMap((Func1)new Func1<ServiceResponse<Page<FileInner>>, Observable<ServiceResponse<Page<FileInner>>>>(){

            public Observable<ServiceResponse<Page<FileInner>>> call(ServiceResponse<Page<FileInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(JobsInner.this.listOutputFilesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<FileInner>>> listOutputFilesSinglePageAsync(String resourceGroupName, String jobName, JobsListOutputFilesOptionsInner jobsListOutputFilesOptions) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (jobsListOutputFilesOptions == null) {
            throw new IllegalArgumentException("Parameter jobsListOutputFilesOptions is required and cannot be null.");
        }
        Validator.validate((Object)jobsListOutputFilesOptions);
        String outputdirectoryid = jobsListOutputFilesOptions.outputdirectoryid();
        Integer linkexpiryinminutes = jobsListOutputFilesOptions.linkexpiryinminutes();
        Integer maxResults = jobsListOutputFilesOptions.maxResults();
        return this.service.listOutputFiles(resourceGroupName, jobName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), outputdirectoryid, linkexpiryinminutes, maxResults, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<FileInner>>>>(){

            public Observable<ServiceResponse<Page<FileInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = JobsInner.this.listOutputFilesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<FileInner>> listOutputFilesDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<FileInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<RemoteLoginInformationInner> listRemoteLoginInformationNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listRemoteLoginInformationNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<RemoteLoginInformationInner>((Page)response.body()){

            public Page<RemoteLoginInformationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)JobsInner.this.listRemoteLoginInformationNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<RemoteLoginInformationInner>> listRemoteLoginInformationNextAsync(String nextPageLink, ServiceFuture<List<RemoteLoginInformationInner>> serviceFuture, ListOperationCallback<RemoteLoginInformationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listRemoteLoginInformationNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<RemoteLoginInformationInner>>>>(){

            public Observable<ServiceResponse<Page<RemoteLoginInformationInner>>> call(String nextPageLink) {
                return JobsInner.this.listRemoteLoginInformationNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<RemoteLoginInformationInner>> listRemoteLoginInformationNextAsync(String nextPageLink) {
        return this.listRemoteLoginInformationNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<RemoteLoginInformationInner>>, Page<RemoteLoginInformationInner>>(){

            public Page<RemoteLoginInformationInner> call(ServiceResponse<Page<RemoteLoginInformationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<RemoteLoginInformationInner>>> listRemoteLoginInformationNextWithServiceResponseAsync(String nextPageLink) {
        return this.listRemoteLoginInformationNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<RemoteLoginInformationInner>>, Observable<ServiceResponse<Page<RemoteLoginInformationInner>>>>(){

            public Observable<ServiceResponse<Page<RemoteLoginInformationInner>>> call(ServiceResponse<Page<RemoteLoginInformationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(JobsInner.this.listRemoteLoginInformationNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<RemoteLoginInformationInner>>> listRemoteLoginInformationNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listRemoteLoginInformationNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<RemoteLoginInformationInner>>>>(){

            public Observable<ServiceResponse<Page<RemoteLoginInformationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = JobsInner.this.listRemoteLoginInformationNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<RemoteLoginInformationInner>> listRemoteLoginInformationNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<RemoteLoginInformationInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<JobInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<JobInner>((Page)response.body()){

            public Page<JobInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)JobsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<JobInner>> listNextAsync(String nextPageLink, ServiceFuture<List<JobInner>> serviceFuture, ListOperationCallback<JobInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<JobInner>>>>(){

            public Observable<ServiceResponse<Page<JobInner>>> call(String nextPageLink) {
                return JobsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<JobInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<JobInner>>, Page<JobInner>>(){

            public Page<JobInner> call(ServiceResponse<Page<JobInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<JobInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<JobInner>>, Observable<ServiceResponse<Page<JobInner>>>>(){

            public Observable<ServiceResponse<Page<JobInner>>> call(ServiceResponse<Page<JobInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(JobsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<JobInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobInner>>>>(){

            public Observable<ServiceResponse<Page<JobInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = JobsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<JobInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<JobInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<JobInner> listByResourceGroupNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<JobInner>((Page)response.body()){

            public Page<JobInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)JobsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<JobInner>> listByResourceGroupNextAsync(String nextPageLink, ServiceFuture<List<JobInner>> serviceFuture, ListOperationCallback<JobInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByResourceGroupNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<JobInner>>>>(){

            public Observable<ServiceResponse<Page<JobInner>>> call(String nextPageLink) {
                return JobsInner.this.listByResourceGroupNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<JobInner>> listByResourceGroupNextAsync(String nextPageLink) {
        return this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<JobInner>>, Page<JobInner>>(){

            public Page<JobInner> call(ServiceResponse<Page<JobInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<JobInner>>> listByResourceGroupNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByResourceGroupNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<JobInner>>, Observable<ServiceResponse<Page<JobInner>>>>(){

            public Observable<ServiceResponse<Page<JobInner>>> call(ServiceResponse<Page<JobInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(JobsInner.this.listByResourceGroupNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<JobInner>>> listByResourceGroupNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByResourceGroupNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobInner>>>>(){

            public Observable<ServiceResponse<Page<JobInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = JobsInner.this.listByResourceGroupNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<JobInner>> listByResourceGroupNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<JobInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<FileInner> listOutputFilesNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listOutputFilesNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<FileInner>((Page)response.body()){

            public Page<FileInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)JobsInner.this.listOutputFilesNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<FileInner>> listOutputFilesNextAsync(String nextPageLink, ServiceFuture<List<FileInner>> serviceFuture, ListOperationCallback<FileInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listOutputFilesNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<FileInner>>>>(){

            public Observable<ServiceResponse<Page<FileInner>>> call(String nextPageLink) {
                return JobsInner.this.listOutputFilesNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<FileInner>> listOutputFilesNextAsync(String nextPageLink) {
        return this.listOutputFilesNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<FileInner>>, Page<FileInner>>(){

            public Page<FileInner> call(ServiceResponse<Page<FileInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<FileInner>>> listOutputFilesNextWithServiceResponseAsync(String nextPageLink) {
        return this.listOutputFilesNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<FileInner>>, Observable<ServiceResponse<Page<FileInner>>>>(){

            public Observable<ServiceResponse<Page<FileInner>>> call(ServiceResponse<Page<FileInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(JobsInner.this.listOutputFilesNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<FileInner>>> listOutputFilesNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listOutputFilesNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<FileInner>>>>(){

            public Observable<ServiceResponse<Page<FileInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = JobsInner.this.listOutputFilesNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<FileInner>> listOutputFilesNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<FileInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface JobsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Jobs create"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/jobs/{jobName}")
        public Observable<Response<ResponseBody>> create(@Path(value="resourceGroupName") String var1, @Path(value="jobName") String var2, @Path(value="subscriptionId") String var3, @Body JobCreateParametersInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Jobs beginCreate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/jobs/{jobName}")
        public Observable<Response<ResponseBody>> beginCreate(@Path(value="resourceGroupName") String var1, @Path(value="jobName") String var2, @Path(value="subscriptionId") String var3, @Body JobCreateParametersInner var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Jobs delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/jobs/{jobName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="jobName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Jobs beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/jobs/{jobName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="jobName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Jobs getByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/jobs/{jobName}")
        public Observable<Response<ResponseBody>> getByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="jobName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Jobs listRemoteLoginInformation"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/jobs/{jobName}/listRemoteLoginInformation")
        public Observable<Response<ResponseBody>> listRemoteLoginInformation(@Path(value="resourceGroupName") String var1, @Path(value="jobName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Jobs terminate"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/jobs/{jobName}/terminate")
        public Observable<Response<ResponseBody>> terminate(@Path(value="resourceGroupName") String var1, @Path(value="jobName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Jobs beginTerminate"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/jobs/{jobName}/terminate")
        public Observable<Response<ResponseBody>> beginTerminate(@Path(value="resourceGroupName") String var1, @Path(value="jobName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Jobs list"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.BatchAI/jobs")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Query(value="$filter") String var4, @Query(value="$select") String var5, @Query(value="maxresults") Integer var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Jobs listByResourceGroup"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/jobs")
        public Observable<Response<ResponseBody>> listByResourceGroup(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Query(value="$filter") String var5, @Query(value="$select") String var6, @Query(value="maxresults") Integer var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Jobs listOutputFiles"})
        @POST(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/jobs/{jobName}/listOutputFiles")
        public Observable<Response<ResponseBody>> listOutputFiles(@Path(value="resourceGroupName") String var1, @Path(value="jobName") String var2, @Path(value="subscriptionId") String var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Query(value="outputdirectoryid") String var6, @Query(value="linkexpiryinminutes") Integer var7, @Query(value="maxresults") Integer var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Jobs listRemoteLoginInformationNext"})
        @GET
        public Observable<Response<ResponseBody>> listRemoteLoginInformationNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Jobs listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Jobs listByResourceGroupNext"})
        @GET
        public Observable<Response<ResponseBody>> listByResourceGroupNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batchai.Jobs listOutputFilesNext"})
        @GET
        public Observable<Response<ResponseBody>> listOutputFilesNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

