/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batchai;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The system automatically scales the cluster up and down (within
 * minimumNodeCount and maximumNodeCount) based on the pending and running jobs
 * on the cluster.
 */
public class AutoScaleSettings {
    /**
     * Specifies the minimum number of compute nodes the cluster can have.
     */
    @JsonProperty(value = "minimumNodeCount", required = true)
    private int minimumNodeCount;

    /**
     * Specifies the maximum number of compute nodes the cluster can have.
     */
    @JsonProperty(value = "maximumNodeCount", required = true)
    private int maximumNodeCount;

    /**
     * Specifies the number of compute nodes to allocate on cluster creation.
     * Note that this value is used only during cluster creation.
     */
    @JsonProperty(value = "initialNodeCount")
    private Integer initialNodeCount;

    /**
     * Get the minimumNodeCount value.
     *
     * @return the minimumNodeCount value
     */
    public int minimumNodeCount() {
        return this.minimumNodeCount;
    }

    /**
     * Set the minimumNodeCount value.
     *
     * @param minimumNodeCount the minimumNodeCount value to set
     * @return the AutoScaleSettings object itself.
     */
    public AutoScaleSettings withMinimumNodeCount(int minimumNodeCount) {
        this.minimumNodeCount = minimumNodeCount;
        return this;
    }

    /**
     * Get the maximumNodeCount value.
     *
     * @return the maximumNodeCount value
     */
    public int maximumNodeCount() {
        return this.maximumNodeCount;
    }

    /**
     * Set the maximumNodeCount value.
     *
     * @param maximumNodeCount the maximumNodeCount value to set
     * @return the AutoScaleSettings object itself.
     */
    public AutoScaleSettings withMaximumNodeCount(int maximumNodeCount) {
        this.maximumNodeCount = maximumNodeCount;
        return this;
    }

    /**
     * Get the initialNodeCount value.
     *
     * @return the initialNodeCount value
     */
    public Integer initialNodeCount() {
        return this.initialNodeCount;
    }

    /**
     * Set the initialNodeCount value.
     *
     * @param initialNodeCount the initialNodeCount value to set
     * @return the AutoScaleSettings object itself.
     */
    public AutoScaleSettings withInitialNodeCount(Integer initialNodeCount) {
        this.initialNodeCount = initialNodeCount;
        return this;
    }

}
