/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batchai;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Input directory for the job.
 */
public class InputDirectory {
    /**
     * The id for the input directory.
     * It will be available for the job as an environment variable under
     * AZ_BATCHAI_INPUT_id. The service will also provide the following
     * environment variable: AZ_BATCHAI_PREV_OUTPUT_Name. The value of the
     * variable will be populated if the job is being retried after a previous
     * failure, otherwise it will be set to nothing.
     */
    @JsonProperty(value = "id", required = true)
    private String id;

    /**
     * The path to the input directory.
     */
    @JsonProperty(value = "path", required = true)
    private String path;

    /**
     * Get the id value.
     *
     * @return the id value
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id value.
     *
     * @param id the id value to set
     * @return the InputDirectory object itself.
     */
    public InputDirectory withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the path value.
     *
     * @return the path value
     */
    public String path() {
        return this.path;
    }

    /**
     * Set the path value.
     *
     * @param path the path value to set
     * @return the InputDirectory object itself.
     */
    public InputDirectory withPath(String path) {
        this.path = path;
        return this;
    }

}
