/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batchai;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Credentials to access a container image in a private repository.
 */
public class PrivateRegistryCredentials {
    /**
     * User name to login.
     */
    @JsonProperty(value = "username", required = true)
    private String username;

    /**
     * Password to login.
     * One of password or passwordSecretReference must be specified.
     */
    @JsonProperty(value = "password")
    private String password;

    /**
     * Specifies the location of the password, which is a Key Vault Secret.
     * Users can store their secrets in Azure KeyVault and pass it to the Batch
     * AI Service to integrate with KeyVault. One of password or
     * passwordSecretReference must be specified.
     */
    @JsonProperty(value = "passwordSecretReference")
    private KeyVaultSecretReference passwordSecretReference;

    /**
     * Get the username value.
     *
     * @return the username value
     */
    public String username() {
        return this.username;
    }

    /**
     * Set the username value.
     *
     * @param username the username value to set
     * @return the PrivateRegistryCredentials object itself.
     */
    public PrivateRegistryCredentials withUsername(String username) {
        this.username = username;
        return this;
    }

    /**
     * Get the password value.
     *
     * @return the password value
     */
    public String password() {
        return this.password;
    }

    /**
     * Set the password value.
     *
     * @param password the password value to set
     * @return the PrivateRegistryCredentials object itself.
     */
    public PrivateRegistryCredentials withPassword(String password) {
        this.password = password;
        return this;
    }

    /**
     * Get the passwordSecretReference value.
     *
     * @return the passwordSecretReference value
     */
    public KeyVaultSecretReference passwordSecretReference() {
        return this.passwordSecretReference;
    }

    /**
     * Set the passwordSecretReference value.
     *
     * @param passwordSecretReference the passwordSecretReference value to set
     * @return the PrivateRegistryCredentials object itself.
     */
    public PrivateRegistryCredentials withPasswordSecretReference(KeyVaultSecretReference passwordSecretReference) {
        this.passwordSecretReference = passwordSecretReference;
        return this;
    }

}
