/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batchai.implementation;

import org.joda.time.DateTime;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;

/**
 * Properties of the file.
 */
@JsonFlatten
public class FileInner {
    /**
     * file name.
     */
    @JsonProperty(value = "name", required = true)
    private String name;

    /**
     * file downloand url, example:
     * https://mystg.blob.core.windows.net/mycontainer/myModel_1.dnn.
     * This will be returned only if the model has been archived. During job
     * run, this won't be returned and customers can use SSH tunneling to
     * download. Users can use Get Remote Login Information API to get the IP
     * address and port information of all the compute nodes running the job.
     */
    @JsonProperty(value = "downloadUrl", required = true)
    private String downloadUrl;

    /**
     * The time at which the file was last modified.
     * The time at which the file was last modified.
     */
    @JsonProperty(value = "properties.lastModified")
    private DateTime lastModified;

    /**
     * The file size.
     * The file size.
     */
    @JsonProperty(value = "properties.contentLength")
    private Long contentLength;

    /**
     * Get the name value.
     *
     * @return the name value
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name value.
     *
     * @param name the name value to set
     * @return the FileInner object itself.
     */
    public FileInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the downloadUrl value.
     *
     * @return the downloadUrl value
     */
    public String downloadUrl() {
        return this.downloadUrl;
    }

    /**
     * Set the downloadUrl value.
     *
     * @param downloadUrl the downloadUrl value to set
     * @return the FileInner object itself.
     */
    public FileInner withDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
        return this;
    }

    /**
     * Get the lastModified value.
     *
     * @return the lastModified value
     */
    public DateTime lastModified() {
        return this.lastModified;
    }

    /**
     * Set the lastModified value.
     *
     * @param lastModified the lastModified value to set
     * @return the FileInner object itself.
     */
    public FileInner withLastModified(DateTime lastModified) {
        this.lastModified = lastModified;
        return this;
    }

    /**
     * Get the contentLength value.
     *
     * @return the contentLength value
     */
    public Long contentLength() {
        return this.contentLength;
    }

    /**
     * Set the contentLength value.
     *
     * @param contentLength the contentLength value to set
     * @return the FileInner object itself.
     */
    public FileInner withContentLength(Long contentLength) {
        this.contentLength = contentLength;
        return this;
    }

}
