/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batchai;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The image reference.
 */
public class ImageReference {
    /**
     * Publisher of the image.
     */
    @JsonProperty(value = "publisher", required = true)
    private String publisher;

    /**
     * Offer of the image.
     */
    @JsonProperty(value = "offer", required = true)
    private String offer;

    /**
     * SKU of the image.
     */
    @JsonProperty(value = "sku", required = true)
    private String sku;

    /**
     * Version of the image.
     */
    @JsonProperty(value = "version")
    private String version;

    /**
     * The ARM resource identifier of the virtual machine image. Computes nodes
     * of the cluster will be created using this custom image. This is of the
     * form
     * /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/images/{imageName}.
     * The virtual machine image must be in the same region and subscription as
     * the cluster. For information about the firewall settings for the Batch
     * node agent to communicate with the Batch service see
     * https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration.
     * Note, you need to provide publisher, offer and sku of the base OS image
     * of which the custom image has been derived from.
     */
    @JsonProperty(value = "virtualMachineImageId")
    private String virtualMachineImageId;

    /**
     * Get the publisher value.
     *
     * @return the publisher value
     */
    public String publisher() {
        return this.publisher;
    }

    /**
     * Set the publisher value.
     *
     * @param publisher the publisher value to set
     * @return the ImageReference object itself.
     */
    public ImageReference withPublisher(String publisher) {
        this.publisher = publisher;
        return this;
    }

    /**
     * Get the offer value.
     *
     * @return the offer value
     */
    public String offer() {
        return this.offer;
    }

    /**
     * Set the offer value.
     *
     * @param offer the offer value to set
     * @return the ImageReference object itself.
     */
    public ImageReference withOffer(String offer) {
        this.offer = offer;
        return this;
    }

    /**
     * Get the sku value.
     *
     * @return the sku value
     */
    public String sku() {
        return this.sku;
    }

    /**
     * Set the sku value.
     *
     * @param sku the sku value to set
     * @return the ImageReference object itself.
     */
    public ImageReference withSku(String sku) {
        this.sku = sku;
        return this;
    }

    /**
     * Get the version value.
     *
     * @return the version value
     */
    public String version() {
        return this.version;
    }

    /**
     * Set the version value.
     *
     * @param version the version value to set
     * @return the ImageReference object itself.
     */
    public ImageReference withVersion(String version) {
        this.version = version;
        return this;
    }

    /**
     * Get the virtualMachineImageId value.
     *
     * @return the virtualMachineImageId value
     */
    public String virtualMachineImageId() {
        return this.virtualMachineImageId;
    }

    /**
     * Set the virtualMachineImageId value.
     *
     * @param virtualMachineImageId the virtualMachineImageId value to set
     * @return the ImageReference object itself.
     */
    public ImageReference withVirtualMachineImageId(String virtualMachineImageId) {
        this.virtualMachineImageId = virtualMachineImageId;
        return this;
    }

}
