/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.batchai.implementation;

import com.microsoft.azure.Resource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.batchai.AllocationState;
import com.microsoft.azure.management.batchai.AppInsightsReference;
import com.microsoft.azure.management.batchai.AutoScaleSettings;
import com.microsoft.azure.management.batchai.AzureBlobFileSystem;
import com.microsoft.azure.management.batchai.AzureBlobFileSystemReference;
import com.microsoft.azure.management.batchai.AzureFileShare;
import com.microsoft.azure.management.batchai.AzureFileShareReference;
import com.microsoft.azure.management.batchai.BatchAICluster;
import com.microsoft.azure.management.batchai.BatchAIError;
import com.microsoft.azure.management.batchai.BatchAIJobs;
import com.microsoft.azure.management.batchai.DeallocationOption;
import com.microsoft.azure.management.batchai.FileServer;
import com.microsoft.azure.management.batchai.FileServerReference;
import com.microsoft.azure.management.batchai.ImageReference;
import com.microsoft.azure.management.batchai.KeyVaultSecretReference;
import com.microsoft.azure.management.batchai.ManualScaleSettings;
import com.microsoft.azure.management.batchai.MountVolumes;
import com.microsoft.azure.management.batchai.NodeSetup;
import com.microsoft.azure.management.batchai.NodeSetupTask;
import com.microsoft.azure.management.batchai.NodeStateCounts;
import com.microsoft.azure.management.batchai.PerformanceCountersSettings;
import com.microsoft.azure.management.batchai.ProvisioningState;
import com.microsoft.azure.management.batchai.ResourceId;
import com.microsoft.azure.management.batchai.ScaleSettings;
import com.microsoft.azure.management.batchai.SetupTask;
import com.microsoft.azure.management.batchai.UnmanagedFileSystemReference;
import com.microsoft.azure.management.batchai.UserAccountSettings;
import com.microsoft.azure.management.batchai.VirtualMachineConfiguration;
import com.microsoft.azure.management.batchai.VmPriority;
import com.microsoft.azure.management.batchai.implementation.AzureBlobFileSystemImpl;
import com.microsoft.azure.management.batchai.implementation.AzureFileShareImpl;
import com.microsoft.azure.management.batchai.implementation.BatchAIJobsImpl;
import com.microsoft.azure.management.batchai.implementation.BatchAIManagementClientImpl;
import com.microsoft.azure.management.batchai.implementation.BatchAIManager;
import com.microsoft.azure.management.batchai.implementation.ClusterCreateParametersInner;
import com.microsoft.azure.management.batchai.implementation.ClusterInner;
import com.microsoft.azure.management.batchai.implementation.ClusterUpdateParametersInner;
import com.microsoft.azure.management.batchai.implementation.FileServerImpl;
import com.microsoft.azure.management.batchai.implementation.NodeSetupTaskImpl;
import com.microsoft.azure.management.batchai.model.HasMountVolumes;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;
import rx.Observable;

@LangDefinition
class BatchAIClusterImpl
extends GroupableResourceImpl<BatchAICluster, ClusterInner, BatchAIClusterImpl, BatchAIManager>
implements BatchAICluster,
BatchAICluster.Definition,
BatchAICluster.Update,
HasMountVolumes {
    private ClusterCreateParametersInner createParameters = new ClusterCreateParametersInner();
    private ClusterUpdateParametersInner updateParameters = new ClusterUpdateParametersInner();
    private BatchAIJobsImpl jobs;

    BatchAIClusterImpl(String name, ClusterInner innerObject, BatchAIManager manager) {
        super(name, (Resource)innerObject, (ManagerBase)manager);
    }

    public Observable<BatchAICluster> createResourceAsync() {
        this.createParameters.withLocation(this.regionName());
        this.createParameters.withTags(((ClusterInner)((Object)this.inner())).getTags());
        return ((BatchAIManagementClientImpl)((Object)((BatchAIManager)this.manager()).inner())).clusters().createAsync(this.resourceGroupName(), this.name(), this.createParameters).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    public Observable<BatchAICluster> updateResourceAsync() {
        this.updateParameters.withTags(((ClusterInner)((Object)this.inner())).getTags());
        return ((BatchAIManagementClientImpl)((Object)((BatchAIManager)this.manager()).inner())).clusters().updateAsync(this.resourceGroupName(), this.name(), this.updateParameters).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    protected Observable<ClusterInner> getInnerAsync() {
        return ((BatchAIManagementClientImpl)((Object)((BatchAIManager)this.manager()).inner())).clusters().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public BatchAIClusterImpl withVMSize(String vmSize) {
        this.createParameters.withVmSize(vmSize);
        return this;
    }

    @Override
    public BatchAIClusterImpl withUserName(String userName) {
        this.ensureUserAccountSettings().withAdminUserName(userName);
        return this;
    }

    @Override
    public BatchAICluster.DefinitionStages.WithScaleSettings withPassword(String password) {
        this.ensureUserAccountSettings().withAdminUserPassword(password);
        return this;
    }

    @Override
    public BatchAICluster.DefinitionStages.WithScaleSettings withSshPublicKey(String sshPublicKey) {
        this.ensureUserAccountSettings().withAdminUserSshPublicKey(sshPublicKey);
        return this;
    }

    private UserAccountSettings ensureUserAccountSettings() {
        if (this.createParameters.userAccountSettings() == null) {
            this.createParameters.withUserAccountSettings(new UserAccountSettings());
        }
        return this.createParameters.userAccountSettings();
    }

    @Override
    public BatchAIClusterImpl withAutoScale(int minimumNodeCount, int maximumNodeCount) {
        AutoScaleSettings autoScaleSettings = new AutoScaleSettings().withMinimumNodeCount(minimumNodeCount).withMaximumNodeCount(maximumNodeCount);
        if (this.isInCreateMode()) {
            this.ensureScaleSettings().withAutoScale(autoScaleSettings);
        } else {
            this.updateParameters.withScaleSettings(new ScaleSettings().withAutoScale(autoScaleSettings));
        }
        return this;
    }

    @Override
    public BatchAIClusterImpl withAutoScale(int minimumNodeCount, int maximumNodeCount, int initialNodeCount) {
        AutoScaleSettings autoScaleSettings = new AutoScaleSettings().withMinimumNodeCount(minimumNodeCount).withMaximumNodeCount(maximumNodeCount).withInitialNodeCount(initialNodeCount);
        if (this.isInCreateMode()) {
            this.ensureScaleSettings().withAutoScale(autoScaleSettings);
        } else {
            this.updateParameters.withScaleSettings(new ScaleSettings().withAutoScale(autoScaleSettings));
        }
        return this;
    }

    @Override
    public BatchAIClusterImpl withManualScale(int targetNodeCount) {
        ManualScaleSettings manualScaleSettings = new ManualScaleSettings().withTargetNodeCount(targetNodeCount);
        if (this.isInCreateMode()) {
            this.ensureScaleSettings().withManual(manualScaleSettings);
        } else {
            this.updateParameters.withScaleSettings(new ScaleSettings().withManual(manualScaleSettings));
        }
        return this;
    }

    @Override
    public BatchAIClusterImpl withManualScale(int targetNodeCount, DeallocationOption deallocationOption) {
        ManualScaleSettings manualScaleSettings = new ManualScaleSettings().withTargetNodeCount(targetNodeCount).withNodeDeallocationOption(deallocationOption);
        if (this.isInCreateMode()) {
            this.ensureScaleSettings().withManual(manualScaleSettings);
        } else {
            this.updateParameters.withScaleSettings(new ScaleSettings().withManual(manualScaleSettings));
        }
        return this;
    }

    private ScaleSettings ensureScaleSettings() {
        if (this.createParameters.scaleSettings() == null) {
            this.createParameters.withScaleSettings(new ScaleSettings());
        }
        return this.createParameters.scaleSettings();
    }

    @Override
    public BatchAICluster.DefinitionStages.WithCreate withLowPriority() {
        this.createParameters.withVmPriority(VmPriority.LOWPRIORITY);
        return this;
    }

    @Override
    public NodeSetupTask.DefinitionStages.Blank<BatchAICluster.DefinitionStages.WithCreate> defineSetupTask() {
        return new NodeSetupTaskImpl(new SetupTask(), this);
    }

    BatchAIClusterImpl withSetupTask(NodeSetupTaskImpl setupTask) {
        this.ensureNodeSetup().withSetupTask((SetupTask)setupTask.inner());
        return this;
    }

    private NodeSetup ensureNodeSetup() {
        if (this.createParameters.nodeSetup() == null) {
            this.createParameters.withNodeSetup(new NodeSetup());
        }
        return this.createParameters.nodeSetup();
    }

    @Override
    public String vmSize() {
        return ((ClusterInner)((Object)this.inner())).vmSize();
    }

    @Override
    public VmPriority vmPriority() {
        return ((ClusterInner)((Object)this.inner())).vmPriority();
    }

    @Override
    public ScaleSettings scaleSettings() {
        return ((ClusterInner)((Object)this.inner())).scaleSettings();
    }

    @Override
    public VirtualMachineConfiguration virtualMachineConfiguration() {
        return ((ClusterInner)((Object)this.inner())).virtualMachineConfiguration();
    }

    @Override
    public NodeSetup nodeSetup() {
        return ((ClusterInner)((Object)this.inner())).nodeSetup();
    }

    @Override
    public String adminUserName() {
        return ((ClusterInner)((Object)this.inner())).userAccountSettings().adminUserName();
    }

    @Override
    public ResourceId subnet() {
        return ((ClusterInner)((Object)this.inner())).subnet();
    }

    @Override
    public DateTime creationTime() {
        return ((ClusterInner)((Object)this.inner())).creationTime();
    }

    @Override
    public ProvisioningState provisioningState() {
        return ((ClusterInner)((Object)this.inner())).provisioningState();
    }

    @Override
    public DateTime provisioningStateTransitionTime() {
        return ((ClusterInner)((Object)this.inner())).provisioningStateTransitionTime();
    }

    @Override
    public AllocationState allocationState() {
        return ((ClusterInner)((Object)this.inner())).allocationState();
    }

    @Override
    public DateTime allocationStateTransitionTime() {
        return ((ClusterInner)((Object)this.inner())).allocationStateTransitionTime();
    }

    @Override
    public List<BatchAIError> errors() {
        return ((ClusterInner)((Object)this.inner())).errors();
    }

    @Override
    public int currentNodeCount() {
        return Utils.toPrimitiveInt((Integer)((ClusterInner)((Object)this.inner())).currentNodeCount());
    }

    @Override
    public NodeStateCounts nodeStateCounts() {
        return ((ClusterInner)((Object)this.inner())).nodeStateCounts();
    }

    @Override
    public BatchAIJobs jobs() {
        if (this.jobs == null) {
            this.jobs = new BatchAIJobsImpl(this);
        }
        return this.jobs;
    }

    @Override
    public AzureFileShare.DefinitionStages.Blank<BatchAICluster.DefinitionStages.WithCreate> defineAzureFileShare() {
        return new AzureFileShareImpl<BatchAICluster.DefinitionStages.WithCreate>(new AzureFileShareReference(), this);
    }

    @Override
    public AzureBlobFileSystem.DefinitionStages.Blank<BatchAICluster.DefinitionStages.WithCreate> defineAzureBlobFileSystem() {
        return new AzureBlobFileSystemImpl<BatchAICluster.DefinitionStages.WithCreate>(new AzureBlobFileSystemReference(), this);
    }

    @Override
    public FileServer.DefinitionStages.Blank<BatchAICluster.DefinitionStages.WithCreate> defineFileServer() {
        return new FileServerImpl<BatchAICluster.DefinitionStages.WithCreate>(new FileServerReference(), this);
    }

    @Override
    public BatchAIClusterImpl withUnmanagedFileSystem(String mountCommand, String relativeMountPath) {
        MountVolumes mountVolumes = this.ensureMountVolumes();
        if (mountVolumes.unmanagedFileSystems() == null) {
            mountVolumes.withUnmanagedFileSystems(new ArrayList<UnmanagedFileSystemReference>());
        }
        mountVolumes.unmanagedFileSystems().add(new UnmanagedFileSystemReference().withMountCommand(mountCommand).withRelativeMountPath(relativeMountPath));
        return this;
    }

    @Override
    public void attachAzureFileShare(AzureFileShare azureFileShare) {
        MountVolumes mountVolumes = this.ensureMountVolumes();
        if (mountVolumes.azureFileShares() == null) {
            mountVolumes.withAzureFileShares(new ArrayList<AzureFileShareReference>());
        }
        mountVolumes.azureFileShares().add((AzureFileShareReference)azureFileShare.inner());
    }

    @Override
    public void attachAzureBlobFileSystem(AzureBlobFileSystem azureBlobFileSystem) {
        MountVolumes mountVolumes = this.ensureMountVolumes();
        if (mountVolumes.azureBlobFileSystems() == null) {
            mountVolumes.withAzureBlobFileSystems(new ArrayList<AzureBlobFileSystemReference>());
        }
        mountVolumes.azureBlobFileSystems().add((AzureBlobFileSystemReference)azureBlobFileSystem.inner());
    }

    @Override
    public void attachFileServer(FileServer fileServer) {
        MountVolumes mountVolumes = this.ensureMountVolumes();
        if (mountVolumes.fileServers() == null) {
            mountVolumes.withFileServers(new ArrayList<FileServerReference>());
        }
        mountVolumes.fileServers().add((FileServerReference)fileServer.inner());
    }

    private MountVolumes ensureMountVolumes() {
        if (this.ensureNodeSetup().mountVolumes() == null) {
            this.createParameters.nodeSetup().withMountVolumes(new MountVolumes());
        }
        return this.createParameters.nodeSetup().mountVolumes();
    }

    @Override
    public BatchAIClusterImpl withSubnet(String subnetId) {
        this.createParameters.withSubnet(new ResourceId().withId(subnetId));
        return this;
    }

    @Override
    public BatchAIClusterImpl withSubnet(String networkId, String subnetName) {
        this.createParameters.withSubnet(new ResourceId().withId(networkId + "/subnets/" + subnetName));
        return this;
    }

    @Override
    public BatchAIClusterImpl withAppInsightsComponentId(String resoureId) {
        if (this.ensureNodeSetup().performanceCountersSettings() == null) {
            this.createParameters.nodeSetup().withPerformanceCountersSettings(new PerformanceCountersSettings());
        }
        this.createParameters.nodeSetup().performanceCountersSettings().withAppInsightsReference(new AppInsightsReference().withComponent(new ResourceId().withId(resoureId)));
        return this;
    }

    @Override
    public BatchAIClusterImpl withInstrumentationKey(String instrumentationKey) {
        this.createParameters.nodeSetup().performanceCountersSettings().appInsightsReference().withInstrumentationKey(instrumentationKey);
        return this;
    }

    @Override
    public BatchAIClusterImpl withInstrumentationKeySecretReference(String keyVaultId, String secretUrl) {
        this.createParameters.nodeSetup().performanceCountersSettings().appInsightsReference().withInstrumentationKeySecretReference(new KeyVaultSecretReference().withSourceVault(new ResourceId().withId(keyVaultId)).withSecretUrl(secretUrl));
        return this;
    }

    @Override
    public BatchAIClusterImpl withVirtualMachineImage(String publisher, String offer, String sku, String version) {
        this.withVirtualMachineImage((String)publisher, (String)offer, (String)sku).createParameters.virtualMachineConfiguration().imageReference().withVersion(version);
        return this;
    }

    @Override
    public BatchAIClusterImpl withVirtualMachineImage(String publisher, String offer, String sku) {
        this.ensureVirtualMachineConfiguration().withImageReference(new ImageReference().withPublisher(publisher).withOffer(offer).withSku(sku));
        return this;
    }

    @Override
    public BatchAIClusterImpl withVirtualMachineImageId(String virtualMachineImageId, String publisher, String offer, String sku) {
        this.withVirtualMachineImage((String)publisher, (String)offer, (String)sku).createParameters.virtualMachineConfiguration().imageReference().withVirtualMachineImageId(virtualMachineImageId);
        return this;
    }

    private VirtualMachineConfiguration ensureVirtualMachineConfiguration() {
        if (this.createParameters.virtualMachineConfiguration() == null) {
            this.createParameters.withVirtualMachineConfiguration(new VirtualMachineConfiguration());
        }
        return this.createParameters.virtualMachineConfiguration();
    }
}

