/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batchai;

import java.util.Collection;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.microsoft.rest.ExpandableStringEnum;

/**
 * Defines values for ToolType.
 */
public final class ToolType extends ExpandableStringEnum<ToolType> {
    /** Static value cntk for ToolType. */
    public static final ToolType CNTK = fromString("cntk");

    /** Static value tensorflow for ToolType. */
    public static final ToolType TENSORFLOW = fromString("tensorflow");

    /** Static value caffe for ToolType. */
    public static final ToolType CAFFE = fromString("caffe");

    /** Static value caffe2 for ToolType. */
    public static final ToolType CAFFE2 = fromString("caffe2");

    /** Static value chainer for ToolType. */
    public static final ToolType CHAINER = fromString("chainer");

    /** Static value custom for ToolType. */
    public static final ToolType CUSTOM = fromString("custom");

    /**
     * Creates or finds a ToolType from its string representation.
     * @param name a name to look for
     * @return the corresponding ToolType
     */
    @JsonCreator
    public static ToolType fromString(String name) {
        return fromString(name, ToolType.class);
    }

    /**
     * @return known ToolType values
     */
    public static Collection<ToolType> values() {
        return values(ToolType.class);
    }
}
