/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.batchai.implementation;

import java.util.Map;
import com.microsoft.azure.management.batchai.ResourceId;
import com.microsoft.azure.management.batchai.MountVolumes;
import com.microsoft.azure.management.batchai.ContainerSettings;
import com.microsoft.azure.management.batchai.CNTKsettings;
import com.microsoft.azure.management.batchai.PyTorchSettings;
import com.microsoft.azure.management.batchai.TensorFlowSettings;
import com.microsoft.azure.management.batchai.CaffeSettings;
import com.microsoft.azure.management.batchai.Caffe2Settings;
import com.microsoft.azure.management.batchai.ChainerSettings;
import com.microsoft.azure.management.batchai.CustomToolkitSettings;
import com.microsoft.azure.management.batchai.JobPreparation;
import java.util.List;
import com.microsoft.azure.management.batchai.InputDirectory;
import com.microsoft.azure.management.batchai.OutputDirectory;
import com.microsoft.azure.management.batchai.EnvironmentVariable;
import com.microsoft.azure.management.batchai.EnvironmentVariableWithSecretValue;
import com.microsoft.azure.management.batchai.JobBasePropertiesConstraints;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;

/**
 * Parameters supplied to the Create operation.
 */
@JsonFlatten
public class JobCreateParametersInner {
    /**
     * The region in which to create the job.
     */
    @JsonProperty(value = "location", required = true)
    private String location;

    /**
     * The user specified tags associated with the job.
     */
    @JsonProperty(value = "tags")
    private Map<String, String> tags;

    /**
     * Describe the experiment information of the job.
     */
    @JsonProperty(value = "properties.experimentName")
    private String experimentName;

    /**
     * Priority associated with the job.
     * Priority associated with the job. Priority values can range from -1000
     * to 1000, with -1000 being the lowest priority and 1000 being the highest
     * priority. The default value is 0.
     */
    @JsonProperty(value = "properties.priority")
    private Integer priority;

    /**
     * Specifies the Id of the cluster on which this job will run.
     */
    @JsonProperty(value = "properties.cluster", required = true)
    private ResourceId cluster;

    /**
     * Information on mount volumes to be used by the job.
     * These volumes will be mounted before the job execution and will be
     * unmouted after the job completion. The volumes will be mounted at
     * location specified by $AZ_BATCHAI_JOB_MOUNT_ROOT environment variable.
     */
    @JsonProperty(value = "properties.mountVolumes")
    private MountVolumes mountVolumes;

    /**
     * Number of compute nodes to run the job on.
     * The job will be gang scheduled on that many compute nodes.
     */
    @JsonProperty(value = "properties.nodeCount", required = true)
    private int nodeCount;

    /**
     * If provided the job will run in the specified container.
     * If the container was downloaded as part of cluster setup then the same
     * container image will be used. If not provided, the job will run on the
     * VM.
     */
    @JsonProperty(value = "properties.containerSettings")
    private ContainerSettings containerSettings;

    /**
     * Specifies the settings for CNTK (aka Microsoft Cognitive Toolkit) job.
     */
    @JsonProperty(value = "properties.cntkSettings")
    private CNTKsettings cntkSettings;

    /**
     * Specifies the settings for pyTorch job.
     */
    @JsonProperty(value = "properties.pyTorchSettings")
    private PyTorchSettings pyTorchSettings;

    /**
     * Specifies the settings for Tensor Flow job.
     */
    @JsonProperty(value = "properties.tensorFlowSettings")
    private TensorFlowSettings tensorFlowSettings;

    /**
     * Specifies the settings for Caffe job.
     */
    @JsonProperty(value = "properties.caffeSettings")
    private CaffeSettings caffeSettings;

    /**
     * Specifies the settings for Caffe2 job.
     */
    @JsonProperty(value = "properties.caffe2Settings")
    private Caffe2Settings caffe2Settings;

    /**
     * Specifies the settings for Chainer job.
     */
    @JsonProperty(value = "properties.chainerSettings")
    private ChainerSettings chainerSettings;

    /**
     * Specifies the settings for custom tool kit job.
     */
    @JsonProperty(value = "properties.customToolkitSettings")
    private CustomToolkitSettings customToolkitSettings;

    /**
     * Specifies the command line to be executed before tool kit is launched.
     * The specified actions will run on all the nodes that are part of the
     * job.
     */
    @JsonProperty(value = "properties.jobPreparation")
    private JobPreparation jobPreparation;

    /**
     * The path where the Batch AI service will upload stdout and stderror of
     * the job.
     */
    @JsonProperty(value = "properties.stdOutErrPathPrefix", required = true)
    private String stdOutErrPathPrefix;

    /**
     * Specifies the list of input directories for the Job.
     */
    @JsonProperty(value = "properties.inputDirectories")
    private List<InputDirectory> inputDirectories;

    /**
     * Specifies the list of output directories.
     */
    @JsonProperty(value = "properties.outputDirectories")
    private List<OutputDirectory> outputDirectories;

    /**
     * Additional environment variables to set on the job.
     * Batch AI will setup these additional environment variables for the job.
     */
    @JsonProperty(value = "properties.environmentVariables")
    private List<EnvironmentVariable> environmentVariables;

    /**
     * Additional environment variables with secret values to set on the job.
     * Batch AI will setup these additional environment variables for the job.
     * Server will never report values of these variables back.
     */
    @JsonProperty(value = "properties.secrets")
    private List<EnvironmentVariableWithSecretValue> secrets;

    /**
     * Constraints associated with the Job.
     */
    @JsonProperty(value = "properties.constraints")
    private JobBasePropertiesConstraints constraints;

    /**
     * Get the location value.
     *
     * @return the location value
     */
    public String location() {
        return this.location;
    }

    /**
     * Set the location value.
     *
     * @param location the location value to set
     * @return the JobCreateParametersInner object itself.
     */
    public JobCreateParametersInner withLocation(String location) {
        this.location = location;
        return this;
    }

    /**
     * Get the tags value.
     *
     * @return the tags value
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the tags value.
     *
     * @param tags the tags value to set
     * @return the JobCreateParametersInner object itself.
     */
    public JobCreateParametersInner withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the experimentName value.
     *
     * @return the experimentName value
     */
    public String experimentName() {
        return this.experimentName;
    }

    /**
     * Set the experimentName value.
     *
     * @param experimentName the experimentName value to set
     * @return the JobCreateParametersInner object itself.
     */
    public JobCreateParametersInner withExperimentName(String experimentName) {
        this.experimentName = experimentName;
        return this;
    }

    /**
     * Get the priority value.
     *
     * @return the priority value
     */
    public Integer priority() {
        return this.priority;
    }

    /**
     * Set the priority value.
     *
     * @param priority the priority value to set
     * @return the JobCreateParametersInner object itself.
     */
    public JobCreateParametersInner withPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    /**
     * Get the cluster value.
     *
     * @return the cluster value
     */
    public ResourceId cluster() {
        return this.cluster;
    }

    /**
     * Set the cluster value.
     *
     * @param cluster the cluster value to set
     * @return the JobCreateParametersInner object itself.
     */
    public JobCreateParametersInner withCluster(ResourceId cluster) {
        this.cluster = cluster;
        return this;
    }

    /**
     * Get the mountVolumes value.
     *
     * @return the mountVolumes value
     */
    public MountVolumes mountVolumes() {
        return this.mountVolumes;
    }

    /**
     * Set the mountVolumes value.
     *
     * @param mountVolumes the mountVolumes value to set
     * @return the JobCreateParametersInner object itself.
     */
    public JobCreateParametersInner withMountVolumes(MountVolumes mountVolumes) {
        this.mountVolumes = mountVolumes;
        return this;
    }

    /**
     * Get the nodeCount value.
     *
     * @return the nodeCount value
     */
    public int nodeCount() {
        return this.nodeCount;
    }

    /**
     * Set the nodeCount value.
     *
     * @param nodeCount the nodeCount value to set
     * @return the JobCreateParametersInner object itself.
     */
    public JobCreateParametersInner withNodeCount(int nodeCount) {
        this.nodeCount = nodeCount;
        return this;
    }

    /**
     * Get the containerSettings value.
     *
     * @return the containerSettings value
     */
    public ContainerSettings containerSettings() {
        return this.containerSettings;
    }

    /**
     * Set the containerSettings value.
     *
     * @param containerSettings the containerSettings value to set
     * @return the JobCreateParametersInner object itself.
     */
    public JobCreateParametersInner withContainerSettings(ContainerSettings containerSettings) {
        this.containerSettings = containerSettings;
        return this;
    }

    /**
     * Get the cntkSettings value.
     *
     * @return the cntkSettings value
     */
    public CNTKsettings cntkSettings() {
        return this.cntkSettings;
    }

    /**
     * Set the cntkSettings value.
     *
     * @param cntkSettings the cntkSettings value to set
     * @return the JobCreateParametersInner object itself.
     */
    public JobCreateParametersInner withCntkSettings(CNTKsettings cntkSettings) {
        this.cntkSettings = cntkSettings;
        return this;
    }

    /**
     * Get the pyTorchSettings value.
     *
     * @return the pyTorchSettings value
     */
    public PyTorchSettings pyTorchSettings() {
        return this.pyTorchSettings;
    }

    /**
     * Set the pyTorchSettings value.
     *
     * @param pyTorchSettings the pyTorchSettings value to set
     * @return the JobCreateParametersInner object itself.
     */
    public JobCreateParametersInner withPyTorchSettings(PyTorchSettings pyTorchSettings) {
        this.pyTorchSettings = pyTorchSettings;
        return this;
    }

    /**
     * Get the tensorFlowSettings value.
     *
     * @return the tensorFlowSettings value
     */
    public TensorFlowSettings tensorFlowSettings() {
        return this.tensorFlowSettings;
    }

    /**
     * Set the tensorFlowSettings value.
     *
     * @param tensorFlowSettings the tensorFlowSettings value to set
     * @return the JobCreateParametersInner object itself.
     */
    public JobCreateParametersInner withTensorFlowSettings(TensorFlowSettings tensorFlowSettings) {
        this.tensorFlowSettings = tensorFlowSettings;
        return this;
    }

    /**
     * Get the caffeSettings value.
     *
     * @return the caffeSettings value
     */
    public CaffeSettings caffeSettings() {
        return this.caffeSettings;
    }

    /**
     * Set the caffeSettings value.
     *
     * @param caffeSettings the caffeSettings value to set
     * @return the JobCreateParametersInner object itself.
     */
    public JobCreateParametersInner withCaffeSettings(CaffeSettings caffeSettings) {
        this.caffeSettings = caffeSettings;
        return this;
    }

    /**
     * Get the caffe2Settings value.
     *
     * @return the caffe2Settings value
     */
    public Caffe2Settings caffe2Settings() {
        return this.caffe2Settings;
    }

    /**
     * Set the caffe2Settings value.
     *
     * @param caffe2Settings the caffe2Settings value to set
     * @return the JobCreateParametersInner object itself.
     */
    public JobCreateParametersInner withCaffe2Settings(Caffe2Settings caffe2Settings) {
        this.caffe2Settings = caffe2Settings;
        return this;
    }

    /**
     * Get the chainerSettings value.
     *
     * @return the chainerSettings value
     */
    public ChainerSettings chainerSettings() {
        return this.chainerSettings;
    }

    /**
     * Set the chainerSettings value.
     *
     * @param chainerSettings the chainerSettings value to set
     * @return the JobCreateParametersInner object itself.
     */
    public JobCreateParametersInner withChainerSettings(ChainerSettings chainerSettings) {
        this.chainerSettings = chainerSettings;
        return this;
    }

    /**
     * Get the customToolkitSettings value.
     *
     * @return the customToolkitSettings value
     */
    public CustomToolkitSettings customToolkitSettings() {
        return this.customToolkitSettings;
    }

    /**
     * Set the customToolkitSettings value.
     *
     * @param customToolkitSettings the customToolkitSettings value to set
     * @return the JobCreateParametersInner object itself.
     */
    public JobCreateParametersInner withCustomToolkitSettings(CustomToolkitSettings customToolkitSettings) {
        this.customToolkitSettings = customToolkitSettings;
        return this;
    }

    /**
     * Get the jobPreparation value.
     *
     * @return the jobPreparation value
     */
    public JobPreparation jobPreparation() {
        return this.jobPreparation;
    }

    /**
     * Set the jobPreparation value.
     *
     * @param jobPreparation the jobPreparation value to set
     * @return the JobCreateParametersInner object itself.
     */
    public JobCreateParametersInner withJobPreparation(JobPreparation jobPreparation) {
        this.jobPreparation = jobPreparation;
        return this;
    }

    /**
     * Get the stdOutErrPathPrefix value.
     *
     * @return the stdOutErrPathPrefix value
     */
    public String stdOutErrPathPrefix() {
        return this.stdOutErrPathPrefix;
    }

    /**
     * Set the stdOutErrPathPrefix value.
     *
     * @param stdOutErrPathPrefix the stdOutErrPathPrefix value to set
     * @return the JobCreateParametersInner object itself.
     */
    public JobCreateParametersInner withStdOutErrPathPrefix(String stdOutErrPathPrefix) {
        this.stdOutErrPathPrefix = stdOutErrPathPrefix;
        return this;
    }

    /**
     * Get the inputDirectories value.
     *
     * @return the inputDirectories value
     */
    public List<InputDirectory> inputDirectories() {
        return this.inputDirectories;
    }

    /**
     * Set the inputDirectories value.
     *
     * @param inputDirectories the inputDirectories value to set
     * @return the JobCreateParametersInner object itself.
     */
    public JobCreateParametersInner withInputDirectories(List<InputDirectory> inputDirectories) {
        this.inputDirectories = inputDirectories;
        return this;
    }

    /**
     * Get the outputDirectories value.
     *
     * @return the outputDirectories value
     */
    public List<OutputDirectory> outputDirectories() {
        return this.outputDirectories;
    }

    /**
     * Set the outputDirectories value.
     *
     * @param outputDirectories the outputDirectories value to set
     * @return the JobCreateParametersInner object itself.
     */
    public JobCreateParametersInner withOutputDirectories(List<OutputDirectory> outputDirectories) {
        this.outputDirectories = outputDirectories;
        return this;
    }

    /**
     * Get the environmentVariables value.
     *
     * @return the environmentVariables value
     */
    public List<EnvironmentVariable> environmentVariables() {
        return this.environmentVariables;
    }

    /**
     * Set the environmentVariables value.
     *
     * @param environmentVariables the environmentVariables value to set
     * @return the JobCreateParametersInner object itself.
     */
    public JobCreateParametersInner withEnvironmentVariables(List<EnvironmentVariable> environmentVariables) {
        this.environmentVariables = environmentVariables;
        return this;
    }

    /**
     * Get the secrets value.
     *
     * @return the secrets value
     */
    public List<EnvironmentVariableWithSecretValue> secrets() {
        return this.secrets;
    }

    /**
     * Set the secrets value.
     *
     * @param secrets the secrets value to set
     * @return the JobCreateParametersInner object itself.
     */
    public JobCreateParametersInner withSecrets(List<EnvironmentVariableWithSecretValue> secrets) {
        this.secrets = secrets;
        return this;
    }

    /**
     * Get the constraints value.
     *
     * @return the constraints value
     */
    public JobBasePropertiesConstraints constraints() {
        return this.constraints;
    }

    /**
     * Set the constraints value.
     *
     * @param constraints the constraints value to set
     * @return the JobCreateParametersInner object itself.
     */
    public JobCreateParametersInner withConstraints(JobBasePropertiesConstraints constraints) {
        this.constraints = constraints;
        return this;
    }

}
