/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.cdn.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.Resource;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.cdn.CdnEndpoint;
import com.microsoft.azure.management.cdn.CdnProfile;
import com.microsoft.azure.management.cdn.CheckNameAvailabilityResult;
import com.microsoft.azure.management.cdn.CustomDomainValidationResult;
import com.microsoft.azure.management.cdn.ResourceUsage;
import com.microsoft.azure.management.cdn.Sku;
import com.microsoft.azure.management.cdn.SkuName;
import com.microsoft.azure.management.cdn.implementation.CdnEndpointImpl;
import com.microsoft.azure.management.cdn.implementation.CdnEndpointsImpl;
import com.microsoft.azure.management.cdn.implementation.CdnManagementClientImpl;
import com.microsoft.azure.management.cdn.implementation.CdnManager;
import com.microsoft.azure.management.cdn.implementation.ProfileInner;
import com.microsoft.azure.management.cdn.implementation.ProfilesInner;
import com.microsoft.azure.management.cdn.implementation.ResourceUsageInner;
import com.microsoft.azure.management.cdn.implementation.SsoUriInner;
import com.microsoft.azure.management.cdn.implementation.ValidateCustomDomainOutputInner;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.ManagerBase;
import com.microsoft.azure.management.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.PagedListConverter;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class CdnProfileImpl
extends GroupableResourceImpl<CdnProfile, ProfileInner, CdnProfileImpl, CdnManager>
implements CdnProfile,
CdnProfile.Definition,
CdnProfile.Update {
    private CdnEndpointsImpl endpointsImpl = new CdnEndpointsImpl(this);

    CdnProfileImpl(String name, ProfileInner innerModel, CdnManager cdnManager) {
        super(name, (Resource)innerModel, (ManagerBase)cdnManager);
    }

    @Override
    public Map<String, CdnEndpoint> endpoints() {
        return this.endpointsImpl.endpointsAsMap();
    }

    @Override
    public String generateSsoUri() {
        return (String)this.generateSsoUriAsync().toBlocking().last();
    }

    @Override
    public Observable<String> generateSsoUriAsync() {
        return ((CdnManagementClientImpl)((Object)((CdnManager)this.manager()).inner())).profiles().generateSsoUriAsync(this.resourceGroupName(), this.name()).map((Func1)new Func1<SsoUriInner, String>(){

            public String call(SsoUriInner ssoUriInner) {
                if (ssoUriInner != null) {
                    return ssoUriInner.ssoUriValue();
                }
                return null;
            }
        });
    }

    @Override
    public ServiceFuture<String> generateSsoUriAsync(ServiceCallback<String> callback) {
        return ServiceFuture.fromBody(this.generateSsoUriAsync(), callback);
    }

    @Override
    public void startEndpoint(String endpointName) {
        this.startEndpointAsync(endpointName).await();
    }

    @Override
    public Completable startEndpointAsync(String endpointName) {
        return ((CdnManagementClientImpl)((Object)((CdnManager)this.manager()).inner())).endpoints().startAsync(this.resourceGroupName(), this.name(), endpointName).toCompletable();
    }

    @Override
    public ServiceFuture<Void> startEndpointAsync(String endpointName, ServiceCallback<Void> callback) {
        return ServiceFuture.fromBody((Observable)this.startEndpointAsync(endpointName).toObservable(), callback);
    }

    @Override
    public void stopEndpoint(String endpointName) {
        this.stopEndpointAsync(endpointName).await();
    }

    @Override
    public Completable stopEndpointAsync(String endpointName) {
        return ((CdnManagementClientImpl)((Object)((CdnManager)this.manager()).inner())).endpoints().stopAsync(this.resourceGroupName(), this.name(), endpointName).toCompletable();
    }

    @Override
    public ServiceFuture<Void> stopEndpointAsync(String endpointName, ServiceCallback<Void> callback) {
        return ServiceFuture.fromBody((Observable)this.stopEndpointAsync(endpointName).toObservable(), callback);
    }

    @Override
    public PagedList<ResourceUsage> listResourceUsage() {
        return new PagedListConverter<ResourceUsageInner, ResourceUsage>(){

            public ResourceUsage typeConvert(ResourceUsageInner inner) {
                return new ResourceUsage(inner);
            }
        }.convert(((CdnManagementClientImpl)((Object)((CdnManager)this.manager()).inner())).profiles().listResourceUsage(this.resourceGroupName(), this.name()));
    }

    @Override
    public void purgeEndpointContent(String endpointName, Set<String> contentPaths) {
        this.purgeEndpointContentAsync(endpointName, contentPaths).await();
    }

    @Override
    public Completable purgeEndpointContentAsync(String endpointName, Set<String> contentPaths) {
        if (contentPaths != null) {
            return ((CdnManagementClientImpl)((Object)((CdnManager)this.manager()).inner())).endpoints().purgeContentAsync(this.resourceGroupName(), this.name(), endpointName, new ArrayList<String>(contentPaths)).toCompletable();
        }
        return Observable.empty().toCompletable();
    }

    @Override
    public ServiceFuture<Void> purgeEndpointContentAsync(String endpointName, Set<String> contentPaths, ServiceCallback<Void> callback) {
        return ServiceFuture.fromBody((Observable)this.purgeEndpointContentAsync(endpointName, contentPaths).toObservable(), callback);
    }

    @Override
    public void loadEndpointContent(String endpointName, Set<String> contentPaths) {
        this.loadEndpointContentAsync(endpointName, contentPaths).await();
    }

    @Override
    public Completable loadEndpointContentAsync(String endpointName, Set<String> contentPaths) {
        if (contentPaths != null) {
            return ((CdnManagementClientImpl)((Object)((CdnManager)this.manager()).inner())).endpoints().loadContentAsync(this.resourceGroupName(), this.name(), endpointName, new ArrayList<String>(contentPaths)).toCompletable();
        }
        return Observable.empty().toCompletable();
    }

    @Override
    public ServiceFuture<Void> loadEndpointContentAsync(String endpointName, Set<String> contentPaths, ServiceCallback<Void> callback) {
        return ServiceFuture.fromBody((Observable)this.loadEndpointContentAsync(endpointName, contentPaths).toObservable(), callback);
    }

    @Override
    public CustomDomainValidationResult validateEndpointCustomDomain(String endpointName, String hostName) {
        return (CustomDomainValidationResult)this.validateEndpointCustomDomainAsync(endpointName, hostName).toBlocking().last();
    }

    @Override
    public Observable<CustomDomainValidationResult> validateEndpointCustomDomainAsync(String endpointName, String hostName) {
        return ((CdnManagementClientImpl)((Object)((CdnManager)this.manager()).inner())).endpoints().validateCustomDomainAsync(this.resourceGroupName(), this.name(), endpointName, hostName).map((Func1)new Func1<ValidateCustomDomainOutputInner, CustomDomainValidationResult>(){

            public CustomDomainValidationResult call(ValidateCustomDomainOutputInner validateCustomDomainOutputInner) {
                return new CustomDomainValidationResult(validateCustomDomainOutputInner);
            }
        });
    }

    @Override
    public ServiceFuture<CustomDomainValidationResult> validateEndpointCustomDomainAsync(String endpointName, String hostName, ServiceCallback<CustomDomainValidationResult> callback) {
        return ServiceFuture.fromBody(this.validateEndpointCustomDomainAsync(endpointName, hostName), callback);
    }

    @Override
    public CheckNameAvailabilityResult checkEndpointNameAvailability(String name) {
        return (CheckNameAvailabilityResult)this.checkEndpointNameAvailabilityAsync(name).toBlocking().last();
    }

    @Override
    public Observable<CheckNameAvailabilityResult> checkEndpointNameAvailabilityAsync(String name) {
        return ((CdnManager)this.manager()).profiles().checkEndpointNameAvailabilityAsync(name);
    }

    @Override
    public ServiceFuture<CheckNameAvailabilityResult> checkEndpointNameAvailabilityAsync(String name, ServiceCallback<CheckNameAvailabilityResult> callback) {
        return ServiceFuture.fromBody(this.checkEndpointNameAvailabilityAsync(name), callback);
    }

    @Override
    public boolean isPremiumVerizon() {
        return this.sku() != null && this.sku().name() != null && this.sku().name().equals(SkuName.PREMIUM_VERIZON);
    }

    public String regionName() {
        return ((ProfileInner)((Object)this.inner())).location();
    }

    @Override
    public Sku sku() {
        return ((ProfileInner)((Object)this.inner())).sku();
    }

    @Override
    public String resourceState() {
        return ((ProfileInner)((Object)this.inner())).resourceState().toString();
    }

    protected Observable<ProfileInner> getInnerAsync() {
        return ((CdnManagementClientImpl)((Object)((CdnManager)this.manager()).inner())).profiles().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    public Observable<CdnProfile> updateResourceAsync() {
        final CdnProfileImpl self = this;
        final ProfilesInner innerCollection = ((CdnManagementClientImpl)((Object)((CdnManager)this.manager()).inner())).profiles();
        return self.endpointsImpl.commitAndGetAllAsync().flatMap((Func1)new Func1<List<CdnEndpointImpl>, Observable<? extends CdnProfile>>(){

            public Observable<? extends CdnProfile> call(List<CdnEndpointImpl> endpoints) {
                return innerCollection.updateAsync(CdnProfileImpl.this.resourceGroupName(), CdnProfileImpl.this.name(), ((ProfileInner)((Object)CdnProfileImpl.this.inner())).getTags()).map((Func1)new Func1<ProfileInner, CdnProfile>(){

                    public CdnProfile call(ProfileInner profileInner) {
                        self.setInner((Object)profileInner);
                        return self;
                    }
                });
            }
        });
    }

    public Observable<CdnProfile> createResourceAsync() {
        final CdnProfileImpl self = this;
        return ((CdnManagementClientImpl)((Object)((CdnManager)this.manager()).inner())).profiles().createAsync(this.resourceGroupName(), this.name(), (ProfileInner)((Object)this.inner())).map((Func1)new Func1<ProfileInner, CdnProfile>(){

            public CdnProfile call(ProfileInner profileInner) {
                self.setInner((Object)profileInner);
                return self;
            }
        }).flatMap((Func1)new Func1<CdnProfile, Observable<? extends CdnProfile>>(){

            public Observable<? extends CdnProfile> call(CdnProfile profile) {
                return self.endpointsImpl.commitAndGetAllAsync().map((Func1)new Func1<List<CdnEndpointImpl>, CdnProfile>(){

                    public CdnProfile call(List<CdnEndpointImpl> endpoints) {
                        return self;
                    }
                });
            }
        });
    }

    @Override
    public CdnProfileImpl withStandardAkamaiSku() {
        ((ProfileInner)((Object)this.inner())).withSku(new Sku().withName(SkuName.STANDARD_AKAMAI));
        return this;
    }

    @Override
    public CdnProfileImpl withStandardVerizonSku() {
        ((ProfileInner)((Object)this.inner())).withSku(new Sku().withName(SkuName.STANDARD_VERIZON));
        return this;
    }

    @Override
    public CdnProfileImpl withPremiumVerizonSku() {
        ((ProfileInner)((Object)this.inner())).withSku(new Sku().withName(SkuName.PREMIUM_VERIZON));
        return this;
    }

    @Override
    public CdnProfileImpl withNewEndpoint(String endpointOriginHostname) {
        CdnEndpointImpl endpoint = this.endpointsImpl.defineNewEndpointWithOriginHostname(endpointOriginHostname);
        this.endpointsImpl.addEndpoint(endpoint);
        return this;
    }

    public CdnEndpointImpl defineNewEndpoint() {
        return this.endpointsImpl.defineNewEndpoint();
    }

    public CdnEndpointImpl defineNewEndpoint(String name) {
        return this.endpointsImpl.defineNewEndpoint(name);
    }

    public CdnEndpointImpl defineNewEndpoint(String name, String endpointOriginHostname) {
        return this.endpointsImpl.defineNewEndpoint(name, endpointOriginHostname);
    }

    @Override
    public CdnProfileImpl withNewPremiumEndpoint(String endpointOriginHostname) {
        return this.withNewEndpoint(endpointOriginHostname);
    }

    public CdnEndpointImpl defineNewPremiumEndpoint() {
        return this.endpointsImpl.defineNewEndpoint();
    }

    public CdnEndpointImpl defineNewPremiumEndpoint(String name) {
        return this.defineNewEndpoint(name);
    }

    public CdnEndpointImpl defineNewPremiumEndpoint(String name, String endpointOriginHostname) {
        return this.defineNewEndpoint(name, endpointOriginHostname);
    }

    @Override
    public CdnEndpointImpl updateEndpoint(String name) {
        return this.endpointsImpl.updateEndpoint(name);
    }

    @Override
    public CdnEndpointImpl updatePremiumEndpoint(String name) {
        return this.endpointsImpl.updateEndpoint(name);
    }

    @Override
    public CdnProfile.Update withoutEndpoint(String name) {
        this.endpointsImpl.remove(name);
        return this;
    }

    CdnProfileImpl withEndpoint(CdnEndpointImpl endpoint) {
        this.endpointsImpl.addEndpoint(endpoint);
        return this;
    }
}

