/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.cdn.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.cdn.ErrorResponseException;
import com.microsoft.azure.management.cdn.implementation.CdnManagementClientImpl;
import com.microsoft.azure.management.cdn.implementation.EdgeNodeInner;
import com.microsoft.azure.management.cdn.implementation.PageImpl;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class EdgeNodesInner {
    private EdgeNodesService service;
    private CdnManagementClientImpl client;

    public EdgeNodesInner(Retrofit retrofit, CdnManagementClientImpl client) {
        this.service = (EdgeNodesService)retrofit.create(EdgeNodesService.class);
        this.client = client;
    }

    public PagedList<EdgeNodeInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<EdgeNodeInner>((Page)response.body()){

            public Page<EdgeNodeInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)EdgeNodesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<EdgeNodeInner>> listAsync(ListOperationCallback<EdgeNodeInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<EdgeNodeInner>>>>(){

            public Observable<ServiceResponse<Page<EdgeNodeInner>>> call(String nextPageLink) {
                return EdgeNodesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<EdgeNodeInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<EdgeNodeInner>>, Page<EdgeNodeInner>>(){

            public Page<EdgeNodeInner> call(ServiceResponse<Page<EdgeNodeInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<EdgeNodeInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<EdgeNodeInner>>, Observable<ServiceResponse<Page<EdgeNodeInner>>>>(){

            public Observable<ServiceResponse<Page<EdgeNodeInner>>> call(ServiceResponse<Page<EdgeNodeInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(EdgeNodesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<EdgeNodeInner>>> listSinglePageAsync() {
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<EdgeNodeInner>>>>(){

            public Observable<ServiceResponse<Page<EdgeNodeInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = EdgeNodesInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<EdgeNodeInner>> listDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<EdgeNodeInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    public PagedList<EdgeNodeInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<EdgeNodeInner>((Page)response.body()){

            public Page<EdgeNodeInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)EdgeNodesInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<EdgeNodeInner>> listNextAsync(String nextPageLink, ServiceFuture<List<EdgeNodeInner>> serviceFuture, ListOperationCallback<EdgeNodeInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<EdgeNodeInner>>>>(){

            public Observable<ServiceResponse<Page<EdgeNodeInner>>> call(String nextPageLink) {
                return EdgeNodesInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<EdgeNodeInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<EdgeNodeInner>>, Page<EdgeNodeInner>>(){

            public Page<EdgeNodeInner> call(ServiceResponse<Page<EdgeNodeInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<EdgeNodeInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<EdgeNodeInner>>, Observable<ServiceResponse<Page<EdgeNodeInner>>>>(){

            public Observable<ServiceResponse<Page<EdgeNodeInner>>> call(ServiceResponse<Page<EdgeNodeInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(EdgeNodesInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<EdgeNodeInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<EdgeNodeInner>>>>(){

            public Observable<ServiceResponse<Page<EdgeNodeInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = EdgeNodesInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<EdgeNodeInner>> listNextDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<EdgeNodeInner>>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    static interface EdgeNodesService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.EdgeNodes list"})
        @GET(value="providers/Microsoft.Cdn/edgenodes")
        public Observable<Response<ResponseBody>> list(@Query(value="api-version") String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cdn.EdgeNodes listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

