/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn.implementation;

import java.util.Map;
import java.util.List;
import com.microsoft.azure.management.cdn.QueryStringCachingBehavior;
import com.microsoft.azure.management.cdn.GeoFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.rest.serializer.JsonFlatten;

/**
 * Properties required to create a new endpoint.
 */
@JsonFlatten
public class EndpointUpdateParametersInner {
    /**
     * Endpoint tags.
     */
    @JsonProperty(value = "tags")
    private Map<String, String> tags;

    /**
     * The host header CDN sends along with content requests to origin. The
     * default value is the host name of the origin.
     */
    @JsonProperty(value = "properties.originHostHeader")
    private String originHostHeader;

    /**
     * The path used when CDN sends request to origin.
     */
    @JsonProperty(value = "properties.originPath")
    private String originPath;

    /**
     * List of content types on which compression applies. The value should be
     * a valid MIME type.
     */
    @JsonProperty(value = "properties.contentTypesToCompress")
    private List<String> contentTypesToCompress;

    /**
     * Indicates whether content compression is enabled on CDN. Default value
     * is false. If compression is enabled, content will be served as
     * compressed if user requests for a compressed version. Content won't be
     * compressed on CDN when requested content is smaller than 1 byte or
     * larger than 1 MB.
     */
    @JsonProperty(value = "properties.isCompressionEnabled")
    private Boolean isCompressionEnabled;

    /**
     * Indicates whether HTTP traffic is allowed on the endpoint. Default value
     * is true. At least one protocol (HTTP or HTTPS) must be allowed.
     */
    @JsonProperty(value = "properties.isHttpAllowed")
    private Boolean isHttpAllowed;

    /**
     * Indicates whether HTTPS traffic is allowed on the endpoint. Default
     * value is true. At least one protocol (HTTP or HTTPS) must be allowed.
     */
    @JsonProperty(value = "properties.isHttpsAllowed")
    private Boolean isHttpsAllowed;

    /**
     * Defines the query string caching behavior. Possible values include:
     * 'IgnoreQueryString', 'BypassCaching', 'UseQueryString', 'NotSet'.
     */
    @JsonProperty(value = "properties.queryStringCachingBehavior")
    private QueryStringCachingBehavior queryStringCachingBehavior;

    /**
     * Customer can specify what scenario they want this CDN endpoint to
     * optimize, e.g. Download, Media services. With this information we can
     * apply scenario driven optimization.
     */
    @JsonProperty(value = "properties.optimizationType")
    private String optimizationType;

    /**
     * List of rules defining user geo access within a CDN endpoint. Each geo
     * filter defines an acess rule to a specified path or content, e.g. block
     * APAC for path /pictures/.
     */
    @JsonProperty(value = "properties.geoFilters")
    private List<GeoFilter> geoFilters;

    /**
     * Get the tags value.
     *
     * @return the tags value
     */
    public Map<String, String> tags() {
        return this.tags;
    }

    /**
     * Set the tags value.
     *
     * @param tags the tags value to set
     * @return the EndpointUpdateParametersInner object itself.
     */
    public EndpointUpdateParametersInner withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    /**
     * Get the originHostHeader value.
     *
     * @return the originHostHeader value
     */
    public String originHostHeader() {
        return this.originHostHeader;
    }

    /**
     * Set the originHostHeader value.
     *
     * @param originHostHeader the originHostHeader value to set
     * @return the EndpointUpdateParametersInner object itself.
     */
    public EndpointUpdateParametersInner withOriginHostHeader(String originHostHeader) {
        this.originHostHeader = originHostHeader;
        return this;
    }

    /**
     * Get the originPath value.
     *
     * @return the originPath value
     */
    public String originPath() {
        return this.originPath;
    }

    /**
     * Set the originPath value.
     *
     * @param originPath the originPath value to set
     * @return the EndpointUpdateParametersInner object itself.
     */
    public EndpointUpdateParametersInner withOriginPath(String originPath) {
        this.originPath = originPath;
        return this;
    }

    /**
     * Get the contentTypesToCompress value.
     *
     * @return the contentTypesToCompress value
     */
    public List<String> contentTypesToCompress() {
        return this.contentTypesToCompress;
    }

    /**
     * Set the contentTypesToCompress value.
     *
     * @param contentTypesToCompress the contentTypesToCompress value to set
     * @return the EndpointUpdateParametersInner object itself.
     */
    public EndpointUpdateParametersInner withContentTypesToCompress(List<String> contentTypesToCompress) {
        this.contentTypesToCompress = contentTypesToCompress;
        return this;
    }

    /**
     * Get the isCompressionEnabled value.
     *
     * @return the isCompressionEnabled value
     */
    public Boolean isCompressionEnabled() {
        return this.isCompressionEnabled;
    }

    /**
     * Set the isCompressionEnabled value.
     *
     * @param isCompressionEnabled the isCompressionEnabled value to set
     * @return the EndpointUpdateParametersInner object itself.
     */
    public EndpointUpdateParametersInner withIsCompressionEnabled(Boolean isCompressionEnabled) {
        this.isCompressionEnabled = isCompressionEnabled;
        return this;
    }

    /**
     * Get the isHttpAllowed value.
     *
     * @return the isHttpAllowed value
     */
    public Boolean isHttpAllowed() {
        return this.isHttpAllowed;
    }

    /**
     * Set the isHttpAllowed value.
     *
     * @param isHttpAllowed the isHttpAllowed value to set
     * @return the EndpointUpdateParametersInner object itself.
     */
    public EndpointUpdateParametersInner withIsHttpAllowed(Boolean isHttpAllowed) {
        this.isHttpAllowed = isHttpAllowed;
        return this;
    }

    /**
     * Get the isHttpsAllowed value.
     *
     * @return the isHttpsAllowed value
     */
    public Boolean isHttpsAllowed() {
        return this.isHttpsAllowed;
    }

    /**
     * Set the isHttpsAllowed value.
     *
     * @param isHttpsAllowed the isHttpsAllowed value to set
     * @return the EndpointUpdateParametersInner object itself.
     */
    public EndpointUpdateParametersInner withIsHttpsAllowed(Boolean isHttpsAllowed) {
        this.isHttpsAllowed = isHttpsAllowed;
        return this;
    }

    /**
     * Get the queryStringCachingBehavior value.
     *
     * @return the queryStringCachingBehavior value
     */
    public QueryStringCachingBehavior queryStringCachingBehavior() {
        return this.queryStringCachingBehavior;
    }

    /**
     * Set the queryStringCachingBehavior value.
     *
     * @param queryStringCachingBehavior the queryStringCachingBehavior value to set
     * @return the EndpointUpdateParametersInner object itself.
     */
    public EndpointUpdateParametersInner withQueryStringCachingBehavior(QueryStringCachingBehavior queryStringCachingBehavior) {
        this.queryStringCachingBehavior = queryStringCachingBehavior;
        return this;
    }

    /**
     * Get the optimizationType value.
     *
     * @return the optimizationType value
     */
    public String optimizationType() {
        return this.optimizationType;
    }

    /**
     * Set the optimizationType value.
     *
     * @param optimizationType the optimizationType value to set
     * @return the EndpointUpdateParametersInner object itself.
     */
    public EndpointUpdateParametersInner withOptimizationType(String optimizationType) {
        this.optimizationType = optimizationType;
        return this;
    }

    /**
     * Get the geoFilters value.
     *
     * @return the geoFilters value
     */
    public List<GeoFilter> geoFilters() {
        return this.geoFilters;
    }

    /**
     * Set the geoFilters value.
     *
     * @param geoFilters the geoFilters value to set
     * @return the EndpointUpdateParametersInner object itself.
     */
    public EndpointUpdateParametersInner withGeoFilters(List<GeoFilter> geoFilters) {
        this.geoFilters = geoFilters;
        return this;
    }

}
