/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn.implementation;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Output of custom domain validation.
 */
public class ValidateCustomDomainOutputInner {
    /**
     * Indicates whether the custom domain is validated or not.
     */
    @JsonProperty(value = "customDomainValidated")
    private Boolean customDomainValidated;

    /**
     * The reason why the custom domain is not valid.
     */
    @JsonProperty(value = "reason")
    private String reason;

    /**
     * Error message describing why the custom domain is not valid.
     */
    @JsonProperty(value = "message")
    private String message;

    /**
     * Get the customDomainValidated value.
     *
     * @return the customDomainValidated value
     */
    public Boolean customDomainValidated() {
        return this.customDomainValidated;
    }

    /**
     * Set the customDomainValidated value.
     *
     * @param customDomainValidated the customDomainValidated value to set
     * @return the ValidateCustomDomainOutputInner object itself.
     */
    public ValidateCustomDomainOutputInner withCustomDomainValidated(Boolean customDomainValidated) {
        this.customDomainValidated = customDomainValidated;
        return this;
    }

    /**
     * Get the reason value.
     *
     * @return the reason value
     */
    public String reason() {
        return this.reason;
    }

    /**
     * Set the reason value.
     *
     * @param reason the reason value to set
     * @return the ValidateCustomDomainOutputInner object itself.
     */
    public ValidateCustomDomainOutputInner withReason(String reason) {
        this.reason = reason;
        return this;
    }

    /**
     * Get the message value.
     *
     * @return the message value
     */
    public String message() {
        return this.message;
    }

    /**
     * Set the message value.
     *
     * @param message the message value to set
     * @return the ValidateCustomDomainOutputInner object itself.
     */
    public ValidateCustomDomainOutputInner withMessage(String message) {
        this.message = message;
        return this;
    }

}
