/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn;

import java.util.Collection;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.microsoft.rest.ExpandableStringEnum;

/**
 * Defines values for Algorithm.
 */
public final class Algorithm extends ExpandableStringEnum<Algorithm> {
    /** Static value SHA256 for Algorithm. */
    public static final Algorithm SHA256 = fromString("SHA256");

    /**
     * Creates or finds a Algorithm from its string representation.
     * @param name a name to look for
     * @return the corresponding Algorithm
     */
    @JsonCreator
    public static Algorithm fromString(String name) {
        return fromString(name, Algorithm.class);
    }

    /**
     * @return known Algorithm values
     */
    public static Collection<Algorithm> values() {
        return values(Algorithm.class);
    }
}
