/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Certificate used for https.
 */
public class Certificate {
    /**
     * Subject name in the certificate.
     */
    @JsonProperty(value = "subject")
    private String subject;

    /**
     * Certificate expiration date.
     */
    @JsonProperty(value = "expirationDate")
    private String expirationDate;

    /**
     * Certificate thumbprint.
     */
    @JsonProperty(value = "thumbprint")
    private String thumbprint;

    /**
     * Get subject name in the certificate.
     *
     * @return the subject value
     */
    public String subject() {
        return this.subject;
    }

    /**
     * Set subject name in the certificate.
     *
     * @param subject the subject value to set
     * @return the Certificate object itself.
     */
    public Certificate withSubject(String subject) {
        this.subject = subject;
        return this;
    }

    /**
     * Get certificate expiration date.
     *
     * @return the expirationDate value
     */
    public String expirationDate() {
        return this.expirationDate;
    }

    /**
     * Set certificate expiration date.
     *
     * @param expirationDate the expirationDate value to set
     * @return the Certificate object itself.
     */
    public Certificate withExpirationDate(String expirationDate) {
        this.expirationDate = expirationDate;
        return this;
    }

    /**
     * Get certificate thumbprint.
     *
     * @return the thumbprint value
     */
    public String thumbprint() {
        return this.thumbprint;
    }

    /**
     * Set certificate thumbprint.
     *
     * @param thumbprint the thumbprint value to set
     * @return the Certificate object itself.
     */
    public Certificate withThumbprint(String thumbprint) {
        this.thumbprint = thumbprint;
        return this;
    }

}
