/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn;

import java.util.Collection;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.microsoft.rest.ExpandableStringEnum;

/**
 * Defines values for CertificateType.
 */
public final class CertificateType extends ExpandableStringEnum<CertificateType> {
    /** Static value Shared for CertificateType. */
    public static final CertificateType SHARED = fromString("Shared");

    /** Static value Dedicated for CertificateType. */
    public static final CertificateType DEDICATED = fromString("Dedicated");

    /**
     * Creates or finds a CertificateType from its string representation.
     * @param name a name to look for
     * @return the corresponding CertificateType
     */
    @JsonCreator
    public static CertificateType fromString(String name) {
        return fromString(name, CertificateType.class);
    }

    /**
     * @return known CertificateType values
     */
    public static Collection<CertificateType> values() {
        return values(CertificateType.class);
    }
}
