/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn;

import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * Customer Certificate used for https.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "type", defaultImpl = CustomerCertificateParameters.class)
@JsonTypeName("CustomerCertificate")
public class CustomerCertificateParameters extends SecretParameters {
    /**
     * Resource reference to the KV secret.
     */
    @JsonProperty(value = "secretSource", required = true)
    private ResourceReference secretSource;

    /**
     * Version of the secret to be used.
     */
    @JsonProperty(value = "secretVersion")
    private String secretVersion;

    /**
     * Certificate issuing authority.
     */
    @JsonProperty(value = "certificateAuthority")
    private String certificateAuthority;

    /**
     * Whether to use the latest version for the certificate.
     */
    @JsonProperty(value = "useLatestVersion")
    private Boolean useLatestVersion;

    /**
     * The list of SANs.
     */
    @JsonProperty(value = "subjectAlternativeNames")
    private List<String> subjectAlternativeNames;

    /**
     * Get resource reference to the KV secret.
     *
     * @return the secretSource value
     */
    public ResourceReference secretSource() {
        return this.secretSource;
    }

    /**
     * Set resource reference to the KV secret.
     *
     * @param secretSource the secretSource value to set
     * @return the CustomerCertificateParameters object itself.
     */
    public CustomerCertificateParameters withSecretSource(ResourceReference secretSource) {
        this.secretSource = secretSource;
        return this;
    }

    /**
     * Get version of the secret to be used.
     *
     * @return the secretVersion value
     */
    public String secretVersion() {
        return this.secretVersion;
    }

    /**
     * Set version of the secret to be used.
     *
     * @param secretVersion the secretVersion value to set
     * @return the CustomerCertificateParameters object itself.
     */
    public CustomerCertificateParameters withSecretVersion(String secretVersion) {
        this.secretVersion = secretVersion;
        return this;
    }

    /**
     * Get certificate issuing authority.
     *
     * @return the certificateAuthority value
     */
    public String certificateAuthority() {
        return this.certificateAuthority;
    }

    /**
     * Set certificate issuing authority.
     *
     * @param certificateAuthority the certificateAuthority value to set
     * @return the CustomerCertificateParameters object itself.
     */
    public CustomerCertificateParameters withCertificateAuthority(String certificateAuthority) {
        this.certificateAuthority = certificateAuthority;
        return this;
    }

    /**
     * Get whether to use the latest version for the certificate.
     *
     * @return the useLatestVersion value
     */
    public Boolean useLatestVersion() {
        return this.useLatestVersion;
    }

    /**
     * Set whether to use the latest version for the certificate.
     *
     * @param useLatestVersion the useLatestVersion value to set
     * @return the CustomerCertificateParameters object itself.
     */
    public CustomerCertificateParameters withUseLatestVersion(Boolean useLatestVersion) {
        this.useLatestVersion = useLatestVersion;
        return this;
    }

    /**
     * Get the list of SANs.
     *
     * @return the subjectAlternativeNames value
     */
    public List<String> subjectAlternativeNames() {
        return this.subjectAlternativeNames;
    }

    /**
     * Set the list of SANs.
     *
     * @param subjectAlternativeNames the subjectAlternativeNames value to set
     * @return the CustomerCertificateParameters object itself.
     */
    public CustomerCertificateParameters withSubjectAlternativeNames(List<String> subjectAlternativeNames) {
        this.subjectAlternativeNames = subjectAlternativeNames;
        return this;
    }

}
