/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn;

import java.util.Collection;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.microsoft.rest.ExpandableStringEnum;

/**
 * Defines values for DestinationProtocol.
 */
public final class DestinationProtocol extends ExpandableStringEnum<DestinationProtocol> {
    /** Static value MatchRequest for DestinationProtocol. */
    public static final DestinationProtocol MATCH_REQUEST = fromString("MatchRequest");

    /** Static value Http for DestinationProtocol. */
    public static final DestinationProtocol HTTP = fromString("Http");

    /** Static value Https for DestinationProtocol. */
    public static final DestinationProtocol HTTPS = fromString("Https");

    /**
     * Creates or finds a DestinationProtocol from its string representation.
     * @param name a name to look for
     * @return the corresponding DestinationProtocol
     */
    @JsonCreator
    public static DestinationProtocol fromString(String name) {
        return fromString(name, DestinationProtocol.class);
    }

    /**
     * @return known DestinationProtocol values
     */
    public static Collection<DestinationProtocol> values() {
        return values(DestinationProtocol.class);
    }
}
