/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn;

import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Parameters required for content load.
 */
public class LoadParameters {
    /**
     * The path to the content to be loaded. Path should be a relative file URL
     * of the origin.
     */
    @JsonProperty(value = "contentPaths", required = true)
    private List<String> contentPaths;

    /**
     * Get the path to the content to be loaded. Path should be a relative file URL of the origin.
     *
     * @return the contentPaths value
     */
    public List<String> contentPaths() {
        return this.contentPaths;
    }

    /**
     * Set the path to the content to be loaded. Path should be a relative file URL of the origin.
     *
     * @param contentPaths the contentPaths value to set
     * @return the LoadParameters object itself.
     */
    public LoadParameters withContentPaths(List<String> contentPaths) {
        this.contentPaths = contentPaths;
        return this;
    }

}
