/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn;

import org.joda.time.DateTime;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Read only system data.
 */
public class SystemData {
    /**
     * An identifier for the identity that created the resource.
     */
    @JsonProperty(value = "createdBy")
    private String createdBy;

    /**
     * The type of identity that created the resource. Possible values include:
     * 'user', 'application', 'managedIdentity', 'key'.
     */
    @JsonProperty(value = "createdByType")
    private IdentityType createdByType;

    /**
     * The timestamp of resource creation (UTC).
     */
    @JsonProperty(value = "createdAt")
    private DateTime createdAt;

    /**
     * An identifier for the identity that last modified the resource.
     */
    @JsonProperty(value = "lastModifiedBy")
    private String lastModifiedBy;

    /**
     * The type of identity that last modified the resource. Possible values
     * include: 'user', 'application', 'managedIdentity', 'key'.
     */
    @JsonProperty(value = "lastModifiedByType")
    private IdentityType lastModifiedByType;

    /**
     * The timestamp of resource last modification (UTC).
     */
    @JsonProperty(value = "lastModifiedAt")
    private DateTime lastModifiedAt;

    /**
     * Get an identifier for the identity that created the resource.
     *
     * @return the createdBy value
     */
    public String createdBy() {
        return this.createdBy;
    }

    /**
     * Set an identifier for the identity that created the resource.
     *
     * @param createdBy the createdBy value to set
     * @return the SystemData object itself.
     */
    public SystemData withCreatedBy(String createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    /**
     * Get the type of identity that created the resource. Possible values include: 'user', 'application', 'managedIdentity', 'key'.
     *
     * @return the createdByType value
     */
    public IdentityType createdByType() {
        return this.createdByType;
    }

    /**
     * Set the type of identity that created the resource. Possible values include: 'user', 'application', 'managedIdentity', 'key'.
     *
     * @param createdByType the createdByType value to set
     * @return the SystemData object itself.
     */
    public SystemData withCreatedByType(IdentityType createdByType) {
        this.createdByType = createdByType;
        return this;
    }

    /**
     * Get the timestamp of resource creation (UTC).
     *
     * @return the createdAt value
     */
    public DateTime createdAt() {
        return this.createdAt;
    }

    /**
     * Set the timestamp of resource creation (UTC).
     *
     * @param createdAt the createdAt value to set
     * @return the SystemData object itself.
     */
    public SystemData withCreatedAt(DateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    /**
     * Get an identifier for the identity that last modified the resource.
     *
     * @return the lastModifiedBy value
     */
    public String lastModifiedBy() {
        return this.lastModifiedBy;
    }

    /**
     * Set an identifier for the identity that last modified the resource.
     *
     * @param lastModifiedBy the lastModifiedBy value to set
     * @return the SystemData object itself.
     */
    public SystemData withLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
        return this;
    }

    /**
     * Get the type of identity that last modified the resource. Possible values include: 'user', 'application', 'managedIdentity', 'key'.
     *
     * @return the lastModifiedByType value
     */
    public IdentityType lastModifiedByType() {
        return this.lastModifiedByType;
    }

    /**
     * Set the type of identity that last modified the resource. Possible values include: 'user', 'application', 'managedIdentity', 'key'.
     *
     * @param lastModifiedByType the lastModifiedByType value to set
     * @return the SystemData object itself.
     */
    public SystemData withLastModifiedByType(IdentityType lastModifiedByType) {
        this.lastModifiedByType = lastModifiedByType;
        return this;
    }

    /**
     * Get the timestamp of resource last modification (UTC).
     *
     * @return the lastModifiedAt value
     */
    public DateTime lastModifiedAt() {
        return this.lastModifiedAt;
    }

    /**
     * Set the timestamp of resource last modification (UTC).
     *
     * @param lastModifiedAt the lastModifiedAt value to set
     * @return the SystemData object itself.
     */
    public SystemData withLastModifiedAt(DateTime lastModifiedAt) {
        this.lastModifiedAt = lastModifiedAt;
        return this;
    }

}
