/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.cdn;

import java.util.Collection;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.microsoft.rest.ExpandableStringEnum;

/**
 * Defines values for Transform.
 */
public final class Transform extends ExpandableStringEnum<Transform> {
    /** Static value Lowercase for Transform. */
    public static final Transform LOWERCASE = fromString("Lowercase");

    /** Static value Uppercase for Transform. */
    public static final Transform UPPERCASE = fromString("Uppercase");

    /**
     * Creates or finds a Transform from its string representation.
     * @param name a name to look for
     * @return the corresponding Transform
     */
    @JsonCreator
    public static Transform fromString(String name) {
        return fromString(name, Transform.class);
    }

    /**
     * @return known Transform values
     */
    public static Collection<Transform> values() {
        return values(Transform.class);
    }
}
